/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.media.control.AbstractIntControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.EnumControl;
import com.spacekiller.util.media.control.IntControl;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.AudioSwitchBox;
import com.waxmonster.audio.common.AudioSwitchBoxPanel;
import com.waxmonster.midi.AbstractMidiAction;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.Icon;

public class AudioSwitchBoxDevice
extends Device {
    public static final String KEY_CHANNELS = "channels";
    public static final String KEY_INPUT_COUNT = "inputCount";
    public static final String KEY_OUTPUT_COUNT = "outputCount";
    public static final String KEY_INPUT_INDEX = "inputIndex";
    public static final String KEY_OUTPUT_INDEX = "outputIndex";
    public static final String KEY_MIDI_MAPPING_PREFIX = "midiMapping.";
    public static final String KEY_MIDI_MAPPING_COUNT = "midiMappingCount";
    public static final int DEFAULT_CHANNELS = 2;
    public static final int DEFAULT_PORT_COUNT = 4;
    public static final int MAX_PORT_COUNT = 16;
    private static final String INPUT_PORT_PREFIX = "In-";
    private static final String OUTPUT_PORT_PREFIX = "Out-";
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private final MidiSupportImpl midiSupport = new MidiSupportImpl();
    private final InputIndexControl inputIndexControl;
    private final OutputIndexControl outputIndexControl;
    private int channels;
    private int inputCount;
    private int outputCount;
    private AudioInputPort[] audioInputPorts;
    private AudioOutputPort[] audioOutputPorts;
    private MidiInputPort midiInputPort;
    private MidiOutputPort midiOutputPort;
    private MidiAction[] midiActions;
    private MidiMapping[] midiActionMappings;
    private SwitchControlMidiAction incrementInputIndexMidiAction;
    private SwitchControlMidiAction decrementInputIndexMidiAction;
    private SwitchControlMidiAction incrementOutputIndexMidiAction;
    private SwitchControlMidiAction decrementOutputIndexMidiAction;
    private AudioSwitchBox audioSwitchBox;
    private AudioSwitchBoxPanel audioSwitchBoxPanel;

    public AudioSwitchBoxDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        this(provider, name, iconColor16, 2, 4, 4);
    }

    public AudioSwitchBoxDevice(DeviceProvider provider, String name, Icon iconColor16, int channels, int inputCount, int outputCount) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.channels = channels;
        this.inputCount = 0;
        this.outputCount = 0;
        this.audioInputPorts = new AudioInputPort[0];
        this.audioOutputPorts = new AudioOutputPort[0];
        this.inputIndexControl = new InputIndexControl();
        this.outputIndexControl = new OutputIndexControl();
        this.incrementInputIndexMidiAction = new SwitchControlMidiAction("IncrementInputIndex", true, 1);
        this.decrementInputIndexMidiAction = new SwitchControlMidiAction("DecrementInputIndex", true, -1);
        this.incrementOutputIndexMidiAction = new SwitchControlMidiAction("IncrementOutputIndex", false, 1);
        this.decrementOutputIndexMidiAction = new SwitchControlMidiAction("DecrementOutputIndex", false, -1);
        this.midiInputPort = new MidiInputPort("MIDI-In", MidiInputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.midiOutputPort = new MidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.addControl((Control)this.inputIndexControl);
        this.addControl((Control)this.outputIndexControl);
        this.initMidiActions();
        this.setInputCount(inputCount);
        this.setOutputCount(outputCount);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
        this.midiSupport.reset();
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        props.put(KEY_CHANNELS, String.valueOf(this.channels));
        props.put(KEY_INPUT_COUNT, String.valueOf(this.inputCount));
        props.put(KEY_OUTPUT_COUNT, String.valueOf(this.outputCount));
        props.remove(KEY_INPUT_INDEX);
        props.remove(KEY_OUTPUT_INDEX);
        MidiMapping[] midiActionMappings = this.getMidiActionMappings();
        int num = midiActionMappings == null ? 0 : midiActionMappings.length;
        props.put(KEY_MIDI_MAPPING_COUNT, String.valueOf(num));
        for (int i = 0; i < num; ++i) {
            MidiMapping mam = midiActionMappings[i];
            if (mam == null) continue;
            String key = KEY_MIDI_MAPPING_PREFIX + String.valueOf(1000 + i).substring(1);
            String value = mam.toString();
            props.put(key, value);
        }
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        String sOutputIndex;
        String sInputIndex;
        String sOutputCount;
        String sInputCount;
        String sChannels = newProperties.getProperty(KEY_CHANNELS);
        if (sChannels != null) {
            this.applyProperty(KEY_CHANNELS, sChannels);
        }
        if ((sInputCount = newProperties.getProperty(KEY_INPUT_COUNT)) != null) {
            this.applyProperty(KEY_INPUT_COUNT, sInputCount);
        }
        if ((sOutputCount = newProperties.getProperty(KEY_OUTPUT_COUNT)) != null) {
            this.applyProperty(KEY_OUTPUT_COUNT, sOutputCount);
        }
        if ((sInputIndex = newProperties.getProperty(KEY_INPUT_INDEX)) != null) {
            this.applyProperty(KEY_INPUT_INDEX, sInputIndex);
        }
        if ((sOutputIndex = newProperties.getProperty(KEY_OUTPUT_INDEX)) != null) {
            this.applyProperty(KEY_OUTPUT_INDEX, sOutputIndex);
        }
        TreeMap<String, MidiMapping> newMidiMappings = new TreeMap<String, MidiMapping>();
        int midiMappingCount = 0;
        String midiMappingCountValue = newProperties.getProperty(KEY_MIDI_MAPPING_COUNT);
        if (midiMappingCountValue != null) {
            try {
                midiMappingCount = Integer.parseInt(midiMappingCountValue.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (Map.Entry<Object, Object> me : newProperties.entrySet()) {
            String key = String.valueOf(me.getKey());
            if (!key.startsWith(KEY_MIDI_MAPPING_PREFIX)) continue;
            try {
                String value;
                MidiMapping mapping;
                int index = Integer.parseInt(key.substring(KEY_MIDI_MAPPING_PREFIX.length()));
                if (index < 0 || index >= midiMappingCount || (mapping = MidiMapping.parseMidiMapping((String)(value = String.valueOf(me.getValue())))) == null) continue;
                newMidiMappings.put(key, mapping);
            }
            catch (NumberFormatException e) {}
        }
        this.setMidiActionMappings(newMidiMappings.values().toArray(new MidiMapping[newMidiMappings.size()]));
        super.setProperties(newProperties);
    }

    protected void applyProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (KEY_CHANNELS.equals(key)) {
            try {
                this.setChannels(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (KEY_INPUT_COUNT.equals(key)) {
            try {
                this.setInputCount(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (KEY_OUTPUT_COUNT.equals(key)) {
            try {
                this.setOutputCount(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (KEY_INPUT_INDEX.equals(key)) {
            this.inputIndexControl.setInt(this.parseIntProperty(key, value));
            return;
        }
        if (KEY_OUTPUT_INDEX.equals(key)) {
            this.outputIndexControl.setInt(this.parseIntProperty(key, value));
            return;
        }
    }

    public IntControl getInputIndexControl() {
        return this.inputIndexControl;
    }

    public IntControl getOutputIndexControl() {
        return this.outputIndexControl;
    }

    public synchronized int getInputCount() {
        return this.inputCount;
    }

    public synchronized void setInputCount(int inputCount) throws StudioException {
        if (inputCount < 1) {
            throw new IllegalArgumentException("Invalid number of input ports: " + inputCount + " < 1");
        }
        if (inputCount > 16) {
            throw new IllegalArgumentException("Invalid number of input ports: " + inputCount + " > " + 16);
        }
        int oldCount = this.inputCount;
        if (oldCount == inputCount) {
            return;
        }
        AudioInputPortType inputPortType = AudioInputPortType.getAudioInputPortType((int)this.channels);
        AudioInputPort[] newInputPorts = new AudioInputPort[inputCount];
        if (inputCount > oldCount) {
            if (oldCount > 0) {
                System.arraycopy(this.audioInputPorts, 0, newInputPorts, 0, oldCount);
            }
            for (int i = oldCount; i < inputCount; ++i) {
                String portName = this.getInputPortName(i);
                newInputPorts[i] = new AudioInputPort(portName, inputPortType, (AudioSupport)this.audioSupport);
            }
        } else {
            System.arraycopy(this.audioInputPorts, 0, newInputPorts, 0, inputCount);
        }
        this.inputCount = inputCount;
        this.audioInputPorts = newInputPorts;
        this.inputIndexControl.setMaximum(inputCount - 1);
        if (this.inputIndexControl.getInt() >= inputCount) {
            this.inputIndexControl.setInt(0);
        }
        this.refreshPorts();
    }

    public synchronized int getOutputCount() {
        return this.outputCount;
    }

    public synchronized void setOutputCount(int outputCount) throws StudioException {
        if (outputCount < 1) {
            throw new IllegalArgumentException("Invalid number of output ports: " + outputCount + " < 1");
        }
        if (outputCount > 16) {
            throw new IllegalArgumentException("Invalid number of output ports: " + outputCount + " > " + 16);
        }
        int oldCount = this.outputCount;
        if (oldCount == outputCount) {
            return;
        }
        AudioOutputPortType outputPortType = AudioOutputPortType.getAudioOutputPortType((int)this.channels);
        AudioOutputPort[] newOutputPorts = new AudioOutputPort[outputCount];
        if (outputCount > oldCount) {
            if (oldCount > 0) {
                System.arraycopy(this.audioOutputPorts, 0, newOutputPorts, 0, oldCount);
            }
            for (int i = oldCount; i < outputCount; ++i) {
                String portName = this.getOutputPortName(i);
                newOutputPorts[i] = new AudioOutputPort(portName, outputPortType, (AudioSupport)this.audioSupport);
            }
        } else {
            System.arraycopy(this.audioOutputPorts, 0, newOutputPorts, 0, outputCount);
        }
        this.outputCount = outputCount;
        this.audioOutputPorts = newOutputPorts;
        this.outputIndexControl.setMaximum(outputCount - 1);
        if (this.outputIndexControl.getInt() >= outputCount) {
            this.outputIndexControl.setInt(0);
        }
        this.refreshPorts();
    }

    public synchronized int getChannels() {
        return this.channels;
    }

    public synchronized void setChannels(int channels) throws StudioException {
        if (channels < 1) {
            throw new IllegalArgumentException("Invalid number of audio channels: " + channels + " < 1");
        }
        int oldChannels = this.channels;
        if (oldChannels == channels) {
            return;
        }
        AudioInputPortType inputPortType = AudioInputPortType.getAudioInputPortType((int)channels);
        AudioOutputPortType outputPortType = AudioOutputPortType.getAudioOutputPortType((int)channels);
        AudioInputPort[] newInputPorts = new AudioInputPort[this.inputCount];
        for (int i = 0; i < this.inputCount; ++i) {
            String portName = this.getInputPortName(i);
            newInputPorts[i] = new AudioInputPort(portName, inputPortType, (AudioSupport)this.audioSupport);
        }
        AudioOutputPort[] newOutputPorts = new AudioOutputPort[this.outputCount];
        for (int i = 0; i < this.outputCount; ++i) {
            String portName = this.getOutputPortName(i);
            newOutputPorts[i] = new AudioOutputPort(portName, outputPortType, (AudioSupport)this.audioSupport);
        }
        this.channels = channels;
        this.audioInputPorts = newInputPorts;
        this.audioOutputPorts = newOutputPorts;
        this.refreshPorts();
    }

    public synchronized Component getCustomizer() {
        if (this.audioSwitchBoxPanel == null) {
            this.audioSwitchBoxPanel = new AudioSwitchBoxPanel();
            this.audioSwitchBoxPanel.setOpaque(false);
            this.audioSwitchBoxPanel.setDevice(this);
        }
        return this.audioSwitchBoxPanel;
    }

    protected synchronized void refreshPorts() throws StudioException {
        int i;
        Studio studio = this.getStudio();
        Port[] oldPorts = this.getPorts();
        LinkedList<Object> newInputPorts = new LinkedList<Object>();
        LinkedList<Object> newOutputPorts = new LinkedList<Object>();
        newInputPorts.add(this.midiInputPort);
        newOutputPorts.add(this.midiOutputPort);
        for (i = 0; i < this.inputCount; ++i) {
            newInputPorts.add(this.audioInputPorts[i]);
        }
        for (i = 0; i < this.outputCount; ++i) {
            newOutputPorts.add(this.audioOutputPorts[i]);
        }
        HashSet<Port> oldPortSet = new HashSet<Port>();
        for (int i2 = 0; i2 < oldPorts.length; ++i2) {
            oldPortSet.add(oldPorts[i2]);
        }
        int nextPortIndex = 0;
        ArrayList<Object> newPorts = new ArrayList<Object>(newInputPorts.size() + newOutputPorts.size());
        newPorts.addAll(newInputPorts);
        newPorts.addAll(newOutputPorts);
        for (Port port : newPorts) {
            if (port == null) continue;
            oldPortSet.remove(port);
            if (port.getDevice() == this) {
                this.removePort(port);
            }
            this.insertPortAt(port, nextPortIndex);
            ++nextPortIndex;
        }
        for (Port port : oldPortSet) {
            if (port == null) continue;
            if (studio != null) {
                studio.disconnect(port);
            }
            this.removePort(port);
        }
    }

    protected String getInputPortName(int index) {
        return INPUT_PORT_PREFIX + (index + 1);
    }

    protected String getOutputPortName(int index) {
        return OUTPUT_PORT_PREFIX + (index + 1);
    }

    protected int getInputPortIndex(String portName) {
        if (portName != null && portName.startsWith(INPUT_PORT_PREFIX)) {
            String s = portName.substring(INPUT_PORT_PREFIX.length()).trim();
            try {
                return Integer.parseInt(s) - 1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    protected int getOutputPortIndex(String portName) {
        if (portName != null && portName.startsWith(OUTPUT_PORT_PREFIX)) {
            String s = portName.substring(OUTPUT_PORT_PREFIX.length()).trim();
            try {
                return Integer.parseInt(s) - 1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public MidiMapping[] getMidiActionMappings() {
        return this.midiActionMappings;
    }

    public void setMidiActionMappings(MidiMapping[] midiActionMappings) {
        this.midiActionMappings = midiActionMappings;
        this.midiSupport.applyMidiActionMappings();
    }

    public MidiAction[] getAvailableMidiActions() {
        return this.midiActions;
    }

    protected void initMidiActions() {
        this.midiActions = new MidiAction[]{this.incrementInputIndexMidiAction, this.decrementInputIndexMidiAction, this.incrementOutputIndexMidiAction, this.decrementOutputIndexMidiAction};
    }

    protected SwitchControlMidiAction getIncrementInputIndexMidiAction() {
        return this.incrementInputIndexMidiAction;
    }

    protected SwitchControlMidiAction getDecrementInputIndexMidiAction() {
        return this.decrementInputIndexMidiAction;
    }

    protected SwitchControlMidiAction getIncrementOutputIndexMidiAction() {
        return this.incrementOutputIndexMidiAction;
    }

    protected SwitchControlMidiAction getDecrementOutputIndexMidiAction() {
        return this.decrementOutputIndexMidiAction;
    }

    protected class OutputIndexControl
    extends AbstractIntControl
    implements EnumControl {
        public OutputIndexControl() {
            this.setName("outputPort");
            this.setTooltip("Switch output port");
            this.setMinimum(0);
            this.setMaximum(0);
            this.setInt(0);
        }

        public Object[] getValues() {
            int num = AudioSwitchBoxDevice.this.outputCount;
            Object[] portNames = new Object[num];
            for (int i = 0; i < num; ++i) {
                portNames[i] = AudioSwitchBoxDevice.this.getOutputPortName(i);
            }
            return portNames;
        }

        public Object getValue() {
            return AudioSwitchBoxDevice.this.getOutputPortName(this.getInt());
        }

        public void setValue(Object value) {
            if (value != null) {
                int index;
                if (value instanceof Number) {
                    super.setValue(value);
                }
                if ((index = AudioSwitchBoxDevice.this.getOutputPortIndex(String.valueOf(value))) >= 0) {
                    this.setInt(index);
                }
            }
        }

        public boolean isValueSupported(Object value) {
            if (value != null) {
                if (value instanceof Number) {
                    return true;
                }
                int index = AudioSwitchBoxDevice.this.getOutputPortIndex(String.valueOf(value));
                if (index >= 0) {
                    return true;
                }
            }
            return false;
        }

        protected void applyInt(int v) {
            AudioSwitchBox box = AudioSwitchBoxDevice.this.audioSwitchBox;
            if (box != null) {
                box.switchOutput(v);
            }
        }

        protected void setMaximum(int maximum) {
            super.setMaximum(maximum);
        }
    }

    protected class InputIndexControl
    extends AbstractIntControl
    implements EnumControl {
        public InputIndexControl() {
            this.setName("inputPort");
            this.setTooltip("Switch input port");
            this.setMinimum(0);
            this.setMaximum(0);
            this.setInt(0);
        }

        public Object[] getValues() {
            int num = AudioSwitchBoxDevice.this.inputCount;
            Object[] portNames = new Object[num];
            for (int i = 0; i < num; ++i) {
                portNames[i] = AudioSwitchBoxDevice.this.getInputPortName(i);
            }
            return portNames;
        }

        public Object getValue() {
            return AudioSwitchBoxDevice.this.getInputPortName(this.getInt());
        }

        public void setValue(Object value) {
            if (value != null) {
                int index;
                if (value instanceof Number) {
                    super.setValue(value);
                }
                if ((index = AudioSwitchBoxDevice.this.getInputPortIndex(String.valueOf(value))) >= 0) {
                    this.setInt(index);
                }
            }
        }

        public boolean isValueSupported(Object value) {
            if (value != null) {
                if (value instanceof Number) {
                    return true;
                }
                int index = AudioSwitchBoxDevice.this.getInputPortIndex(String.valueOf(value));
                if (index >= 0) {
                    return true;
                }
            }
            return false;
        }

        protected void applyInt(int v) {
            AudioSwitchBox box = AudioSwitchBoxDevice.this.audioSwitchBox;
            if (box != null) {
                box.switchInput(v);
            }
        }

        protected void setMaximum(int maximum) {
            super.setMaximum(maximum);
        }
    }

    protected class SwitchControlMidiAction
    extends AbstractMidiAction {
        private final boolean input;
        private final int increment;

        public SwitchControlMidiAction(String name, boolean input, int increment) {
            super(name);
            this.input = input;
            this.increment = increment;
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 144: {
                        if (data2 > 0) {
                            if (this.input) {
                                int newIndex;
                                for (newIndex = AudioSwitchBoxDevice.this.inputIndexControl.getInt() + this.increment; newIndex < 0; newIndex += AudioSwitchBoxDevice.this.inputCount) {
                                }
                                if (newIndex >= AudioSwitchBoxDevice.this.inputCount) {
                                    newIndex = 0;
                                }
                                AudioSwitchBoxDevice.this.inputIndexControl.setInt(newIndex);
                            } else {
                                int newIndex;
                                for (newIndex = AudioSwitchBoxDevice.this.outputIndexControl.getInt() + this.increment; newIndex < 0; newIndex += AudioSwitchBoxDevice.this.outputCount) {
                                }
                                if (newIndex >= AudioSwitchBoxDevice.this.outputCount) {
                                    newIndex = 0;
                                }
                                AudioSwitchBoxDevice.this.outputIndexControl.setInt(newIndex);
                            }
                        }
                        return;
                    }
                    case 176: {
                        if (this.input) {
                            int newIndex = data2;
                            if (newIndex >= AudioSwitchBoxDevice.this.inputCount) {
                                newIndex = AudioSwitchBoxDevice.this.inputCount - 1;
                            }
                            AudioSwitchBoxDevice.this.inputIndexControl.setInt(newIndex);
                        } else {
                            int newIndex = data2;
                            if (newIndex >= AudioSwitchBoxDevice.this.outputCount) {
                                newIndex = AudioSwitchBoxDevice.this.outputCount - 1;
                            }
                            AudioSwitchBoxDevice.this.outputIndexControl.setInt(newIndex);
                        }
                        return;
                    }
                    case 192: {
                        int program = data1;
                        if (this.input) {
                            int newIndex = program;
                            if (newIndex >= AudioSwitchBoxDevice.this.inputCount) {
                                newIndex = AudioSwitchBoxDevice.this.inputCount - 1;
                            }
                            AudioSwitchBoxDevice.this.inputIndexControl.setInt(newIndex);
                        } else {
                            int newIndex = program;
                            if (newIndex >= AudioSwitchBoxDevice.this.outputCount) {
                                newIndex = AudioSwitchBoxDevice.this.outputCount - 1;
                            }
                            AudioSwitchBoxDevice.this.outputIndexControl.setInt(newIndex);
                        }
                        return;
                    }
                }
            }
        }
    }

    protected class MidiSyncGroupImpl
    extends MidiSyncGroup {
        private Map procs;

        public MidiSyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
            this.procs = new HashMap();
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
            if (targets.length != 1) {
                throw new MidiException("Invalid number of target ports: " + targets.length + " != 1");
            }
        }

        public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            MidiActionProcessor proc = (MidiActionProcessor)this.procs.get(port);
            if (proc == null) {
                proc = new MidiActionProcessor(this.getName());
                this.procs.put(port, proc);
                this.applyMidiActionMappings(proc);
            }
            return proc;
        }

        protected void applyMidiActionMappings() {
            for (MidiActionProcessor proc : this.procs.values()) {
                if (proc == null) continue;
                this.applyMidiActionMappings(proc);
            }
        }

        protected void applyMidiActionMappings(MidiActionProcessor proc) {
            proc.reset(AudioSwitchBoxDevice.this.getAvailableMidiActions(), AudioSwitchBoxDevice.this.getMidiActionMappings());
            proc.validate();
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroupImpl syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.syncGroup == null) {
                MidiInputPort[] inputPorts = new MidiInputPort[]{AudioSwitchBoxDevice.this.midiInputPort};
                MidiOutputPort[] outputPorts = new MidiOutputPort[]{AudioSwitchBoxDevice.this.midiOutputPort};
                this.syncGroup = new MidiSyncGroupImpl(AudioSwitchBoxDevice.this.getTitleOrName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }

        protected void applyMidiActionMappings() {
            MidiSyncGroupImpl group = this.syncGroup;
            if (group != null) {
                group.applyMidiActionMappings();
            }
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            if (in.length != AudioSwitchBoxDevice.this.inputCount) {
                throw new AudioException("Invalid number of input buffers: " + in.length + " != " + AudioSwitchBoxDevice.this.inputCount);
            }
            if (out.length != AudioSwitchBoxDevice.this.outputCount) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != " + AudioSwitchBoxDevice.this.outputCount);
            }
            int inputIndex = AudioSwitchBoxDevice.this.inputIndexControl.getInt();
            int outputIndex = AudioSwitchBoxDevice.this.outputIndexControl.getInt();
            AudioSwitchBox box = new AudioSwitchBox(in, inputIndex, out, outputIndex);
            AudioSwitchBoxDevice.this.audioSwitchBox = box;
            return box;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
                AudioSwitchBoxDevice.this.audioSwitchBox = null;
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                AudioInputPort[] inputPorts = new AudioInputPort[AudioSwitchBoxDevice.this.inputCount];
                System.arraycopy(AudioSwitchBoxDevice.this.audioInputPorts, 0, inputPorts, 0, AudioSwitchBoxDevice.this.inputCount);
                AudioOutputPort[] outputPorts = new AudioOutputPort[AudioSwitchBoxDevice.this.outputCount];
                System.arraycopy(AudioSwitchBoxDevice.this.audioOutputPorts, 0, outputPorts, 0, AudioSwitchBoxDevice.this.outputCount);
                this.syncGroup = new AudioSyncGroupImpl(AudioSwitchBoxDevice.this.getName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }
    }
}

