/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.media.control.ComboBoxControlPanel;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.IntControl;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.waxmonster.audio.common.AudioSwitchBoxDevice;
import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.AbstractMidiMapper;
import com.waxmonster.midi.common.MidiMappingManagerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AudioSwitchBoxPanel
extends JPanel
implements MidiMappable {
    private static final long serialVersionUID = 7992576010248587123L;
    private static final Logger logger = Logger.getLogger(AudioSwitchBoxPanel.class.getName());
    private static final String CHANNELS_MONO = "Mono";
    private static final String CHANNELS_STEREO = "Stereo";
    private AudioSwitchBoxDevice device;
    private final MidiMapperImpl midiMapper = new MidiMapperImpl();
    private boolean refreshing = false;
    private JComboBox comboBoxChannels;
    private JComboBox comboBoxInputCount;
    private JComboBox comboBoxOutputCount;
    private JLabel lblMidiMappings;
    private JButton btnEdit;
    private JPanel panel_1;
    private ComboBoxControlPanel inputComboBoxControlPanel;
    private ComboBoxControlPanel outputComboBoxControlPanel;

    public AudioSwitchBoxPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(4, 4, 4, 4);
        gbc_panel_1.weighty = 1.0;
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        this.add((Component)this.panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel_1.setLayout(gbl_panel_1);
        JLabel lblChannels = new JLabel("Channels:");
        GridBagConstraints gbc_lblChannels = new GridBagConstraints();
        gbc_lblChannels.anchor = 17;
        gbc_lblChannels.insets = new Insets(0, 0, 5, 5);
        gbc_lblChannels.gridx = 0;
        gbc_lblChannels.gridy = 0;
        this.panel_1.add((Component)lblChannels, gbc_lblChannels);
        this.comboBoxChannels = new JComboBox();
        GridBagConstraints gbc_comboBoxChannels = new GridBagConstraints();
        gbc_comboBoxChannels.fill = 2;
        gbc_comboBoxChannels.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxChannels.gridx = 1;
        gbc_comboBoxChannels.gridy = 0;
        this.panel_1.add((Component)this.comboBoxChannels, gbc_comboBoxChannels);
        this.comboBoxChannels.setOpaque(false);
        JLabel lblInputPorts = new JLabel("Input Ports:");
        GridBagConstraints gbc_lblInputPorts = new GridBagConstraints();
        gbc_lblInputPorts.anchor = 17;
        gbc_lblInputPorts.insets = new Insets(0, 0, 5, 5);
        gbc_lblInputPorts.gridx = 0;
        gbc_lblInputPorts.gridy = 1;
        this.panel_1.add((Component)lblInputPorts, gbc_lblInputPorts);
        this.comboBoxInputCount = new JComboBox();
        GridBagConstraints gbc_comboBoxInputCount = new GridBagConstraints();
        gbc_comboBoxInputCount.fill = 2;
        gbc_comboBoxInputCount.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxInputCount.gridx = 1;
        gbc_comboBoxInputCount.gridy = 1;
        this.panel_1.add((Component)this.comboBoxInputCount, gbc_comboBoxInputCount);
        this.comboBoxInputCount.setOpaque(false);
        JLabel lblOutputPorts = new JLabel("Output Ports:");
        GridBagConstraints gbc_lblOutputPorts = new GridBagConstraints();
        gbc_lblOutputPorts.anchor = 17;
        gbc_lblOutputPorts.insets = new Insets(0, 0, 5, 5);
        gbc_lblOutputPorts.gridx = 0;
        gbc_lblOutputPorts.gridy = 2;
        this.panel_1.add((Component)lblOutputPorts, gbc_lblOutputPorts);
        this.comboBoxOutputCount = new JComboBox();
        GridBagConstraints gbc_comboBoxOutputCount = new GridBagConstraints();
        gbc_comboBoxOutputCount.fill = 2;
        gbc_comboBoxOutputCount.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxOutputCount.gridx = 1;
        gbc_comboBoxOutputCount.gridy = 2;
        this.panel_1.add((Component)this.comboBoxOutputCount, gbc_comboBoxOutputCount);
        this.comboBoxOutputCount.setOpaque(false);
        this.lblMidiMappings = new JLabel("MIDI Events:");
        GridBagConstraints gbc_lblMidiMappings = new GridBagConstraints();
        gbc_lblMidiMappings.anchor = 17;
        gbc_lblMidiMappings.insets = new Insets(0, 0, 5, 5);
        gbc_lblMidiMappings.gridx = 0;
        gbc_lblMidiMappings.gridy = 3;
        this.panel_1.add((Component)this.lblMidiMappings, gbc_lblMidiMappings);
        this.btnEdit = new JButton("Mappings");
        this.btnEdit.setToolTipText("Edit MIDI mapping(s)...");
        this.btnEdit.setIcon(new ImageIcon(AudioSwitchBoxPanel.class.getResource("/com/waxmonster/midi/common/icons/midi_mapping_icon16.png")));
        GridBagConstraints gbc_btnEdit = new GridBagConstraints();
        gbc_btnEdit.anchor = 17;
        gbc_btnEdit.insets = new Insets(0, 0, 5, 0);
        gbc_btnEdit.gridx = 1;
        gbc_btnEdit.gridy = 3;
        this.panel_1.add((Component)this.btnEdit, gbc_btnEdit);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioSwitchBoxPanel.this.showMidiMappingDialog();
            }
        });
        this.btnEdit.setMargin(new Insets(2, 4, 2, 4));
        JLabel lblInputSwitch = new JLabel("Input Switch:");
        GridBagConstraints gbc_lblInputSwitch = new GridBagConstraints();
        gbc_lblInputSwitch.anchor = 17;
        gbc_lblInputSwitch.insets = new Insets(0, 0, 5, 5);
        gbc_lblInputSwitch.gridx = 0;
        gbc_lblInputSwitch.gridy = 4;
        this.panel_1.add((Component)lblInputSwitch, gbc_lblInputSwitch);
        this.inputComboBoxControlPanel = new ComboBoxControlPanel();
        GridBagConstraints gbc_inputComboBoxControlPanel = new GridBagConstraints();
        gbc_inputComboBoxControlPanel.insets = new Insets(0, 0, 5, 0);
        gbc_inputComboBoxControlPanel.fill = 1;
        gbc_inputComboBoxControlPanel.gridx = 1;
        gbc_inputComboBoxControlPanel.gridy = 4;
        this.panel_1.add((Component)this.inputComboBoxControlPanel, gbc_inputComboBoxControlPanel);
        JLabel lblOutputSwitch = new JLabel("Output Switch:");
        GridBagConstraints gbc_lblOutputSwitch = new GridBagConstraints();
        gbc_lblOutputSwitch.anchor = 17;
        gbc_lblOutputSwitch.insets = new Insets(0, 0, 0, 5);
        gbc_lblOutputSwitch.gridx = 0;
        gbc_lblOutputSwitch.gridy = 5;
        this.panel_1.add((Component)lblOutputSwitch, gbc_lblOutputSwitch);
        this.outputComboBoxControlPanel = new ComboBoxControlPanel();
        GridBagConstraints gbc_outputComboBoxControlPanel = new GridBagConstraints();
        gbc_outputComboBoxControlPanel.fill = 1;
        gbc_outputComboBoxControlPanel.gridx = 1;
        gbc_outputComboBoxControlPanel.gridy = 5;
        this.panel_1.add((Component)this.outputComboBoxControlPanel, gbc_outputComboBoxControlPanel);
        this.comboBoxOutputCount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioSwitchBoxPanel.this.refreshing) {
                    AudioSwitchBoxPanel.this.applyOutputCount();
                }
            }
        });
        this.comboBoxInputCount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioSwitchBoxPanel.this.refreshing) {
                    AudioSwitchBoxPanel.this.applyInputCount();
                }
            }
        });
        this.comboBoxChannels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioSwitchBoxPanel.this.refreshing) {
                    AudioSwitchBoxPanel.this.applyChannels();
                }
            }
        });
    }

    public AudioSwitchBoxDevice getDevice() {
        return this.device;
    }

    public void setDevice(AudioSwitchBoxDevice device) {
        this.device = device;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            int i;
            this.refreshing = true;
            this.midiMapper.unregisterAllMidiActions();
            this.comboBoxChannels.removeAllItems();
            this.comboBoxInputCount.removeAllItems();
            this.comboBoxOutputCount.removeAllItems();
            int channels = 2;
            int inputCount = 0;
            int outputCount = 0;
            IntControl inputSwitchControl = null;
            IntControl outputSwitchControl = null;
            if (this.device != null) {
                channels = this.device.getChannels();
                inputCount = this.device.getInputCount();
                outputCount = this.device.getOutputCount();
                inputSwitchControl = this.device.getInputIndexControl();
                outputSwitchControl = this.device.getOutputIndexControl();
                this.midiMapper.registerMidiAction(this.inputComboBoxControlPanel, this.device.getIncrementInputIndexMidiAction().getName());
                this.midiMapper.registerMidiAction(this.outputComboBoxControlPanel, this.device.getIncrementOutputIndexMidiAction().getName());
            }
            this.comboBoxChannels.addItem(CHANNELS_MONO);
            this.comboBoxChannels.addItem(CHANNELS_STEREO);
            switch (channels) {
                case 1: {
                    this.comboBoxChannels.setSelectedItem(CHANNELS_MONO);
                    break;
                }
                case 2: {
                    this.comboBoxChannels.setSelectedItem(CHANNELS_STEREO);
                    break;
                }
                default: {
                    String item = String.valueOf(channels);
                    this.comboBoxChannels.addItem(item);
                    this.comboBoxChannels.setSelectedItem(item);
                }
            }
            for (i = 1; i <= 16; ++i) {
                this.comboBoxInputCount.addItem(Integer.toString(i));
            }
            this.comboBoxInputCount.setSelectedItem(Integer.toString(inputCount));
            for (i = 1; i <= 16; ++i) {
                this.comboBoxOutputCount.addItem(Integer.toString(i));
            }
            this.comboBoxOutputCount.setSelectedItem(Integer.toString(outputCount));
            this.inputComboBoxControlPanel.setControl((Control)inputSwitchControl);
            this.outputComboBoxControlPanel.setControl((Control)outputSwitchControl);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void applyChannels() {
        try {
            if (this.device != null) {
                Object item = this.getComboBoxChannels().getSelectedItem();
                int newChannels = CHANNELS_MONO == item ? 1 : (CHANNELS_STEREO == item ? 2 : Integer.parseInt(String.valueOf(item)));
                this.device.setChannels(newChannels);
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void applyInputCount() {
        try {
            if (this.device != null) {
                Object item = this.getComboBoxInputCount().getSelectedItem();
                int newInputCount = Integer.parseInt(String.valueOf(item));
                this.device.setInputCount(newInputCount);
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void applyOutputCount() {
        try {
            if (this.device != null) {
                Object item = this.getComboBoxOutputCount().getSelectedItem();
                int newOutputCount = Integer.parseInt(String.valueOf(item));
                this.device.setOutputCount(newOutputCount);
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JComboBox getComboBoxChannels() {
        return this.comboBoxChannels;
    }

    protected JComboBox getComboBoxInputCount() {
        return this.comboBoxInputCount;
    }

    protected JComboBox getComboBoxOutputCount() {
        return this.comboBoxOutputCount;
    }

    protected void showMidiMappingDialog() {
        if (this.device == null) {
            return;
        }
        try {
            MidiMappingManagerPanel panel = new MidiMappingManagerPanel();
            panel.setStudio(this.device.getStudio());
            panel.setDeviceName(this.device.getName() + "-MidiMapping");
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter((MidiFormatter)DefaultMidiFormatter.getSharedInstance());
            panel.setAvailableActions(this.device.getAvailableMidiActions());
            MidiMapping[] origMappings = this.device.getMidiActionMappings();
            int origCount = origMappings == null ? 0 : origMappings.length;
            MidiMapping[] cloneMappings = new MidiMapping[origCount];
            if (origCount > 0) {
                System.arraycopy(origMappings, 0, cloneMappings, 0, origCount);
            }
            panel.setMappings(cloneMappings);
            String title = "MIDI Mappings";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiMapping[] newMappings = panel.getMappings();
            this.device.setMidiActionMappings(newMappings);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected ComboBoxControlPanel getInputComboBoxControlPanel() {
        return this.inputComboBoxControlPanel;
    }

    protected ComboBoxControlPanel getOutputComboBoxControlPanel() {
        return this.outputComboBoxControlPanel;
    }

    public MidiMapper getMidiMapper() {
        return this.midiMapper;
    }

    protected class MidiMapperImpl
    extends AbstractMidiMapper {
        protected MidiMapperImpl() {
        }

        public MidiMapping[] getMidiMappings(Object component) {
            return AudioSwitchBoxPanel.this.device.getMidiActionMappings();
        }

        public void setMidiMappings(Object component, MidiMapping[] mappings) {
            AudioSwitchBoxPanel.this.device.setMidiActionMappings(mappings);
        }
    }
}

