/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.audio.common.AudioDelayDevice;
import com.waxmonster.audio.common.AudioDelayDeviceInfo;
import com.waxmonster.audio.common.AudioDitherDevice;
import com.waxmonster.audio.common.AudioDitherDeviceInfo;
import com.waxmonster.audio.common.AudioMonitorDevice;
import com.waxmonster.audio.common.AudioMonitorDeviceInfo;
import com.waxmonster.audio.common.AudioSwitchBoxDevice;
import com.waxmonster.audio.common.AudioSwitchBoxDeviceInfo;
import com.waxmonster.audio.common.RmsMeterDevice;
import com.waxmonster.audio.common.RmsMeterDeviceInfo;
import com.waxmonster.audio.common.StereoJoinerDevice;
import com.waxmonster.audio.common.StereoJoinerDeviceInfo;
import com.waxmonster.audio.common.StereoMixerDevice;
import com.waxmonster.audio.common.StereoMixerDeviceInfo;
import com.waxmonster.audio.common.StereoSplitterDevice;
import com.waxmonster.audio.common.StereoSplitterDeviceInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import javax.swing.Icon;

public class CommonAudioDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "CommonAudioDeviceProvider";
    public static final String DEVICE_CATEGORY_NAME = "Audio Tools";

    public CommonAudioDeviceProvider() {
        super(PROVIDER_NAME);
        this.initCommonAudioDeviceProvider();
    }

    protected void initCommonAudioDeviceProvider() {
        String name = "Audio Monitor";
        String tooltip = "Audio monitor";
        Icon monitorIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_audio_monitor_icon16.png");
        AudioMonitorDeviceInfo monitorInfo = new AudioMonitorDeviceInfo(name, tooltip, monitorIcon);
        this.addDeviceInfo(monitorInfo);
        name = "Stereo Joiner";
        tooltip = "Joins left/right mono input to a stereo output";
        Icon stereoJoinerIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_stereo_joiner_icon16.png");
        StereoJoinerDeviceInfo stereoJoiner = new StereoJoinerDeviceInfo(name, tooltip, stereoJoinerIcon);
        this.addDeviceInfo(stereoJoiner);
        name = "Stereo Splitter";
        tooltip = "Splits a stereo input into left/right mono output";
        Icon stereoSplitterIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_stereo_splitter_icon16.png");
        StereoSplitterDeviceInfo stereoSplitter = new StereoSplitterDeviceInfo(name, tooltip, stereoSplitterIcon);
        this.addDeviceInfo(stereoSplitter);
        name = "Stereo Mixer";
        tooltip = "Stereo mixer for multiple mono inputs";
        Icon mixerIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_mixer_icon16.gif");
        StereoMixerDeviceInfo stereoMixer = new StereoMixerDeviceInfo(name, tooltip, mixerIcon);
        this.addDeviceInfo(stereoMixer);
        name = "Audio Switchbox";
        tooltip = "Switch box for multiple audio inputs/outputs";
        Icon switchBoxIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_switchbox_icon16.png");
        AudioSwitchBoxDeviceInfo switchBox = new AudioSwitchBoxDeviceInfo(name, tooltip, switchBoxIcon);
        this.addDeviceInfo(switchBox);
        name = "Audio Delay";
        tooltip = "Audio delay";
        Icon delayIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_audio_delay_icon16.png");
        AudioDelayDeviceInfo delayInfo = new AudioDelayDeviceInfo(name, tooltip, delayIcon);
        this.addDeviceInfo(delayInfo);
        name = "Audio Dither";
        tooltip = "Audio dither";
        Icon ditherIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_audio_dither_icon16.png");
        AudioDitherDeviceInfo ditherInfo = new AudioDitherDeviceInfo(name, tooltip, ditherIcon);
        this.addDeviceInfo(ditherInfo);
        name = "RMS Meter";
        tooltip = "RMS Meter";
        Icon rmsMeterIcon = Tools.getIcon(CommonAudioDeviceProvider.class, (String)"/com/waxmonster/audio/common/icons/waxmonster_rms_meter_icon16.png");
        RmsMeterDeviceInfo rmsMeterInfo = new RmsMeterDeviceInfo(name, tooltip, rmsMeterIcon);
        this.addDeviceInfo(rmsMeterInfo);
    }

    public void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        if (info == null) {
            return null;
        }
        String name = info.getDeviceName();
        Icon icon = info.getIcon(1);
        if (info instanceof AudioMonitorDeviceInfo) {
            return new AudioMonitorDevice(this, name, icon);
        }
        if (info instanceof StereoJoinerDeviceInfo) {
            return new StereoJoinerDevice(this, name, icon);
        }
        if (info instanceof StereoSplitterDeviceInfo) {
            return new StereoSplitterDevice(this, name, icon);
        }
        if (info instanceof StereoMixerDeviceInfo) {
            return new StereoMixerDevice(this, name, icon);
        }
        if (info instanceof AudioSwitchBoxDeviceInfo) {
            return new AudioSwitchBoxDevice(this, name, icon);
        }
        if (info instanceof AudioDelayDeviceInfo) {
            return new AudioDelayDevice(this, name, icon);
        }
        if (info instanceof AudioDitherDeviceInfo) {
            return new AudioDitherDevice(this, name, icon);
        }
        if (info instanceof RmsMeterDeviceInfo) {
            return new RmsMeterDevice(this, name, icon);
        }
        return null;
    }

    public PortType getPortType(String typeName) {
        return AudioPortType.getAudioPortType((String)typeName);
    }
}

