/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;

public class MultiMixer
implements AudioProcessor {
    private final int ni;
    private final SampleBuffer fi;
    private final SampleBuffer[] in;
    private final SampleBuffer out;
    private final int nc;

    public MultiMixer(SampleBuffer[] in, SampleBuffer out) {
        this.ni = in.length;
        this.fi = in[0];
        this.in = in;
        this.out = out;
        this.nc = out.getChannels();
    }

    public void process(long time, int frames) throws AudioException {
        int n = frames * this.nc;
        for (int i = 0; i < n; ++i) {
            double m = this.fi.getDouble(i);
            int k = 1;
            while (k < this.ni) {
                m += this.in[k++].getDouble(i);
            }
            this.out.set(i, m);
        }
    }

    public void shutdown() throws AudioException {
    }
}

