/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.common.Dither;
import java.util.Random;

public class RectangleDither
implements Dither {
    private final SampleBuffer in;
    private final SampleBuffer out;
    private final Random r;
    private final double x;

    public RectangleDither(SampleBuffer in, SampleBuffer out, Random random, double factor) {
        if (random == null) {
            throw new IllegalArgumentException("Random is null");
        }
        this.in = in;
        this.out = out;
        int ic = in.getChannels();
        int oc = out.getChannels();
        if (oc != ic) {
            throw new IllegalArgumentException("Invalid number of input/output channels: " + ic + " != " + oc);
        }
        this.r = random;
        this.x = factor;
    }

    @Override
    public void process(int n) throws AudioException {
        for (int i = 0; i < n; ++i) {
            this.out.set(i, this.in.getDouble(i) + (this.r.nextDouble() - 0.5) * this.x);
        }
    }
}

