/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RmsMeter
implements AudioProcessor {
    private static final Logger logger = Logger.getLogger(RmsMeter.class.getName());
    private static final double FACTOR = 20.0 / Math.log(10.0);
    private final SampleBuffer[] in;
    private final int num;
    private volatile boolean reset;
    private volatile boolean meter;
    long frames;
    private double[] ss;
    double[] ms;

    public RmsMeter(SampleBuffer[] in) {
        this.in = in;
        this.num = in.length;
        this.frames = 0L;
        this.ss = new double[this.num];
        this.ms = new double[this.num];
    }

    public void process(long t, int f) throws AudioException {
        if (this.reset) {
            this.reset = false;
            this.frames = 0L;
            for (int i = 0; i < this.num; ++i) {
                this.ss[i] = 0.0;
                this.ms[i] = 0.0;
            }
        }
        if (this.meter) {
            this.frames += (long)f;
            for (int i = 0; i < this.num; ++i) {
                SampleBuffer sb = this.in[i];
                if (sb == null) continue;
                int c = sb.getChannels();
                int n = f * c;
                double x = this.ss[i];
                for (int k = 0; k < n; ++k) {
                    double v = sb.getDouble(k);
                    x += v * v;
                }
                this.ss[i] = x;
                this.ms[i] = x / (double)((long)c * this.frames);
            }
        }
    }

    public void shutdown() throws AudioException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("RmsMeter stopped: buffers=" + this.num + ", frames=" + this.frames);
            if (logger.isLoggable(Level.FINER)) {
                for (int i = 0; i < this.num; ++i) {
                    double rms = this.rms(i);
                    String sDB = rms <= 0.0 || Double.isNaN(rms) ? "N/A" : Double.toString((double)Math.round(RmsMeter.db(rms) * 100.0) / 100.0);
                    logger.finer(" - RMS power #" + i + ": " + sDB + " dB (" + Double.toString((double)Math.round(rms * 10000.0) / 100.0) + " %)");
                }
            }
        }
    }

    public void reset() {
        this.reset = true;
    }

    public boolean isMeter() {
        return this.meter;
    }

    public void setMeter(boolean meter) {
        this.meter = meter;
    }

    public double rms(int i) {
        return Math.sqrt(this.ms[i]);
    }

    static final double db(double rms) {
        return Math.log(rms) * FACTOR;
    }
}

