/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.RmsMeter;
import com.waxmonster.audio.common.RmsMeterPanel;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Icon;

public class RmsMeterDevice
extends Device {
    public static final String KEY_INPUT_PORTS = "inputPorts";
    public static final String KEY_METER_ENABLED = "meterEnabled";
    public static final int MAX_INPUT_PORTS = 16;
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private int inputPortCount;
    private AudioInputPort[] inputPorts;
    private boolean meterEnabled;
    private RmsMeter rmsMeter;
    private RmsMeterPanel rmsMeterPanel;

    public RmsMeterDevice(DeviceProvider provider, String name, Icon iconColor16, int inputPortCount) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.inputPorts = new AudioInputPort[0];
        this.inputPortCount = 0;
        this.meterEnabled = true;
        this.setInputPortCount(inputPortCount);
    }

    public RmsMeterDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        this(provider, name, iconColor16, 2);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
    }

    public int getInputPortCount() {
        return this.inputPortCount;
    }

    public synchronized void setInputPortCount(int newInputPortCount) throws StudioException {
        if (this.inputPortCount == newInputPortCount) {
            return;
        }
        AudioInputPort[] newArray = new AudioInputPort[newInputPortCount];
        if (newInputPortCount > this.inputPortCount) {
            System.arraycopy(this.inputPorts, 0, newArray, 0, this.inputPortCount);
            for (int i = this.inputPortCount; i < newInputPortCount; ++i) {
                AudioInputPort inputPort;
                newArray[i] = inputPort = new AudioInputPort("In-" + Integer.toString(i + 1), AudioInputPortType.MONO, (AudioSupport)this.audioSupport);
                this.addPort((Port)inputPort);
            }
        } else {
            System.arraycopy(this.inputPorts, 0, newArray, 0, newInputPortCount);
            for (int i = this.inputPortCount - 1; i >= newInputPortCount; --i) {
                AudioInputPort inputPort = this.inputPorts[i];
                this.getStudio().disconnect((Port)inputPort);
                this.removePort((Port)inputPort);
            }
        }
        this.inputPorts = newArray;
        this.inputPortCount = newArray.length;
    }

    public synchronized Component getCustomizer() {
        if (this.rmsMeterPanel == null) {
            this.rmsMeterPanel = new RmsMeterPanel();
            this.rmsMeterPanel.setOpaque(false);
            this.rmsMeterPanel.setDevice(this);
            this.rmsMeterPanel.setRmsMeter(this.rmsMeter);
        }
        return this.rmsMeterPanel;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        props.put(KEY_INPUT_PORTS, String.valueOf(this.getInputPortCount()));
        props.put(KEY_METER_ENABLED, String.valueOf(this.isMeterEnabled()));
        return props;
    }

    protected void applyProperty(String key, String value) {
        if (KEY_INPUT_PORTS.equals(key)) {
            if (value != null) {
                try {
                    this.setInputPortCount(this.parseIntProperty(key, value));
                }
                catch (StudioException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        if (KEY_METER_ENABLED.equals(key)) {
            if (value != null) {
                this.setMeterEnabled("true".equalsIgnoreCase(value));
            }
            return;
        }
    }

    public boolean isMeterEnabled() {
        return this.meterEnabled;
    }

    public synchronized void setMeterEnabled(boolean meterEnabled) {
        if (this.meterEnabled == meterEnabled) {
            return;
        }
        this.meterEnabled = meterEnabled;
        RmsMeter meter = this.rmsMeter;
        if (meter != null) {
            meter.setMeter(meterEnabled);
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            RmsMeterDevice.this.rmsMeter = new RmsMeter(in);
            RmsMeterDevice.this.rmsMeter.setMeter(RmsMeterDevice.this.meterEnabled);
            RmsMeterPanel amp = RmsMeterDevice.this.rmsMeterPanel;
            if (amp != null) {
                amp.setRmsMeter(RmsMeterDevice.this.rmsMeter);
            }
            return RmsMeterDevice.this.rmsMeter;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            RmsMeterPanel amp;
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
            if (RmsMeterDevice.this.rmsMeter != null) {
                RmsMeterDevice.this.rmsMeter = null;
            }
            if ((amp = RmsMeterDevice.this.rmsMeterPanel) != null) {
                amp.setRmsMeter(null);
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new AudioSyncGroupImpl(RmsMeterDevice.this.getName(), RmsMeterDevice.this.inputPorts, new AudioOutputPort[0]);
            }
            return this.syncGroup;
        }
    }
}

