/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.waxmonster.audio.common.AudioCommonConst;
import com.waxmonster.audio.common.RmsMeter;
import com.waxmonster.audio.common.RmsMeterDevice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class RmsMeterPanel
extends JPanel
implements AudioCommonConst {
    private static final long serialVersionUID = 2627742315525928757L;
    private static final Logger logger = Logger.getLogger(RmsMeterPanel.class.getName());
    private RmsMeterDevice device;
    private RmsMeter rmsMeter;
    private Timer timer;
    private int timerDelay = 500;
    private long oldFrames = -1L;
    private boolean meter;
    private MouseHandler mouseHandler = new MouseHandler();
    private JPopupMenu popupMenu;
    private JCheckBoxMenuItem popupItemAudioMeter;
    private boolean refreshing = false;
    private RmsPort[] rmsPorts;
    private JButton btnReset;
    private JPanel portPanel;
    private JLabel labelStatus;
    private JPanel rmsPanel;

    public RmsMeterPanel() {
        this.initialize();
        this.initRmsMeterPanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(239, 233));
        this.portPanel = new JPanel();
        this.portPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Ports", 4, 2, null, null));
        GridBagConstraints gbc_portPanel = new GridBagConstraints();
        gbc_portPanel.weighty = 1.0;
        gbc_portPanel.insets = new Insets(4, 4, 0, 4);
        gbc_portPanel.fill = 1;
        gbc_portPanel.gridx = 0;
        gbc_portPanel.gridy = 0;
        this.add((Component)this.portPanel, gbc_portPanel);
        GridBagLayout gbl_portPanel = new GridBagLayout();
        gbl_portPanel.columnWidths = new int[]{0};
        gbl_portPanel.rowHeights = new int[]{0};
        gbl_portPanel.columnWeights = new double[]{0.0};
        gbl_portPanel.rowWeights = new double[]{0.0};
        this.portPanel.setLayout(gbl_portPanel);
        this.rmsPanel = new JPanel();
        this.rmsPanel.setToolTipText("RMS Meter");
        this.rmsPanel.setOpaque(false);
        GridBagConstraints gbc_rmsPanel = new GridBagConstraints();
        gbc_rmsPanel.insets = new Insets(4, 4, 4, 4);
        gbc_rmsPanel.weighty = 1.0;
        gbc_rmsPanel.weightx = 1.0;
        gbc_rmsPanel.fill = 1;
        gbc_rmsPanel.gridx = 0;
        gbc_rmsPanel.gridy = 0;
        this.portPanel.add((Component)this.rmsPanel, gbc_rmsPanel);
        GridBagLayout gbl_rmsPanel = new GridBagLayout();
        gbl_rmsPanel.columnWidths = new int[]{0};
        gbl_rmsPanel.rowHeights = new int[]{0};
        gbl_rmsPanel.columnWeights = new double[]{Double.MIN_VALUE};
        gbl_rmsPanel.rowWeights = new double[]{Double.MIN_VALUE};
        this.rmsPanel.setLayout(gbl_rmsPanel);
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Status", 4, 2, null, null));
        GridBagConstraints gbc_statusPanel = new GridBagConstraints();
        gbc_statusPanel.weightx = 1.0;
        gbc_statusPanel.insets = new Insets(4, 4, 4, 4);
        gbc_statusPanel.fill = 1;
        gbc_statusPanel.gridx = 0;
        gbc_statusPanel.gridy = 1;
        this.add((Component)statusPanel, gbc_statusPanel);
        GridBagLayout gbl_statusPanel = new GridBagLayout();
        gbl_statusPanel.columnWidths = new int[]{0, 0, 0};
        gbl_statusPanel.rowHeights = new int[]{0, 0};
        gbl_statusPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_statusPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        statusPanel.setLayout(gbl_statusPanel);
        this.btnReset = new JButton("Reset");
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmsMeterPanel.this.actionReset();
            }
        });
        this.labelStatus = new JLabel("N/A");
        GridBagConstraints gbc_labelStatus = new GridBagConstraints();
        gbc_labelStatus.anchor = 17;
        gbc_labelStatus.insets = new Insets(0, 4, 0, 5);
        gbc_labelStatus.gridx = 0;
        gbc_labelStatus.gridy = 0;
        statusPanel.add((Component)this.labelStatus, gbc_labelStatus);
        this.btnReset.setMargin(new Insets(2, 4, 2, 4));
        this.btnReset.setOpaque(false);
        this.btnReset.setToolTipText("Reset counters");
        GridBagConstraints gbc_btnReset = new GridBagConstraints();
        gbc_btnReset.weightx = 1.0;
        gbc_btnReset.insets = new Insets(0, 4, 0, 4);
        gbc_btnReset.anchor = 13;
        gbc_btnReset.gridx = 1;
        gbc_btnReset.gridy = 0;
        statusPanel.add((Component)this.btnReset, gbc_btnReset);
    }

    public RmsMeterDevice getDevice() {
        return this.device;
    }

    public void setDevice(RmsMeterDevice device) {
        this.device = device;
        this.refresh();
    }

    protected void initRmsMeterPanel() {
        this.timer = new Timer(this.timerDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmsMeterPanel.this.update();
            }
        });
        this.addMouseListener(this.mouseHandler);
        this.rmsPanel.addMouseListener(this.mouseHandler);
        this.popupMenu = new JPopupMenu();
        JMenuItem popupItemInputPorts = new JMenuItem("Input Ports...");
        this.popupMenu.add(popupItemInputPorts);
        popupItemInputPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmsMeterPanel.this.showPortCountDialog();
            }
        });
        popupItemInputPorts.setToolTipText("Set number of ports...");
        this.popupItemAudioMeter = new JCheckBoxMenuItem("RMS Meter");
        this.popupMenu.add(this.popupItemAudioMeter);
        this.popupItemAudioMeter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!RmsMeterPanel.this.refreshing) {
                    RmsMeterPanel.this.setMeter(e.getStateChange() == 1);
                }
            }
        });
        this.popupItemAudioMeter.setToolTipText("RMS meter enabled ?");
        this.actionReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.refreshing = true;
            boolean meterEnabled = false;
            int portCount = 0;
            RmsMeterDevice dev = this.getDevice();
            if (dev != null) {
                meterEnabled = dev.isMeterEnabled();
                portCount = dev.getInputPortCount();
            }
            if (meterEnabled != this.meter) {
                this.setMeter(meterEnabled);
            }
            if (this.rmsPorts == null || this.rmsPorts.length != portCount) {
                this.rmsPanel.removeAll();
                RmsPort[] newPorts = new RmsPort[portCount];
                for (int i = 0; i < newPorts.length; ++i) {
                    RmsPort rmsPort = new RmsPort();
                    JLabel label = new JLabel("In-" + (i + 1) + ":");
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = i;
                    gbc.anchor = 17;
                    this.rmsPanel.add((Component)label, gbc);
                    rmsPort.portTitleLabel = label;
                    label = new JLabel("N/A");
                    gbc.gridx = 1;
                    gbc.weightx = 1.0;
                    gbc.anchor = 13;
                    this.rmsPanel.add((Component)label, gbc);
                    rmsPort.dbValueLabel = label;
                    label = new JLabel(" dB");
                    gbc.gridx = 2;
                    gbc.weightx = 0.0;
                    this.rmsPanel.add((Component)label, gbc);
                    rmsPort.dbInfoLabel = label;
                    label = new JLabel("N/A");
                    gbc.gridx = 3;
                    gbc.weightx = 1.0;
                    this.rmsPanel.add((Component)label, gbc);
                    rmsPort.rmsValueLabel = label;
                    label = new JLabel(" %");
                    gbc.gridx = 4;
                    gbc.weightx = 0.0;
                    this.rmsPanel.add((Component)label, gbc);
                    rmsPort.rmsInfoLabel = label;
                    newPorts[i] = rmsPort;
                }
                this.rmsPorts = newPorts;
            }
            this.validate();
            this.repaint();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JButton getBtnReset() {
        return this.btnReset;
    }

    public void update() {
        RmsMeter rm = this.rmsMeter;
        if (rm == null) {
            return;
        }
        long frames = rm.frames;
        if (frames == this.oldFrames) {
            return;
        }
        RmsPort[] ports = this.rmsPorts;
        if (ports != null) {
            double[] ms = rm.ms;
            int n = Math.min(this.rmsPorts.length, ms.length);
            for (int i = 0; i < n; ++i) {
                RmsPort port = ports[i];
                double rms = rm.rms(i);
                String sDB = rms <= 0.0 || Double.isNaN(rms) ? "N/A" : Double.toString((double)Math.round(RmsMeter.db(rms) * 10.0) / 10.0);
                port.dbValueLabel.setText(sDB);
                port.rmsValueLabel.setText(Double.toString((double)Math.round(rms * 1000.0) / 10.0));
            }
        }
        this.oldFrames = frames;
    }

    protected void actionReset() {
        RmsMeter rm = this.rmsMeter;
        if (rm != null) {
            rm.reset();
        } else {
            this.oldFrames = -1L;
            this.labelStatus.setText("Idle");
        }
    }

    public RmsMeter getRmsMeter() {
        return this.rmsMeter;
    }

    public synchronized void setRmsMeter(RmsMeter newMeter) {
        if (this.rmsMeter == newMeter) {
            return;
        }
        if (newMeter == null) {
            this.rmsMeter = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Stopping RmsMeter update timer: " + this.timer);
            }
            this.timer.stop();
            this.labelStatus.setText("Idle");
        } else if (this.rmsMeter == null) {
            this.rmsMeter = newMeter;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Starting RmsMeter update timer: " + this.timer);
            }
            this.timer.start();
            this.labelStatus.setText("Active");
        } else {
            this.rmsMeter = newMeter;
        }
    }

    protected JLabel getLabelStatus() {
        return this.labelStatus;
    }

    public boolean isMeter() {
        return this.meter;
    }

    public synchronized void setMeter(boolean meter) {
        if (this.meter == meter) {
            return;
        }
        this.meter = meter;
        RmsMeterDevice amd = this.device;
        if (amd != null && amd.isMeterEnabled() != meter) {
            amd.setMeterEnabled(meter);
        }
        if (this.popupItemAudioMeter.isSelected() != meter) {
            this.popupItemAudioMeter.setSelected(meter);
        }
    }

    protected void showMonitorPopup(Component comp, int x, int y) {
        if (this.popupMenu != null && comp != null) {
            this.popupMenu.show(comp, x, y);
        }
    }

    protected void showPortCountDialog() {
        int newCount;
        if (this.device == null || this.refreshing) {
            return;
        }
        String message = "Input Ports: 1-16";
        int oldCount = this.device.getInputPortCount();
        String initialSelectionValue = String.valueOf(oldCount);
        String newValue = JOptionPane.showInputDialog(this, message, initialSelectionValue);
        if (newValue == null) {
            return;
        }
        if ((newValue = newValue.trim()).length() < 1) {
            return;
        }
        try {
            newCount = Integer.parseInt(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newCount > 0 && newCount <= 16) {
            try {
                this.device.setInputPortCount(newCount);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.refresh();
        }
    }

    protected JPanel getRmsPanel() {
        return this.rmsPanel;
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int timerDelay) {
        this.timerDelay = timerDelay;
        this.timer.setInitialDelay(timerDelay);
        this.timer.setDelay(timerDelay);
    }

    protected class RmsPort {
        protected JLabel portTitleLabel;
        protected JLabel dbValueLabel;
        protected JLabel dbInfoLabel;
        protected JLabel rmsValueLabel;
        protected JLabel rmsInfoLabel;

        protected RmsPort() {
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                RmsMeterPanel.this.showMonitorPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                RmsMeterPanel.this.showMonitorPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }
    }
}

