/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.StereoJoiner;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import javax.swing.Icon;

public class StereoJoinerDevice
extends Device {
    private static final String PORT_LEFT_IN = "Left-In";
    private static final String PORT_RIGHT_IN = "Right-In";
    private static final String PORT_STEREO_OUT = "Stereo-Out";
    private final AudioSupportImpl support = new AudioSupportImpl();
    private final AudioInputPort leftInputPort;
    private final AudioInputPort rightInputPort;
    private final AudioOutputPort stereoOutputPort;

    public StereoJoinerDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.leftInputPort = new AudioInputPort(PORT_LEFT_IN, AudioInputPortType.LEFT, (AudioSupport)this.support);
        this.rightInputPort = new AudioInputPort(PORT_RIGHT_IN, AudioInputPortType.RIGHT, (AudioSupport)this.support);
        this.stereoOutputPort = new AudioOutputPort(PORT_STEREO_OUT, AudioOutputPortType.STEREO, (AudioSupport)this.support);
        this.addPort((Port)this.leftInputPort);
        this.addPort((Port)this.rightInputPort);
        this.addPort((Port)this.stereoOutputPort);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.support.reset();
    }

    protected void applyProperty(String key, String value) {
    }

    protected class SyncGroupImpl
    extends AudioSyncGroup {
        public SyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            int samples;
            if (in.length != 2) {
                throw new AudioException("Invalid number of input buffers: " + in.length + " != " + 2);
            }
            if (out.length != 1) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != " + 1);
            }
            SampleBuffer leftInput = in[0];
            SampleBuffer rightInput = in[1];
            SampleBuffer stereoOutput = out[0];
            if (stereoOutput == null) {
                return null;
            }
            if (leftInput == null && rightInput == null) {
                return null;
            }
            if (leftInput == null) {
                samples = rightInput.getSamples();
                leftInput = new DoubleArraySampleBuffer(1, samples, rightInput.getFrameRate(), new double[samples]);
            }
            if (rightInput == null) {
                samples = leftInput.getSamples();
                rightInput = new DoubleArraySampleBuffer(1, samples, leftInput.getFrameRate(), new double[samples]);
            }
            return new StereoJoiner(leftInput, rightInput, stereoOutput);
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new SyncGroupImpl(StereoJoinerDevice.this.getName(), new AudioInputPort[]{StereoJoinerDevice.this.leftInputPort, StereoJoinerDevice.this.rightInputPort}, new AudioOutputPort[]{StereoJoinerDevice.this.stereoOutputPort});
            }
            return this.syncGroup;
        }
    }
}

