/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.common.MixerChannel;
import java.util.Arrays;

public class StereoMixer
implements AudioProcessor {
    private final MixerChannel[] mc;
    private final int nc;
    private final int div;
    private final int mul;
    private final double[] lPan;
    private final double[] lPanNew;
    private final double[] rPan;
    private final double[] rPanNew;
    private double lVol;
    private double lVolNew;
    private double rVol;
    private double rVolNew;
    private final SampleBuffer[] channelInputs;
    private final SampleBuffer[] channelOutputs;
    private final SampleBuffer leftMixOutput;
    private final SampleBuffer rightMixOutput;

    public StereoMixer(MixerChannel[] mixerChannels, SampleBuffer[] channelInputs, SampleBuffer[] channelOutputs, SampleBuffer leftMixOutput, SampleBuffer rightMixOutput, int volumeAdjustSamples) {
        this.mc = mixerChannels;
        this.nc = mixerChannels.length;
        if (this.nc < 1) {
            throw new IllegalArgumentException("Invalid number of mixer channels: " + this.nc + " < 1");
        }
        if (volumeAdjustSamples < 2) {
            throw new IllegalArgumentException("Invalid volume adjustment samples: " + volumeAdjustSamples + " < 2");
        }
        this.channelInputs = channelInputs;
        this.channelOutputs = channelOutputs;
        this.leftMixOutput = leftMixOutput;
        this.rightMixOutput = rightMixOutput;
        this.div = volumeAdjustSamples;
        this.mul = this.div - 1;
        this.lVol = 0.0;
        this.rVol = 0.0;
        this.lVolNew = 1.0;
        this.rVolNew = 1.0;
        this.lPan = new double[this.nc];
        this.rPan = new double[this.nc];
        this.lPanNew = new double[this.nc];
        this.rPanNew = new double[this.nc];
        Arrays.fill(this.lPan, 0.0);
        Arrays.fill(this.rPan, 0.0);
        Arrays.fill(this.lPanNew, 1.0);
        Arrays.fill(this.rPanNew, 1.0);
    }

    public int getChannelCount() {
        return this.nc;
    }

    public double getChannelVolumeLeft(int i) {
        return this.lPanNew[i];
    }

    public double getChannelVolumeRight(int i) {
        return this.rPanNew[i];
    }

    public void setChannelVolumeLeft(int i, double v) {
        this.lPanNew[i] = v;
    }

    public void setChannelVolumeRight(int i, double v) {
        this.rPanNew[i] = v;
    }

    public void setChannelVolume(int i, double lv, double rv) {
        this.lPanNew[i] = lv;
        this.rPanNew[i] = rv;
    }

    public double getMasterVolumeLeft() {
        return this.lVolNew;
    }

    public double getMasterVolumeRight() {
        return this.rVolNew;
    }

    public void setMasterVolumeLeft(double v) {
        this.lVolNew = v;
    }

    public void setMasterVolumeRight(double v) {
        this.rVolNew = v;
    }

    public void process(long time, int frames) throws AudioException {
        int k;
        SampleBuffer[] in = this.channelInputs;
        SampleBuffer[] out = this.channelOutputs;
        for (k = 0; k < this.nc; ++k) {
            this.mc[k].process(in[k], out[k], frames);
        }
        SampleBuffer lb = this.leftMixOutput;
        SampleBuffer rb = this.rightMixOutput;
        SampleBuffer fo = out[0];
        for (int i = 0; i < frames; ++i) {
            double x = fo.getDouble(i);
            double l = x * this.lPan[0];
            double r = x * this.rPan[0];
            this.lPan[0] = (this.lPan[0] * (double)this.mul + this.lPanNew[0]) / (double)this.div;
            this.rPan[0] = (this.rPan[0] * (double)this.mul + this.rPanNew[0]) / (double)this.div;
            for (k = 1; k < this.nc; ++k) {
                x = out[k].getDouble(i);
                l += x * this.lPan[k];
                r += x * this.rPan[k];
                this.lPan[k] = (this.lPan[k] * (double)this.mul + this.lPanNew[k]) / (double)this.div;
                this.rPan[k] = (this.rPan[k] * (double)this.mul + this.rPanNew[k]) / (double)this.div;
            }
            lb.set(i, l * this.lVol);
            rb.set(i, r * this.rVol);
            this.lVol = (this.lVol * (double)this.mul + this.lVolNew) / (double)this.div;
            this.rVol = (this.rVol * (double)this.mul + this.rVolNew) / (double)this.div;
        }
    }

    public void shutdown() throws AudioException {
    }
}

