/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.DefaultMixerChannel;
import com.waxmonster.audio.common.MixerChannel;
import com.waxmonster.audio.common.StereoMixer;
import com.waxmonster.audio.common.StereoMixerPanel;
import com.waxmonster.midi.AbstractMidiAction;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.Icon;

public class StereoMixerDevice
extends Device {
    public static final String KEY_CHANNEL_COUNT = "channelCount";
    public static final String KEY_VOLUME_RANGE = "volumeRange";
    public static final String KEY_MASTER_VOLUME_LEFT = "masterVolumeLeft";
    public static final String KEY_MASTER_VOLUME_RIGHT = "masterVolumeRight";
    public static final String KEY_CHANNEL_VOLUME_PREFIX = "channelVolume.";
    public static final String KEY_CHANNEL_BALANCE_PREFIX = "channelBalance.";
    public static final String KEY_MIDI_MAPPING_PREFIX = "midiMapping.";
    public static final String KEY_MIDI_MAPPING_COUNT = "midiMappingCount";
    public static final int MIDI_CONTROLLER_VOLUME = 7;
    public static final int MIDI_CONTROLLER_BALANCE = 8;
    public static final int DEFAULT_MIXER_CHANNELS = 4;
    public static final int MAX_MIXER_CHANNELS = 16;
    public static final double DEFAULT_VOLUME_RANGE = 1.0;
    public static final double MAX_VOLUME_RANGE = 2.0;
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private final MidiSupportImpl midiSupport = new MidiSupportImpl();
    private final AudioOutputPort leftMixOutputPort;
    private final AudioOutputPort rightMixOutputPort;
    private final MasterVolumeLeftControl masterVolumeLeftControl;
    private final MasterVolumeRightControl masterVolumeRightControl;
    private int channelCount;
    private double volumeRange;
    private MixerChannel[] mixerChannels;
    private AudioInputPort[] channelInputPorts;
    private AudioOutputPort[] channelOutputPorts;
    private ChannelVolumeControl[] channelVolumeControls;
    private ChannelBalanceControl[] channelBalanceControls;
    private MidiInputPort midiInputPort;
    private MidiOutputPort midiOutputPort;
    private MidiAction[] midiActions;
    private MidiMapping[] midiActionMappings;
    private MasterVolumeLeftControlMidiAction masterVolumeLeftControlMidiAction;
    private MasterVolumeRightControlMidiAction masterVolumeRightControlMidiAction;
    private ChannelVolumeControlMidiAction[] channelVolumeControlMidiActions;
    private ChannelBalanceControlMidiAction[] channelBalanceControlMidiActions;
    private MidiProcessor targetMidiProcessor;
    private int midiOutMasterChannel = 15;
    private int midiOutMasterVolumeLeftControl = -1;
    private int midiOutMasterVolumeRightControl = -1;
    private int midiOutChannelBase = 0;
    private int midiOutChannelVolumeControl = -1;
    private int midiOutChannelBalanceControl = -1;
    private StereoMixer stereoMixer;
    private StereoMixerPanel stereoMixerPanel;

    public StereoMixerDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        this(provider, name, iconColor16, 4);
    }

    public StereoMixerDevice(DeviceProvider provider, String name, Icon iconColor16, int mixerChannelCount) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.masterVolumeLeftControl = new MasterVolumeLeftControl();
        this.masterVolumeRightControl = new MasterVolumeRightControl();
        this.leftMixOutputPort = new AudioOutputPort("Mix-L", AudioOutputPortType.LEFT, (AudioSupport)this.audioSupport);
        this.rightMixOutputPort = new AudioOutputPort("Mix-R", AudioOutputPortType.RIGHT, (AudioSupport)this.audioSupport);
        this.midiInputPort = new MidiInputPort("MIDI-In", MidiInputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.midiOutputPort = new MidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.masterVolumeLeftControlMidiAction = new MasterVolumeLeftControlMidiAction();
        this.masterVolumeRightControlMidiAction = new MasterVolumeRightControlMidiAction();
        this.channelVolumeControlMidiActions = new ChannelVolumeControlMidiAction[0];
        this.channelBalanceControlMidiActions = new ChannelBalanceControlMidiAction[0];
        this.addControl((Control)this.masterVolumeLeftControl);
        this.addControl((Control)this.masterVolumeRightControl);
        this.refreshMidiActions();
        this.setVolumeRange(1.0);
        this.setMixerChannelCount(mixerChannelCount);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
        this.midiSupport.reset();
    }

    public synchronized int getMixerChannelCount() {
        return this.channelCount;
    }

    public synchronized void setMixerChannelCount(int channelCount) throws StudioException {
        int i;
        if (channelCount < 1) {
            throw new IllegalArgumentException("Invalid number of mixer channels: " + channelCount + " < 1");
        }
        if (channelCount > 16) {
            throw new IllegalArgumentException("Invalid number of mixer channels: " + channelCount + " > " + 16);
        }
        int oldChannelCount = this.channelCount;
        if (oldChannelCount == channelCount) {
            return;
        }
        MixerChannel[] channels = new MixerChannel[channelCount];
        AudioInputPort[] inputPorts = new AudioInputPort[channelCount];
        AudioOutputPort[] outputPorts = new AudioOutputPort[channelCount];
        ChannelVolumeControl[] volumes = new ChannelVolumeControl[channelCount];
        ChannelBalanceControl[] balances = new ChannelBalanceControl[channelCount];
        ChannelVolumeControlMidiAction[] midiChannelVolumes = new ChannelVolumeControlMidiAction[channelCount];
        ChannelBalanceControlMidiAction[] midiChannelBalances = new ChannelBalanceControlMidiAction[channelCount];
        int num = Math.min(oldChannelCount, channelCount);
        if (num > 0) {
            System.arraycopy(this.mixerChannels, 0, channels, 0, num);
            System.arraycopy(this.channelInputPorts, 0, inputPorts, 0, num);
            System.arraycopy(this.channelOutputPorts, 0, outputPorts, 0, num);
            System.arraycopy(this.channelVolumeControls, 0, volumes, 0, num);
            System.arraycopy(this.channelBalanceControls, 0, balances, 0, num);
            System.arraycopy(this.channelVolumeControlMidiActions, 0, midiChannelVolumes, 0, num);
            System.arraycopy(this.channelBalanceControlMidiActions, 0, midiChannelBalances, 0, num);
        }
        for (i = oldChannelCount; i < channelCount; ++i) {
            String channelId = Integer.toString(i + 1);
            channels[i] = this.createMixerChannel();
            inputPorts[i] = new AudioInputPort("In-" + channelId, AudioInputPortType.MONO, (AudioSupport)this.audioSupport);
            outputPorts[i] = new AudioOutputPort("Out-" + channelId, AudioOutputPortType.MONO, (AudioSupport)this.audioSupport);
            volumes[i] = new ChannelVolumeControl(i);
            volumes[i].setMaximum(this.volumeRange);
            balances[i] = new ChannelBalanceControl(i);
            midiChannelVolumes[i] = new ChannelVolumeControlMidiAction(i);
            midiChannelBalances[i] = new ChannelBalanceControlMidiAction(i);
            this.addControl((Control)volumes[i]);
            this.addControl((Control)balances[i]);
        }
        for (i = oldChannelCount - 1; i >= channelCount; --i) {
            this.removeControl((Control)this.channelBalanceControls[i]);
            this.removeControl((Control)this.channelVolumeControls[i]);
        }
        if (channelCount < oldChannelCount) {
            this.channelCount = channelCount;
        }
        this.mixerChannels = channels;
        this.channelInputPorts = inputPorts;
        this.channelOutputPorts = outputPorts;
        this.channelVolumeControls = volumes;
        this.channelBalanceControls = balances;
        this.channelVolumeControlMidiActions = midiChannelVolumes;
        this.channelBalanceControlMidiActions = midiChannelBalances;
        this.channelCount = channelCount;
        for (i = oldChannelCount; i < channelCount; ++i) {
            volumes[i].setDouble(1.0);
        }
        this.refreshMidiActions();
        this.refreshPorts();
    }

    protected synchronized void refreshPorts() throws StudioException {
        Studio studio = this.getStudio();
        Port[] oldPorts = this.getPorts();
        LinkedList<Object> newInputPorts = new LinkedList<Object>();
        LinkedList<Object> newOutputPorts = new LinkedList<Object>();
        newInputPorts.add(this.midiInputPort);
        newOutputPorts.add(this.midiOutputPort);
        newOutputPorts.add(this.leftMixOutputPort);
        newOutputPorts.add(this.rightMixOutputPort);
        for (int i = 0; i < this.channelCount; ++i) {
            newInputPorts.add(this.channelInputPorts[i]);
            newOutputPorts.add(this.channelOutputPorts[i]);
        }
        HashSet<Port> oldPortSet = new HashSet<Port>();
        for (int i = 0; i < oldPorts.length; ++i) {
            oldPortSet.add(oldPorts[i]);
        }
        int nextPortIndex = 0;
        ArrayList<Object> newPorts = new ArrayList<Object>(newInputPorts.size() + newOutputPorts.size());
        newPorts.addAll(newInputPorts);
        newPorts.addAll(newOutputPorts);
        for (Port port : newPorts) {
            if (port == null) continue;
            oldPortSet.remove(port);
            if (port.getDevice() == this) {
                this.removePort(port);
            }
            this.insertPortAt(port, nextPortIndex);
            ++nextPortIndex;
        }
        for (Port port : oldPortSet) {
            if (port == null) continue;
            if (studio != null) {
                studio.disconnect(port);
            }
            this.removePort(port);
        }
    }

    protected MixerChannel createMixerChannel() {
        return new DefaultMixerChannel();
    }

    public synchronized MixerChannel getMixerChannelAt(int index) {
        return this.mixerChannels[index];
    }

    public synchronized Component getCustomizer() {
        if (this.stereoMixerPanel == null) {
            this.stereoMixerPanel = new StereoMixerPanel();
            this.stereoMixerPanel.setOpaque(false);
            this.stereoMixerPanel.setDevice(this);
        }
        return this.stereoMixerPanel;
    }

    public DoubleControl getMasterVolumeLeftControl() {
        return this.masterVolumeLeftControl;
    }

    public DoubleControl getMasterVolumeRightControl() {
        return this.masterVolumeRightControl;
    }

    public DoubleControl getChannelVolumeControl(int channel) {
        return this.channelVolumeControls[channel];
    }

    public DoubleControl getChannelBalanceControl(int channel) {
        return this.channelBalanceControls[channel];
    }

    protected void applyChannelVolume(int i, double v, double b) {
        Studio studio;
        MidiProcessor target;
        StereoMixer mixer = this.stereoMixer;
        if (mixer != null && i < mixer.getChannelCount()) {
            if (b < 0.0) {
                mixer.setChannelVolume(i, v, v * (1.0 + b));
            } else {
                mixer.setChannelVolume(i, v * (1.0 - b), v);
            }
        }
        if ((target = this.targetMidiProcessor) != null && (studio = this.getStudio()) != null) {
            int data2;
            int midiControl;
            long time = studio.getTime();
            int midiChannel = this.midiOutChannelBase + i;
            if (midiChannel < 0) {
                midiChannel = 0;
            }
            if (midiChannel > 15) {
                midiChannel = 15;
            }
            if ((midiControl = this.midiOutChannelVolumeControl) >= 0) {
                data2 = (int)(v * 64.0);
                if (data2 < 0) {
                    data2 = 0;
                }
                if (data2 > 127) {
                    data2 = 127;
                }
                target.process(time, 0xB0 | midiChannel, midiControl, data2);
            }
            if ((midiControl = this.midiOutChannelBalanceControl) >= 0) {
                data2 = (int)((b + 1.0) * 64.0);
                if (data2 < 0) {
                    data2 = 0;
                }
                if (data2 > 127) {
                    data2 = 127;
                }
                target.process(time, 0xB0 | midiChannel, midiControl, data2);
            }
        }
    }

    public synchronized Properties getProperties() {
        MidiMapping[] midiActionMappings;
        Properties props = super.getProperties();
        int channels = this.channelCount;
        props.put(KEY_CHANNEL_COUNT, String.valueOf(channels));
        double volRange = this.volumeRange;
        props.put(KEY_VOLUME_RANGE, String.valueOf(volRange));
        if (props.remove(KEY_MASTER_VOLUME_LEFT) != null) {
            props.remove(KEY_MASTER_VOLUME_RIGHT);
            for (int i = 0; i < channels; ++i) {
                String channelId = String.valueOf(i);
                props.remove(KEY_CHANNEL_VOLUME_PREFIX + channelId);
                props.remove(KEY_CHANNEL_BALANCE_PREFIX + channelId);
            }
        }
        int num = (midiActionMappings = this.getMidiActionMappings()) == null ? 0 : midiActionMappings.length;
        props.put(KEY_MIDI_MAPPING_COUNT, String.valueOf(num));
        for (int i = 0; i < num; ++i) {
            MidiMapping mam = midiActionMappings[i];
            if (mam == null) continue;
            String key = KEY_MIDI_MAPPING_PREFIX + String.valueOf(1000 + i).substring(1);
            String value = mam.toString();
            props.put(key, value);
        }
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        String sVolRange;
        String sChannels = newProperties.getProperty(KEY_CHANNEL_COUNT);
        if (sChannels != null) {
            this.applyProperty(KEY_CHANNEL_COUNT, sChannels);
        }
        if ((sVolRange = newProperties.getProperty(KEY_VOLUME_RANGE)) != null) {
            this.applyProperty(KEY_VOLUME_RANGE, sChannels);
        }
        TreeMap<String, MidiMapping> newMidiMappings = new TreeMap<String, MidiMapping>();
        int midiMappingCount = 0;
        String midiMappingCountValue = newProperties.getProperty(KEY_MIDI_MAPPING_COUNT);
        if (midiMappingCountValue != null) {
            try {
                midiMappingCount = Integer.parseInt(midiMappingCountValue.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (Map.Entry<Object, Object> me : newProperties.entrySet()) {
            String key = String.valueOf(me.getKey());
            if (!key.startsWith(KEY_MIDI_MAPPING_PREFIX)) continue;
            try {
                String value;
                MidiMapping mapping;
                int index = Integer.parseInt(key.substring(KEY_MIDI_MAPPING_PREFIX.length()));
                if (index < 0 || index >= midiMappingCount || (mapping = MidiMapping.parseMidiMapping((String)(value = String.valueOf(me.getValue())))) == null) continue;
                newMidiMappings.put(key, mapping);
            }
            catch (NumberFormatException e) {}
        }
        this.setMidiActionMappings(newMidiMappings.values().toArray(new MidiMapping[newMidiMappings.size()]));
        super.setProperties(newProperties);
    }

    protected void applyProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (KEY_MASTER_VOLUME_LEFT.equals(key)) {
            if (value != null) {
                this.masterVolumeLeftControl.setDouble(this.parseDoubleProperty(key, value));
            }
            return;
        }
        if (KEY_MASTER_VOLUME_RIGHT.equals(key)) {
            if (value != null) {
                this.masterVolumeRightControl.setDouble(this.parseDoubleProperty(key, value));
            }
            return;
        }
        if (KEY_CHANNEL_COUNT.equals(key)) {
            if (value != null) {
                int channels = this.parseIntProperty(key, value);
                try {
                    this.setMixerChannelCount(channels);
                }
                catch (StudioException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        if (KEY_VOLUME_RANGE.equals(key)) {
            if (value != null) {
                double range = this.parseDoubleProperty(key, value);
                this.setVolumeRange(range);
            }
            return;
        }
        if (key.startsWith(KEY_CHANNEL_VOLUME_PREFIX)) {
            if (value != null) {
                double channelVolume = this.parseDoubleProperty(key, value);
                String channelName = key.substring(KEY_CHANNEL_VOLUME_PREFIX.length());
                int channelIndex = this.getChannelIndex(channelName);
                if (channelIndex >= 0 && channelIndex < this.channelCount) {
                    this.getChannelVolumeControl(channelIndex).setDouble(channelVolume);
                }
            }
            return;
        }
        if (key.startsWith(KEY_CHANNEL_BALANCE_PREFIX)) {
            if (value != null) {
                double channelBalance = this.parseDoubleProperty(key, value);
                String channelId = key.substring(KEY_CHANNEL_BALANCE_PREFIX.length());
                int channelIndex = this.getChannelIndex(channelId);
                if (channelIndex >= 0 && channelIndex < this.channelCount) {
                    this.getChannelBalanceControl(channelIndex).setDouble(channelBalance);
                }
            }
            return;
        }
    }

    private int getChannelIndex(String channelId) {
        return Integer.parseInt(channelId);
    }

    public MidiMapping[] getMidiActionMappings() {
        return this.midiActionMappings;
    }

    public void setMidiActionMappings(MidiMapping[] midiActionMappings) {
        this.midiActionMappings = midiActionMappings;
        this.midiSupport.applyMidiActionMappings();
    }

    public MidiAction[] getAvailableMidiActions() {
        return this.midiActions;
    }

    protected synchronized void refreshMidiActions() {
        int i;
        LinkedList<AbstractMidiAction> list = new LinkedList<AbstractMidiAction>();
        list.add(this.masterVolumeLeftControlMidiAction);
        list.add(this.masterVolumeRightControlMidiAction);
        for (i = 0; i < this.channelVolumeControlMidiActions.length; ++i) {
            list.add(this.channelVolumeControlMidiActions[i]);
        }
        for (i = 0; i < this.channelBalanceControlMidiActions.length; ++i) {
            list.add(this.channelBalanceControlMidiActions[i]);
        }
        this.midiActions = list.toArray(new MidiAction[list.size()]);
    }

    public double getVolumeRange() {
        return this.volumeRange;
    }

    public synchronized void setVolumeRange(double volumeRange) {
        if (volumeRange <= 0.0) {
            volumeRange = 0.0;
        }
        if (volumeRange > 2.0) {
            volumeRange = 2.0;
        }
        this.volumeRange = volumeRange;
        this.masterVolumeLeftControl.setMaximum(volumeRange);
        this.masterVolumeRightControl.setMaximum(volumeRange);
        for (int i = 0; i < this.channelCount; ++i) {
            this.channelVolumeControls[i].setMaximum(volumeRange);
        }
    }

    public MasterVolumeLeftControlMidiAction getMasterVolumeLeftControlMidiAction() {
        return this.masterVolumeLeftControlMidiAction;
    }

    public MasterVolumeRightControlMidiAction getMasterVolumeRightControlMidiAction() {
        return this.masterVolumeRightControlMidiAction;
    }

    public ChannelBalanceControlMidiAction getChannelBalanceControlMidiAction(int channel) {
        return this.channelBalanceControlMidiActions[channel];
    }

    public ChannelVolumeControlMidiAction getChannelVolumeControlMidiAction(int channel) {
        return this.channelVolumeControlMidiActions[channel];
    }

    protected class ChannelBalanceControl
    extends AbstractDoubleControl {
        private final int index;

        public ChannelBalanceControl(int index) {
            this.index = index;
            this.setName("channelBalance" + (index + 1));
            this.setTooltip("Channel " + (index + 1) + " Balance");
            this.setMinimum(-1.0);
            this.setMaximum(1.0);
        }

        protected void applyDouble(double b) {
            StereoMixerDevice.this.applyChannelVolume(this.index, StereoMixerDevice.this.channelVolumeControls[this.index].getDouble(), b);
        }
    }

    protected class ChannelVolumeControl
    extends AbstractDoubleControl {
        private final int index;

        public ChannelVolumeControl(int index) {
            this.index = index;
            this.setName("channelVolume" + (index + 1));
            this.setTooltip("Channel " + (index + 1) + " Volume");
            this.setMinimum(0.0);
            this.setMaximum(2.0);
        }

        protected void applyDouble(double v) {
            StereoMixerDevice.this.applyChannelVolume(this.index, v, StereoMixerDevice.this.channelBalanceControls[this.index].getDouble());
        }

        protected void setMaximum(double maximum) {
            super.setMaximum(maximum);
        }
    }

    protected class MasterVolumeRightControl
    extends AbstractDoubleControl {
        public MasterVolumeRightControl() {
            this.setName(StereoMixerDevice.KEY_MASTER_VOLUME_RIGHT);
            this.setTooltip("Master Volume Right");
            this.setMinimum(0.0);
            this.setMaximum(2.0);
            this.setDouble(1.0);
        }

        protected void applyDouble(double v) {
            Studio studio;
            int midiControl;
            MidiProcessor target;
            StereoMixer mixer = StereoMixerDevice.this.stereoMixer;
            if (mixer != null) {
                mixer.setMasterVolumeRight(v);
            }
            if ((target = StereoMixerDevice.this.targetMidiProcessor) != null && (midiControl = StereoMixerDevice.this.midiOutMasterVolumeRightControl) >= 0 && (studio = StereoMixerDevice.this.getStudio()) != null) {
                long time = studio.getTime();
                int data2 = (int)(v * 64.0);
                if (data2 < 0) {
                    data2 = 0;
                }
                if (data2 > 127) {
                    data2 = 127;
                }
                target.process(time, 0xB0 | StereoMixerDevice.this.midiOutMasterChannel, midiControl, data2);
            }
        }

        protected void setMaximum(double maximum) {
            super.setMaximum(maximum);
        }
    }

    protected class MasterVolumeLeftControl
    extends AbstractDoubleControl {
        public MasterVolumeLeftControl() {
            this.setName(StereoMixerDevice.KEY_MASTER_VOLUME_LEFT);
            this.setTooltip("Master Volume Left");
            this.setMinimum(0.0);
            this.setMaximum(2.0);
            this.setDouble(1.0);
        }

        protected void applyDouble(double v) {
            Studio studio;
            int midiControl;
            MidiProcessor target;
            StereoMixer mixer = StereoMixerDevice.this.stereoMixer;
            if (mixer != null) {
                mixer.setMasterVolumeLeft(v);
            }
            if ((target = StereoMixerDevice.this.targetMidiProcessor) != null && (midiControl = StereoMixerDevice.this.midiOutMasterVolumeLeftControl) >= 0 && (studio = StereoMixerDevice.this.getStudio()) != null) {
                long time = studio.getTime();
                int data2 = (int)(v * 64.0);
                if (data2 < 0) {
                    data2 = 0;
                }
                if (data2 > 127) {
                    data2 = 127;
                }
                target.process(time, 0xB0 | StereoMixerDevice.this.midiOutMasterChannel, midiControl, data2);
            }
        }

        protected void setMaximum(double maximum) {
            super.setMaximum(maximum);
        }
    }

    protected class ChannelBalanceControlMidiAction
    extends AbstractMidiAction {
        private final int channelIndex;

        public ChannelBalanceControlMidiAction(int channelIndex) {
            super("ChannelBalance-" + (channelIndex + 1));
            this.channelIndex = channelIndex;
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 176: {
                        if (this.channelIndex < StereoMixerDevice.this.channelCount && this.channelIndex >= 0) {
                            double value = data2 < 63 ? (double)(data2 - 63) / 63.0 : (data2 > 64 ? (double)(data2 - 64) / 63.0 : 0.0);
                            StereoMixerDevice.this.channelBalanceControls[this.channelIndex].setDouble(value);
                        }
                        return;
                    }
                }
            }
        }

        public String toString() {
            return super.toString() + "[channelIndex=" + this.channelIndex + "]";
        }
    }

    protected class ChannelVolumeControlMidiAction
    extends AbstractMidiAction {
        private final int channelIndex;

        public ChannelVolumeControlMidiAction(int channelIndex) {
            super("ChannelVolume-" + (channelIndex + 1));
            this.channelIndex = channelIndex;
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 176: {
                        if (this.channelIndex < StereoMixerDevice.this.channelCount && this.channelIndex >= 0) {
                            StereoMixerDevice.this.channelVolumeControls[this.channelIndex].setDouble((double)data2 * StereoMixerDevice.this.volumeRange / 127.0);
                        }
                        return;
                    }
                }
            }
        }

        public String toString() {
            return super.toString() + "[channelIndex=" + this.channelIndex + "]";
        }
    }

    protected class MasterVolumeRightControlMidiAction
    extends AbstractMidiAction {
        public MasterVolumeRightControlMidiAction() {
            super("MasterVolume-Right");
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 176: {
                        StereoMixerDevice.this.masterVolumeRightControl.setDouble((double)data2 * StereoMixerDevice.this.volumeRange / 127.0);
                        return;
                    }
                }
            }
        }
    }

    protected class MasterVolumeLeftControlMidiAction
    extends AbstractMidiAction {
        public MasterVolumeLeftControlMidiAction() {
            super("MasterVolume-Left");
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 176: {
                        StereoMixerDevice.this.masterVolumeLeftControl.setDouble((double)data2 * StereoMixerDevice.this.volumeRange / 127.0);
                        return;
                    }
                }
            }
        }
    }

    protected class MidiSyncGroupImpl
    extends MidiSyncGroup {
        private Map procs;

        public MidiSyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
            this.procs = new HashMap();
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
            if (targets.length != 1) {
                throw new MidiException("Invalid number of target ports: " + targets.length + " != 1");
            }
            StereoMixerDevice.this.targetMidiProcessor = targets[0];
        }

        public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            MidiActionProcessor proc = (MidiActionProcessor)this.procs.get(port);
            if (proc == null) {
                proc = new MidiActionProcessor(this.getName());
                this.procs.put(port, proc);
                this.applyMidiActionMappings(proc);
            }
            return proc;
        }

        protected void applyMidiActionMappings() {
            for (MidiActionProcessor proc : this.procs.values()) {
                if (proc == null) continue;
                this.applyMidiActionMappings(proc);
            }
        }

        protected void applyMidiActionMappings(MidiActionProcessor proc) {
            proc.reset(StereoMixerDevice.this.getAvailableMidiActions(), StereoMixerDevice.this.getMidiActionMappings());
            proc.validate();
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroupImpl syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
                StereoMixerDevice.this.targetMidiProcessor = null;
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.syncGroup == null) {
                MidiInputPort[] inputPorts = new MidiInputPort[]{StereoMixerDevice.this.midiInputPort};
                MidiOutputPort[] outputPorts = new MidiOutputPort[]{StereoMixerDevice.this.midiOutputPort};
                this.syncGroup = new MidiSyncGroupImpl(StereoMixerDevice.this.getTitleOrName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }

        protected void applyMidiActionMappings() {
            MidiSyncGroupImpl group = this.syncGroup;
            if (group != null) {
                group.applyMidiActionMappings();
            }
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            if (in.length != StereoMixerDevice.this.channelCount) {
                throw new AudioException("Invalid number of input buffers: " + in.length + " != " + StereoMixerDevice.this.channelCount);
            }
            if (out.length != StereoMixerDevice.this.channelCount + 2) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != " + (StereoMixerDevice.this.channelCount + 2));
            }
            SampleBuffer[] channelInputs = new SampleBuffer[StereoMixerDevice.this.channelCount];
            System.arraycopy(in, 0, channelInputs, 0, StereoMixerDevice.this.channelCount);
            SampleBuffer[] channelOutputs = new SampleBuffer[StereoMixerDevice.this.channelCount];
            System.arraycopy(out, 0, channelOutputs, 0, StereoMixerDevice.this.channelCount);
            SampleBuffer leftMixOutput = out[StereoMixerDevice.this.channelCount];
            SampleBuffer rightMixOutput = out[StereoMixerDevice.this.channelCount + 1];
            int volumeAdjustSamples = 32;
            StereoMixer mixer = new StereoMixer(StereoMixerDevice.this.mixerChannels, channelInputs, channelOutputs, leftMixOutput, rightMixOutput, volumeAdjustSamples);
            StereoMixerDevice.this.stereoMixer = mixer;
            for (int i = 0; i < StereoMixerDevice.this.channelCount; ++i) {
                double v = StereoMixerDevice.this.channelVolumeControls[i].getDouble();
                double b = StereoMixerDevice.this.channelBalanceControls[i].getDouble();
                StereoMixerDevice.this.applyChannelVolume(i, v, b);
            }
            mixer.setMasterVolumeLeft(StereoMixerDevice.this.masterVolumeLeftControl.getDouble());
            mixer.setMasterVolumeRight(StereoMixerDevice.this.masterVolumeRightControl.getDouble());
            return mixer;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
                StereoMixerDevice.this.stereoMixer = null;
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                AudioInputPort[] inputPorts = new AudioInputPort[StereoMixerDevice.this.channelCount];
                System.arraycopy(StereoMixerDevice.this.channelInputPorts, 0, inputPorts, 0, StereoMixerDevice.this.channelCount);
                AudioOutputPort[] outputPorts = new AudioOutputPort[StereoMixerDevice.this.channelCount + 2];
                System.arraycopy(StereoMixerDevice.this.channelOutputPorts, 0, outputPorts, 0, StereoMixerDevice.this.channelCount);
                outputPorts[((StereoMixerDevice)StereoMixerDevice.this).channelCount] = StereoMixerDevice.this.leftMixOutputPort;
                outputPorts[((StereoMixerDevice)StereoMixerDevice.this).channelCount + 1] = StereoMixerDevice.this.rightMixOutputPort;
                this.syncGroup = new AudioSyncGroupImpl(StereoMixerDevice.this.getName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }
    }
}

