/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.media.control.FaderControlUI;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.waxmonster.audio.common.StereoMixerDevice;
import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.AbstractMidiMapper;
import com.waxmonster.midi.common.MidiMappingManagerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class StereoMixerPanel
extends JPanel
implements MidiMappable {
    private static final long serialVersionUID = 227794301565959222L;
    private static final Logger logger = Logger.getLogger(StereoMixerPanel.class.getName());
    private StereoMixerDevice device;
    private final MouseHandler mouseHandler = new MouseHandler();
    private final MidiMapperImpl midiMapper = new MidiMapperImpl();
    private JPopupMenu popupMenu;

    public StereoMixerPanel() {
        this.initStereoMixerPanel();
    }

    private void initStereoMixerPanel() {
        this.addMouseListener(this.mouseHandler);
        this.popupMenu = new JPopupMenu();
        JMenuItem popupItemMixerChannels = new JMenuItem("Mixer Channels...");
        this.popupMenu.add(popupItemMixerChannels);
        popupItemMixerChannels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StereoMixerPanel.this.showChannelCountDialog();
            }
        });
        popupItemMixerChannels.setToolTipText("Set number of channels...");
        JMenuItem popupItemVolumeRange = new JMenuItem("Volume Range...");
        this.popupMenu.add(popupItemVolumeRange);
        popupItemVolumeRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StereoMixerPanel.this.showVolumeRangeDialog();
            }
        });
        popupItemVolumeRange.setToolTipText("Set volume range...");
        JMenuItem popupItemMidiMappings = new JMenuItem("MIDI Mappings...");
        this.popupMenu.add(popupItemMidiMappings);
        popupItemMidiMappings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StereoMixerPanel.this.showMidiMappingDialog();
            }
        });
        popupItemMidiMappings.setToolTipText("Edit MIDI mappings...");
    }

    public StereoMixerDevice getDevice() {
        return this.device;
    }

    public synchronized void setDevice(StereoMixerDevice device) {
        this.device = device;
        this.refresh();
    }

    public synchronized void refresh() {
        GridBagConstraints gbc;
        Component comp;
        FaderControlUI faderUI;
        int channels = 0;
        StereoMixerDevice dev = this.device;
        if (dev != null) {
            channels = dev.getMixerChannelCount();
        }
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.midiMapper.unregisterAllMidiActions();
        int balancePrefWidth = 50;
        int balancePrefHeight = 20;
        int volumePrefWidth = 30;
        int volumePrefHeight = 140;
        int i = 0;
        while (i < channels) {
            DoubleControl channelVolumeControl;
            JPanel channelPanel = new JPanel();
            channelPanel.setOpaque(false);
            channelPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Ch-" + (i + 1), 2, 0));
            channelPanel.setLayout(new BorderLayout());
            DoubleControl channelBalanceControl = dev.getChannelBalanceControl(i);
            if (channelBalanceControl != null) {
                FaderControlUI faderUI2 = new FaderControlUI();
                faderUI2.setOrientation(0);
                faderUI2.setControl((Control)channelBalanceControl);
                Component comp2 = faderUI2.getComponent();
                if (comp2 instanceof JComponent) {
                    ((JComponent)comp2).setPreferredSize(new Dimension(balancePrefWidth, balancePrefHeight));
                }
                channelPanel.add(comp2, "North");
                this.midiMapper.registerMidiAction(comp2, dev.getChannelBalanceControlMidiAction(i).getName());
            }
            if ((channelVolumeControl = dev.getChannelVolumeControl(i)) != null) {
                faderUI = new FaderControlUI();
                faderUI.setOrientation(1);
                faderUI.setControl((Control)channelVolumeControl);
                comp = faderUI.getComponent();
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setPreferredSize(new Dimension(balancePrefWidth, volumePrefHeight));
                }
                channelPanel.add(comp, "Center");
                this.midiMapper.registerMidiAction(comp, dev.getChannelVolumeControlMidiAction(i).getName());
            }
            gbc = new GridBagConstraints();
            gbc.gridx = i++;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(4, 0, 4, 0);
            this.add((Component)channelPanel, gbc);
        }
        if (dev != null) {
            DoubleControl masterVolumeRightControl;
            JPanel masterPanel = new JPanel();
            masterPanel.setOpaque(false);
            masterPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Master", 2, 0));
            masterPanel.setLayout(new BorderLayout());
            JPanel dummy = new JPanel();
            dummy.setOpaque(false);
            dummy.setPreferredSize(new Dimension(volumePrefWidth * 2, balancePrefHeight));
            masterPanel.add((Component)dummy, "North");
            JPanel masterVolumePanel = new JPanel();
            masterVolumePanel.setOpaque(false);
            masterVolumePanel.setLayout(new GridLayout(1, 2));
            DoubleControl masterVolumeLeftControl = dev.getMasterVolumeLeftControl();
            if (masterVolumeLeftControl != null) {
                faderUI = new FaderControlUI();
                faderUI.setOrientation(1);
                faderUI.setControl((Control)masterVolumeLeftControl);
                comp = faderUI.getComponent();
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setPreferredSize(new Dimension(volumePrefWidth, volumePrefHeight));
                }
                masterVolumePanel.add(comp);
                this.midiMapper.registerMidiAction(comp, dev.getMasterVolumeLeftControlMidiAction().getName());
            }
            if ((masterVolumeRightControl = dev.getMasterVolumeRightControl()) != null) {
                FaderControlUI faderUI3 = new FaderControlUI();
                faderUI3.setOrientation(1);
                faderUI3.setControl((Control)masterVolumeRightControl);
                Component comp3 = faderUI3.getComponent();
                if (comp3 instanceof JComponent) {
                    ((JComponent)comp3).setPreferredSize(new Dimension(volumePrefWidth, volumePrefHeight));
                }
                masterVolumePanel.add(comp3);
                this.midiMapper.registerMidiAction(comp3, dev.getMasterVolumeRightControlMidiAction().getName());
            }
            masterPanel.add((Component)masterVolumePanel, "Center");
            gbc = new GridBagConstraints();
            gbc.gridx = channels;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(4, 0, 4, 0);
            this.add((Component)masterPanel, gbc);
        }
        this.validate();
        this.repaint();
    }

    protected void showMixerPopup(Component comp, int x, int y) {
        if (this.popupMenu != null && comp != null) {
            this.popupMenu.show(this, x, y);
        }
    }

    protected void showMidiMappingDialog() {
        if (this.device == null) {
            return;
        }
        try {
            MidiMappingManagerPanel panel = new MidiMappingManagerPanel();
            panel.setStudio(this.device.getStudio());
            panel.setDeviceName(this.device.getName() + "-MidiMapping");
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter((MidiFormatter)DefaultMidiFormatter.getSharedInstance());
            panel.setAvailableActions(this.device.getAvailableMidiActions());
            MidiMapping[] origMappings = this.device.getMidiActionMappings();
            int origCount = origMappings == null ? 0 : origMappings.length;
            MidiMapping[] cloneMappings = new MidiMapping[origCount];
            if (origCount > 0) {
                System.arraycopy(origMappings, 0, cloneMappings, 0, origCount);
            }
            panel.setMappings(cloneMappings);
            String title = "MIDI Mappings";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiMapping[] newMappings = panel.getMappings();
            this.device.setMidiActionMappings(newMappings);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void showChannelCountDialog() {
        int newCount;
        if (this.device == null) {
            return;
        }
        String message = "Mixer Channels: 1-16";
        int oldCount = this.device.getMixerChannelCount();
        String initialSelectionValue = String.valueOf(oldCount);
        String newValue = JOptionPane.showInputDialog(this, message, initialSelectionValue);
        if (newValue == null) {
            return;
        }
        if ((newValue = newValue.trim()).length() < 1) {
            return;
        }
        try {
            newCount = Integer.parseInt(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newCount > 0 && newCount <= 16) {
            try {
                this.device.setMixerChannelCount(newCount);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.refresh();
        }
    }

    protected void showVolumeRangeDialog() {
        double newRange;
        if (this.device == null) {
            return;
        }
        String message = "Volume Range: (1 = normal)";
        double oldRangePct = this.device.getVolumeRange();
        String initialSelectionValue = String.valueOf(oldRangePct);
        String newValue = JOptionPane.showInputDialog(this, message, initialSelectionValue);
        if (newValue == null) {
            return;
        }
        if ((newValue = newValue.trim()).length() < 1) {
            return;
        }
        try {
            newRange = Double.parseDouble(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newRange >= 0.0 && newRange <= 2.0) {
            try {
                this.device.setVolumeRange(newRange);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.refresh();
        }
    }

    public MidiMapper getMidiMapper() {
        return this.midiMapper;
    }

    protected class MidiMapperImpl
    extends AbstractMidiMapper {
        protected MidiMapperImpl() {
        }

        public MidiMapping[] getMidiMappings(Object component) {
            return StereoMixerPanel.this.device.getMidiActionMappings();
        }

        public void setMidiMappings(Object component, MidiMapping[] mappings) {
            StereoMixerPanel.this.device.setMidiActionMappings(mappings);
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                StereoMixerPanel.this.showMixerPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                StereoMixerPanel.this.showMixerPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }
    }
}

