/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.StereoSplitter;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import javax.swing.Icon;

public class StereoSplitterDevice
extends Device {
    private static final String PORT_STEREO_IN = "Stereo-In";
    private static final String PORT_LEFT_OUT = "Left-Out";
    private static final String PORT_RIGHT_OUT = "Right-Out";
    private final AudioSupportImpl support = new AudioSupportImpl();
    private final AudioInputPort stereoInputPort;
    private final AudioOutputPort leftOutputPort;
    private final AudioOutputPort rightOutputPort;

    public StereoSplitterDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.stereoInputPort = new AudioInputPort(PORT_STEREO_IN, AudioInputPortType.STEREO, (AudioSupport)this.support);
        this.leftOutputPort = new AudioOutputPort(PORT_LEFT_OUT, AudioOutputPortType.LEFT, (AudioSupport)this.support);
        this.rightOutputPort = new AudioOutputPort(PORT_RIGHT_OUT, AudioOutputPortType.RIGHT, (AudioSupport)this.support);
        this.addPort((Port)this.stereoInputPort);
        this.addPort((Port)this.leftOutputPort);
        this.addPort((Port)this.rightOutputPort);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.support.reset();
    }

    protected void applyProperty(String key, String value) {
    }

    protected class SyncGroupImpl
    extends AudioSyncGroup {
        public SyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            if (in.length != 1) {
                throw new AudioException("Invalid number of input buffers: " + in.length + " != " + 1);
            }
            if (out.length != 2) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != " + 2);
            }
            SampleBuffer stereoInput = in[0];
            SampleBuffer leftOutput = out[0];
            SampleBuffer rightOutput = out[1];
            if (stereoInput == null) {
                return null;
            }
            if (leftOutput == null && rightOutput == null) {
                return null;
            }
            return new StereoSplitter(stereoInput, leftOutput, rightOutput);
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new SyncGroupImpl(StereoSplitterDevice.this.getName(), new AudioInputPort[]{StereoSplitterDevice.this.stereoInputPort}, new AudioOutputPort[]{StereoSplitterDevice.this.leftOutputPort, StereoSplitterDevice.this.rightOutputPort});
            }
            return this.syncGroup;
        }
    }
}

