/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.pattern;

import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.ScratchPattern;
import com.waxmonster.editor.pattern.AbstractScratchPattern;

public abstract class AbstractComboScratchPattern
extends AbstractScratchPattern {
    private ScratchPattern[] patterns;

    public AbstractComboScratchPattern(ScratchPattern[] patterns) {
        this.patterns = patterns;
        double totalBeatLen = 0.0;
        for (int i = 0; i < patterns.length; ++i) {
            double beatLen = patterns[i].getBeatLength();
            if (!(beatLen >= 0.0)) continue;
            totalBeatLen += beatLen;
        }
        if (totalBeatLen > 0.0) {
            this.setBeatLength(totalBeatLen);
        }
        StringBuffer descr = new StringBuffer();
        descr.append("[");
        for (int i = 0; i < patterns.length; ++i) {
            String s;
            if (i > 0) {
                descr.append(" / ");
            }
            if ((s = patterns[i].getDescription()) != null && s.length() > 0) {
                descr.append(s);
                continue;
            }
            s = patterns[i].getTitle();
            if (s != null && s.length() > 0) {
                descr.append(s);
                continue;
            }
            descr.append(String.valueOf(patterns[i]));
        }
        descr.append("]");
        this.setDescription(descr.toString());
    }

    @Override
    public ScratchEditorModel createScratchEditorModel() {
        ScratchEditorModel model = super.createScratchEditorModel();
        double timePosition = 0.0;
        double needlePosition = 0.0;
        for (int k = 0; k < this.patterns.length; ++k) {
            ScratchEditorModel sem = this.patterns[k].createScratchEditorModel();
            if (sem == null) continue;
            int tn = sem.getTimecodePointCount();
            for (int i = 0; i < tn; ++i) {
                double offset = timePosition + sem.getTimecodePointOffsetAt(i);
                double value = needlePosition + sem.getTimecodePointValueAt(i);
                model.putTimecodePoint(offset, value);
            }
            int fn = sem.getFaderMoveCount();
            for (int i = 0; i < fn; ++i) {
                double offset = timePosition + sem.getFaderMoveOffsetAt(i);
                FaderMove move = sem.getFaderMoveAt(i);
                model.putFaderMove(offset, move);
            }
            timePosition = model.getTimeLength();
            if (tn <= 0) continue;
            needlePosition += sem.getTimecodePointValueAt(tn - 1);
        }
        return model;
    }
}

