/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.systray;

import com.spacekiller.infection.platform.DefaultInfectionPlugin;
import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.systray.SystemTrayManagerImpl;
import com.spacekiller.util.Extension;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.swing.SystemTrayIcon;
import com.spacekiller.util.swing.SystemTrayManager;
import com.spacekiller.util.tooling.ToolGroup;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class SystemTrayPlugin
extends Plugin {
    public static final String SYSTRAY_PLUGIN_ID = "com.spacekiller.infection.systray";
    private static final Logger logger = Logger.getLogger(SystemTrayPlugin.class.getName());
    private SystemTrayManager systemTrayManager;

    public static SystemTrayPlugin getInstance() throws Exception {
        return (SystemTrayPlugin)Platform.getInstance().getPlugin(SYSTRAY_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
        try {
            Platform plat = this.getPlatform();
            Plugin infectionPlugin = DefaultInfectionPlugin.getInstance((Platform)plat);
            PluginDescriptor descr = plat.getPluginDescriptor(infectionPlugin);
            String extensionId = "SystemTrayPopupMenu_Group";
            Extension extension = descr.getExtension(extensionId);
            if (extension == null) {
                logger.warning("Extension not found: " + extensionId);
                return;
            }
            Object extensionInstance = this.getExtensionInstance(extension);
            logger.info("SystemTrayPopupMenuGroup: " + extensionInstance);
            JPopupMenu popup = null;
            if (extensionInstance instanceof ToolGroup) {
                ToolGroup group = (ToolGroup)extensionInstance;
                popup = (JPopupMenu)group.create(JPopupMenu.class);
            }
            SystemTrayManager manager = this.getSystemTrayManager();
            Dimension trayIconSize = manager.getTrayIconSize();
            Image iconImage = this.getDefaultTrayIconImage(trayIconSize);
            String tooltip = this.getDefaultTrayIconTooltip();
            SystemTrayIcon trayIcon = manager.createTrayIcon(iconImage);
            trayIcon.setImageAutoSize(true);
            trayIcon.setTooltip(tooltip);
            trayIcon.setPopupMenu(popup);
            manager.addTrayIcon(trayIcon);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void shutdown() {
        super.shutdown();
    }

    protected SystemTrayManager createSystemTrayManager() {
        return new SystemTrayManagerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemTrayManager getSystemTrayManager() {
        if (this.systemTrayManager == null) {
            SystemTrayPlugin systemTrayPlugin = this;
            synchronized (systemTrayPlugin) {
                if (this.systemTrayManager == null) {
                    this.setSystemTrayManager(this.createSystemTrayManager());
                }
            }
        }
        return this.systemTrayManager;
    }

    private void setSystemTrayManager(SystemTrayManager systemTrayManager) {
        this.systemTrayManager = systemTrayManager;
    }

    protected Image getDefaultTrayIconImage(Dimension iconSize) throws IOException {
        String resource2;
        String resource1;
        InfectionPlatform ip = InfectionPlatform.getInfectionPlatform();
        if (iconSize != null && iconSize.width >= 32) {
            resource1 = "icon32";
            resource2 = "icon16";
        } else {
            resource1 = "icon16";
            resource2 = "icon32";
        }
        Image iconImage = ip.getDistributionResourceImage(resource1);
        if (iconImage == null) {
            iconImage = ip.getDistributionResourceImage(resource2);
        }
        if (iconImage == null) {
            URL url = ((Object)((Object)this)).getClass().getResource("/com/spacekiller/infection/platform/icons/infection_icon16.jpg");
            iconImage = new ImageIcon(url).getImage();
        }
        return iconImage;
    }

    protected String getDefaultTrayIconTooltip() {
        InfectionPlatform ip = InfectionPlatform.getInfectionPlatform();
        return ip.getDistributionProperty("title");
    }
}

