/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.lock.Lock;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.waxmonster.midi.MidiProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class AsyncMidiProcessor
implements MidiProcessor {
    private static final Logger logger = Logger.getLogger(AsyncMidiProcessor.class.getName());
    protected MidiProcessor target;
    protected final ThreadManager threadManager;
    protected int threadPrio;
    protected String threadName;
    protected final LockSupport lockSupport;
    protected final Lock lock;
    protected Entry first;
    protected Entry last;
    protected Entry free;
    protected volatile Thread thread;
    protected volatile boolean active;

    public AsyncMidiProcessor(LockSupport lockSupport, LockFactory lockFactory, boolean fair, ThreadManager threadManager, int threadPrio, String threadName) {
        this.lockSupport = lockSupport;
        this.lock = lockFactory.createLock(fair);
        this.threadManager = threadManager;
        this.threadPrio = threadPrio;
        this.threadName = threadName;
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.thread = new Thread((Runnable)new Proc(), this.threadName);
        this.thread.setPriority(this.threadPrio);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stop() {
        this.active = false;
        this.lockSupport.unpark(this.thread);
    }

    protected Entry newEntry() {
        Entry entry = this.free;
        if (entry == null) {
            entry = new Entry();
        } else {
            this.free = entry.next;
            entry.next = null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long time, int status) {
        this.lock.lock();
        try {
            Entry entry = this.newEntry();
            entry.time = time;
            entry.status = status;
            entry.data1 = -1;
            entry.data2 = -1;
            if (this.last == null) {
                this.first = entry;
            } else {
                this.last.next = entry;
            }
            this.last = entry;
        }
        finally {
            this.lock.unlock();
        }
        this.lockSupport.unpark(this.thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long time, int status, int data1) {
        this.lock.lock();
        try {
            Entry entry = this.newEntry();
            entry.time = time;
            entry.status = status;
            entry.data1 = data1;
            entry.data2 = -1;
            if (this.last == null) {
                this.first = entry;
            } else {
                this.last.next = entry;
            }
            this.last = entry;
        }
        finally {
            this.lock.unlock();
        }
        this.lockSupport.unpark(this.thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long time, int status, int data1, int data2) {
        this.lock.lock();
        try {
            Entry entry = this.newEntry();
            entry.time = time;
            entry.status = status;
            entry.data1 = data1;
            entry.data2 = data2;
            if (this.last == null) {
                this.first = entry;
            } else {
                this.last.next = entry;
            }
            this.last = entry;
        }
        finally {
            this.lock.unlock();
        }
        this.lockSupport.unpark(this.thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long time, ShortMessage mc) {
        this.lock.lock();
        try {
            Entry entry = this.newEntry();
            entry.time = time;
            entry.mc = mc;
            if (this.last == null) {
                this.first = entry;
            } else {
                this.last.next = entry;
            }
            this.last = entry;
        }
        finally {
            this.lock.unlock();
        }
        this.lockSupport.unpark(this.thread);
    }

    public void process(long time, SysexMessage sm) {
    }

    public void shutdown() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncLoop() throws Exception {
        Entry entry = null;
        while (this.active) {
            this.lock.lock();
            try {
                if (entry != null) {
                    entry.next = this.free;
                    this.free = entry;
                }
                if ((entry = this.first) != null) {
                    this.first = entry.next;
                    if (this.first == null) {
                        this.last = null;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            if (entry != null) {
                entry.fireAndForget();
                continue;
            }
            this.lockSupport.park();
        }
    }

    public MidiProcessor getTarget() {
        return this.target;
    }

    public void setTarget(MidiProcessor target) {
        this.target = target;
    }

    protected class Proc
    implements Runnable {
        protected Proc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("AsyncMidiProcessor thread started: " + AsyncMidiProcessor.this);
            }
            try {
                if (AsyncMidiProcessor.this.threadManager != null) {
                    AsyncMidiProcessor.this.threadManager.registerThread(Thread.currentThread());
                }
                AsyncMidiProcessor.this.asyncLoop();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("AsyncMidiProcessor thread stopped: " + AsyncMidiProcessor.this);
                }
                if (AsyncMidiProcessor.this.threadManager != null) {
                    AsyncMidiProcessor.this.threadManager.unregisterThread(Thread.currentThread());
                }
            }
        }
    }

    protected class Entry {
        protected Entry next;
        protected ShortMessage mc;
        protected long time;
        protected int status;
        protected int data1;
        protected int data2;

        protected Entry() {
        }

        public void fireAndForget() {
            MidiProcessor mp = AsyncMidiProcessor.this.target;
            if (mp == null) {
                return;
            }
            if (this.mc != null) {
                mp.process(this.time, this.mc);
                this.mc = null;
                return;
            }
            if (this.data2 < 0) {
                if (this.data1 < 0) {
                    mp.process(this.time, this.status);
                } else {
                    mp.process(this.time, this.status, this.data1);
                }
            } else {
                mp.process(this.time, this.status, this.data1, this.data2);
            }
        }
    }
}

