/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.Tools;
import com.waxmonster.midi.MidiPortType;
import com.waxmonster.midi.common.MidiJoinerDevice;
import com.waxmonster.midi.common.MidiJoinerDeviceInfo;
import com.waxmonster.midi.common.MidiMonitorDevice;
import com.waxmonster.midi.common.MidiMonitorDeviceInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import javax.swing.Icon;

public class CommonMidiDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "CommonMidiDeviceProvider";
    public static final String DEVICE_CATEGORY_NAME = "MIDI Tools";

    public CommonMidiDeviceProvider() {
        super(PROVIDER_NAME);
        this.initCommonMidiDeviceProvider();
    }

    protected void initCommonMidiDeviceProvider() {
        String name = "MIDI Monitor";
        String tooltip = "Monitor MIDI events";
        Icon midiMonitorIcon = Tools.getIcon(CommonMidiDeviceProvider.class, (String)"/com/waxmonster/midi/common/icons/waxmonster_midi_monitor_icon16.png");
        MidiMonitorDeviceInfo midiMonitor = new MidiMonitorDeviceInfo(name, tooltip, midiMonitorIcon);
        this.addDeviceInfo(midiMonitor);
        name = "MIDI Joiner";
        tooltip = "Joins MIDI events from multiple sources";
        Icon midiJoinerIcon = Tools.getIcon(CommonMidiDeviceProvider.class, (String)"/com/waxmonster/midi/common/icons/waxmonster_midi_joiner_icon16.png");
        MidiJoinerDeviceInfo midiJoiner = new MidiJoinerDeviceInfo(name, 2, tooltip, midiJoinerIcon);
        this.addDeviceInfo(midiJoiner);
    }

    public void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        if (info == null) {
            return null;
        }
        String name = info.getDeviceName();
        Icon iconColor16 = info.getIcon(1);
        if (info instanceof MidiMonitorDeviceInfo) {
            return new MidiMonitorDevice(this, name, iconColor16);
        }
        if (info instanceof MidiJoinerDeviceInfo) {
            MidiJoinerDeviceInfo joinerInfo = (MidiJoinerDeviceInfo)info;
            return new MidiJoinerDevice(this, name, iconColor16, joinerInfo.getInputPortCount());
        }
        return null;
    }

    public PortType getPortType(String typeName) {
        return MidiPortType.getMidiPortType((String)typeName);
    }
}

