/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.common.MultiMidiAction;
import java.util.Arrays;

public class MidiActionMap {
    protected static final int MAX_MIDI_CHANNELS = 16;
    protected static final int MAX_MIDI_VALUES = 128;
    protected static final int MAX_MIDI_ENTRIES = 2048;
    protected final MidiAction[] actionNoteOnOff = new MidiAction[2048];
    protected final MidiAction[] actionPolyPressure = new MidiAction[2048];
    protected final MidiAction[] actionControlChange = new MidiAction[2048];
    protected final MidiAction[] actionProgramChange = new MidiAction[16];
    protected final MidiAction[] actionChannelPressure = new MidiAction[16];
    protected final MidiAction[] actionPitchBend = new MidiAction[16];
    protected MidiAction actionSystemExclusive;
    protected MidiAction actionMidiTimecode;
    protected MidiAction actionSongPosition;
    protected MidiAction actionSongSelect;
    protected MidiAction actionTuneRequest;
    protected MidiAction actionTimingClock;
    protected MidiAction actionSystemStart;
    protected MidiAction actionSystemContinue;
    protected MidiAction actionSystemStop;
    protected MidiAction actionActiveSensing;
    protected MidiAction actionSystemReset;

    public void addMidiMapping(int channel, int status, int index, MidiAction action) {
        if (action == null) {
            return;
        }
        if (status < 240) {
            switch (status & 0xF0) {
                case 128: 
                case 144: {
                    if (channel >= 0) {
                        int ofs = channel << 7 | index;
                        this.actionNoteOnOff[ofs] = this.includeMidiAction(this.actionNoteOnOff[ofs], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            int ofs = channel << 7 | index;
                            this.actionNoteOnOff[ofs] = this.includeMidiAction(this.actionNoteOnOff[ofs], action);
                        }
                    }
                    return;
                }
                case 160: {
                    if (channel >= 0) {
                        int ofs = channel << 7 | index;
                        this.actionPolyPressure[ofs] = this.includeMidiAction(this.actionPolyPressure[ofs], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            int ofs = channel << 7 | index;
                            this.actionPolyPressure[ofs] = this.includeMidiAction(this.actionPolyPressure[ofs], action);
                        }
                    }
                    return;
                }
                case 176: {
                    if (channel >= 0) {
                        int ofs = channel << 7 | index;
                        this.actionControlChange[ofs] = this.includeMidiAction(this.actionControlChange[ofs], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            int ofs = channel << 7 | index;
                            this.actionControlChange[ofs] = this.includeMidiAction(this.actionControlChange[ofs], action);
                        }
                    }
                    return;
                }
                case 192: {
                    if (channel >= 0) {
                        this.actionProgramChange[channel] = this.includeMidiAction(this.actionProgramChange[channel], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            this.actionProgramChange[channel] = this.includeMidiAction(this.actionProgramChange[channel], action);
                        }
                    }
                    return;
                }
                case 208: {
                    if (channel >= 0) {
                        this.actionChannelPressure[channel] = this.includeMidiAction(this.actionChannelPressure[channel], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            this.actionChannelPressure[channel] = this.includeMidiAction(this.actionChannelPressure[channel], action);
                        }
                    }
                    return;
                }
                case 224: {
                    if (channel >= 0) {
                        this.actionPitchBend[channel] = this.includeMidiAction(this.actionPitchBend[channel], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            this.actionPitchBend[channel] = this.includeMidiAction(this.actionPitchBend[channel], action);
                        }
                    }
                    return;
                }
            }
        } else {
            switch (status) {
                case 240: {
                    this.actionSystemExclusive = this.includeMidiAction(this.actionSystemExclusive, action);
                    return;
                }
                case 241: {
                    this.actionMidiTimecode = this.includeMidiAction(this.actionMidiTimecode, action);
                    return;
                }
                case 242: {
                    this.actionSongPosition = this.includeMidiAction(this.actionSongPosition, action);
                    return;
                }
                case 243: {
                    this.actionSongSelect = this.includeMidiAction(this.actionSongSelect, action);
                    return;
                }
                case 246: {
                    this.actionTuneRequest = this.includeMidiAction(this.actionTuneRequest, action);
                    return;
                }
                case 248: {
                    this.actionTimingClock = this.includeMidiAction(this.actionTimingClock, action);
                    return;
                }
                case 250: {
                    this.actionSystemStart = this.includeMidiAction(this.actionSystemStart, action);
                    return;
                }
                case 251: {
                    this.actionSystemContinue = this.includeMidiAction(this.actionSystemContinue, action);
                    return;
                }
                case 252: {
                    this.actionSystemStop = this.includeMidiAction(this.actionSystemStop, action);
                    return;
                }
                case 254: {
                    this.actionActiveSensing = this.includeMidiAction(this.actionActiveSensing, action);
                    return;
                }
                case 255: {
                    this.actionSystemReset = this.includeMidiAction(this.actionSystemReset, action);
                    return;
                }
            }
        }
    }

    public void removeMidiMapping(int channel, int status, int index, MidiAction action) {
        if (action == null) {
            return;
        }
        if (status < 240) {
            switch (status & 0xF0) {
                case 128: 
                case 144: {
                    if (channel >= 0) {
                        int ofs = channel << 7 | index;
                        this.actionNoteOnOff[ofs] = this.excludeMidiAction(this.actionNoteOnOff[ofs], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            int ofs = channel << 7 | index;
                            this.actionNoteOnOff[ofs] = this.excludeMidiAction(this.actionNoteOnOff[ofs], action);
                        }
                    }
                    return;
                }
                case 160: {
                    if (channel >= 0) {
                        int ofs = channel << 7 | index;
                        this.actionPolyPressure[ofs] = this.excludeMidiAction(this.actionPolyPressure[ofs], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            int ofs = channel << 7 | index;
                            this.actionPolyPressure[ofs] = this.excludeMidiAction(this.actionPolyPressure[ofs], action);
                        }
                    }
                    return;
                }
                case 176: {
                    if (channel >= 0) {
                        int ofs = channel << 7 | index;
                        this.actionControlChange[ofs] = this.excludeMidiAction(this.actionControlChange[ofs], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            int ofs = channel << 7 | index;
                            this.actionControlChange[ofs] = this.excludeMidiAction(this.actionControlChange[ofs], action);
                        }
                    }
                    return;
                }
                case 192: {
                    if (channel >= 0) {
                        this.actionProgramChange[channel] = this.excludeMidiAction(this.actionProgramChange[channel], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            this.actionProgramChange[channel] = this.excludeMidiAction(this.actionProgramChange[channel], action);
                        }
                    }
                    return;
                }
                case 208: {
                    if (channel >= 0) {
                        this.actionChannelPressure[channel] = this.excludeMidiAction(this.actionChannelPressure[channel], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            this.actionChannelPressure[channel] = this.excludeMidiAction(this.actionChannelPressure[channel], action);
                        }
                    }
                    return;
                }
                case 224: {
                    if (channel >= 0) {
                        this.actionPitchBend[channel] = this.excludeMidiAction(this.actionPitchBend[channel], action);
                    } else {
                        for (channel = 0; channel < 16; ++channel) {
                            this.actionPitchBend[channel] = this.excludeMidiAction(this.actionPitchBend[channel], action);
                        }
                    }
                    return;
                }
            }
        } else {
            switch (status) {
                case 240: {
                    this.actionSystemExclusive = this.excludeMidiAction(this.actionSystemExclusive, action);
                    return;
                }
                case 241: {
                    this.actionMidiTimecode = this.excludeMidiAction(this.actionMidiTimecode, action);
                    return;
                }
                case 242: {
                    this.actionSongPosition = this.excludeMidiAction(this.actionSongPosition, action);
                    return;
                }
                case 243: {
                    this.actionSongSelect = this.excludeMidiAction(this.actionSongSelect, action);
                    return;
                }
                case 246: {
                    this.actionTuneRequest = this.excludeMidiAction(this.actionTuneRequest, action);
                    return;
                }
                case 248: {
                    this.actionTimingClock = this.excludeMidiAction(this.actionTimingClock, action);
                    return;
                }
                case 250: {
                    this.actionSystemStart = this.excludeMidiAction(this.actionSystemStart, action);
                    return;
                }
                case 251: {
                    this.actionSystemContinue = this.excludeMidiAction(this.actionSystemContinue, action);
                    return;
                }
                case 252: {
                    this.actionSystemStop = this.excludeMidiAction(this.actionSystemStop, action);
                    return;
                }
                case 254: {
                    this.actionActiveSensing = this.excludeMidiAction(this.actionActiveSensing, action);
                    return;
                }
                case 255: {
                    this.actionSystemReset = this.excludeMidiAction(this.actionSystemReset, action);
                    return;
                }
            }
        }
    }

    protected MidiAction includeMidiAction(MidiAction current, MidiAction action) {
        if (current == null) {
            return action;
        }
        if (current == action) {
            return current;
        }
        return new MultiMidiAction(current, action);
    }

    protected MidiAction excludeMidiAction(MidiAction current, MidiAction action) {
        if (current == null) {
            return null;
        }
        if (current == action) {
            return null;
        }
        if (current instanceof MultiMidiAction) {
            MultiMidiAction multi = (MultiMidiAction)current;
            MidiAction[] array = multi.getActions();
            int num = array.length;
            for (int i = 0; i < num; ++i) {
                if (array[i] != action) continue;
                if (num > 1) {
                    MidiAction[] mfcs = new MidiAction[num - 1];
                    System.arraycopy(array, 0, mfcs, 0, i);
                    System.arraycopy(array, i + 1, mfcs, i, num - i - 1);
                    return new MultiMidiAction(mfcs);
                }
                return null;
            }
        }
        return current;
    }

    public void clear() {
        Arrays.fill(this.actionNoteOnOff, null);
        Arrays.fill(this.actionPolyPressure, null);
        Arrays.fill(this.actionControlChange, null);
        Arrays.fill(this.actionProgramChange, null);
        Arrays.fill(this.actionChannelPressure, null);
        Arrays.fill(this.actionPitchBend, null);
        this.actionSystemExclusive = null;
        this.actionMidiTimecode = null;
        this.actionSongPosition = null;
        this.actionSongSelect = null;
        this.actionTuneRequest = null;
        this.actionTimingClock = null;
        this.actionSystemStart = null;
        this.actionSystemContinue = null;
        this.actionSystemStop = null;
        this.actionActiveSensing = null;
        this.actionSystemReset = null;
    }
}

