/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.common.MidiActionMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class MidiActionProcessor
implements MidiProcessor {
    private final String name;
    private MidiActionMap map;
    private MidiActionMap map2;
    private boolean valid;
    private Map actionMap;
    private List mappingList;

    public MidiActionProcessor(String name) {
        this.name = name;
        this.map = new MidiActionMap();
        this.actionMap = new HashMap();
        this.mappingList = new ArrayList();
        this.valid = true;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    public void process(long time, int status) {
        switch (status) {
            case 246: {
                MidiAction ma = this.map.actionTuneRequest;
                if (ma != null) {
                    ma.invoke(time, 246, 0, 0);
                }
                return;
            }
            case 248: {
                MidiAction ma = this.map.actionTimingClock;
                if (ma != null) {
                    ma.invoke(time, 248, 0, 0);
                }
                return;
            }
            case 250: {
                MidiAction ma = this.map.actionSystemStart;
                if (ma != null) {
                    ma.invoke(time, 250, 0, 0);
                }
                return;
            }
            case 251: {
                MidiAction ma = this.map.actionSystemContinue;
                if (ma != null) {
                    ma.invoke(time, 251, 0, 0);
                }
                return;
            }
            case 252: {
                MidiAction ma = this.map.actionSystemStop;
                if (ma != null) {
                    ma.invoke(time, 252, 0, 0);
                }
                return;
            }
            case 254: {
                MidiAction ma = this.map.actionActiveSensing;
                if (ma != null) {
                    ma.invoke(time, 254, 0, 0);
                }
                return;
            }
            case 255: {
                MidiAction ma = this.map.actionSystemReset;
                if (ma != null) {
                    ma.invoke(time, 255, 0, 0);
                }
                return;
            }
        }
    }

    public void process(long time, int status, int data1) {
        if (status < 240) {
            switch (status & 0xF0) {
                case 128: {
                    int channel = status & 0xF;
                    int note = data1 & 0x7F;
                    MidiAction ma = this.map.actionNoteOnOff[channel << 7 | note];
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 192: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionProgramChange[channel];
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 208: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionChannelPressure[channel];
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
            }
        } else {
            switch (status) {
                case 241: {
                    MidiAction ma = this.map.actionMidiTimecode;
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 243: {
                    MidiAction ma = this.map.actionSongSelect;
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 248: {
                    MidiAction ma = this.map.actionTimingClock;
                    if (ma != null) {
                        ma.invoke(time, 248, 0, 0);
                    }
                    return;
                }
                case 250: {
                    MidiAction ma = this.map.actionSystemStart;
                    if (ma != null) {
                        ma.invoke(time, 250, 0, 0);
                    }
                    return;
                }
                case 251: {
                    MidiAction ma = this.map.actionSystemContinue;
                    if (ma != null) {
                        ma.invoke(time, 251, 0, 0);
                    }
                    return;
                }
                case 252: {
                    MidiAction ma = this.map.actionSystemStop;
                    if (ma != null) {
                        ma.invoke(time, 252, 0, 0);
                    }
                    return;
                }
                case 254: {
                    MidiAction ma = this.map.actionActiveSensing;
                    if (ma != null) {
                        ma.invoke(time, 254, 0, 0);
                    }
                    return;
                }
                case 255: {
                    MidiAction ma = this.map.actionSystemReset;
                    if (ma != null) {
                        ma.invoke(time, 255, 0, 0);
                    }
                    return;
                }
            }
        }
    }

    public void process(long time, int status, int data1, int data2) {
        if (status < 240) {
            switch (status & 0xF0) {
                case 128: {
                    int channel = status & 0xF;
                    int note = data1 & 0x7F;
                    MidiAction ma = this.map.actionNoteOnOff[channel << 7 | note];
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 144: {
                    int channel = status & 0xF;
                    int note = data1 & 0x7F;
                    MidiAction ma = this.map.actionNoteOnOff[channel << 7 | note];
                    if (ma != null) {
                        ma.invoke(time, status, data1, data2);
                    }
                    return;
                }
                case 160: {
                    int channel = status & 0xF;
                    int note = data1 & 0x7F;
                    MidiAction ma = this.map.actionPolyPressure[channel << 7 | note];
                    if (ma != null) {
                        ma.invoke(time, status, data1, data2);
                    }
                    return;
                }
                case 176: {
                    int channel = status & 0xF;
                    int controller = data1 & 0x7F;
                    MidiAction ma = this.map.actionControlChange[channel << 7 | controller];
                    if (ma != null) {
                        ma.invoke(time, status, data1, data2);
                    }
                    return;
                }
                case 192: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionProgramChange[channel];
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 208: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionChannelPressure[channel];
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 224: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionPitchBend[channel];
                    if (ma != null) {
                        ma.invoke(time, status, data1, data2);
                    }
                    return;
                }
            }
        } else {
            switch (status) {
                case 241: {
                    MidiAction ma = this.map.actionMidiTimecode;
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 242: {
                    MidiAction ma = this.map.actionSongPosition;
                    if (ma != null) {
                        ma.invoke(time, status, data1, data2);
                    }
                    return;
                }
                case 243: {
                    MidiAction ma = this.map.actionSongSelect;
                    if (ma != null) {
                        ma.invoke(time, status, data1, 0);
                    }
                    return;
                }
                case 248: {
                    MidiAction ma = this.map.actionTimingClock;
                    if (ma != null) {
                        ma.invoke(time, 248, 0, 0);
                    }
                    return;
                }
                case 250: {
                    MidiAction ma = this.map.actionSystemStart;
                    if (ma != null) {
                        ma.invoke(time, 250, 0, 0);
                    }
                    return;
                }
                case 251: {
                    MidiAction ma = this.map.actionSystemContinue;
                    if (ma != null) {
                        ma.invoke(time, 251, 0, 0);
                    }
                    return;
                }
                case 252: {
                    MidiAction ma = this.map.actionSystemStop;
                    if (ma != null) {
                        ma.invoke(time, 252, 0, 0);
                    }
                    return;
                }
                case 254: {
                    MidiAction ma = this.map.actionActiveSensing;
                    if (ma != null) {
                        ma.invoke(time, 254, 0, 0);
                    }
                    return;
                }
                case 255: {
                    MidiAction ma = this.map.actionSystemReset;
                    if (ma != null) {
                        ma.invoke(time, 255, 0, 0);
                    }
                    return;
                }
            }
        }
    }

    public void process(long time, ShortMessage mc) {
        int status = mc.getStatus();
        if (status < 240) {
            switch (status & 0xF0) {
                case 128: {
                    int channel = status & 0xF;
                    int note = mc.getData1() & 0x7F;
                    MidiAction ma = this.map.actionNoteOnOff[channel << 7 | note];
                    if (ma != null) {
                        ma.invoke(time, status, note, 0);
                    }
                    return;
                }
                case 144: {
                    int channel = status & 0xF;
                    int note = mc.getData1() & 0x7F;
                    MidiAction ma = this.map.actionNoteOnOff[channel << 7 | note];
                    if (ma != null) {
                        ma.invoke(time, status, note, mc.getData2());
                    }
                    return;
                }
                case 160: {
                    int channel = status & 0xF;
                    int note = mc.getData1() & 0x7F;
                    MidiAction ma = this.map.actionPolyPressure[channel << 7 | note];
                    if (ma != null) {
                        ma.invoke(time, status, note, mc.getData2());
                    }
                    return;
                }
                case 176: {
                    int channel = status & 0xF;
                    int controller = mc.getData1() & 0x7F;
                    MidiAction ma = this.map.actionControlChange[channel << 7 | controller];
                    if (ma != null) {
                        ma.invoke(time, status, controller, mc.getData2());
                    }
                    return;
                }
                case 192: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionProgramChange[channel];
                    if (ma != null) {
                        ma.invoke(time, status, mc.getData1(), 0);
                    }
                    return;
                }
                case 208: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionChannelPressure[channel];
                    if (ma != null) {
                        ma.invoke(time, status, mc.getData1(), 0);
                    }
                    return;
                }
                case 224: {
                    int channel = status & 0xF;
                    MidiAction ma = this.map.actionPitchBend[channel];
                    if (ma != null) {
                        ma.invoke(time, status, mc.getData1(), mc.getData2());
                    }
                    return;
                }
            }
        } else {
            switch (status) {
                case 240: {
                    MidiAction ma = this.map.actionSystemExclusive;
                    if (ma != null) {
                        ma.systemExclusive(time, (MidiMessage)mc);
                    }
                    return;
                }
                case 241: {
                    MidiAction ma = this.map.actionMidiTimecode;
                    if (ma != null) {
                        ma.invoke(time, status, mc.getData1(), 0);
                    }
                    return;
                }
                case 242: {
                    MidiAction ma = this.map.actionSongPosition;
                    if (ma != null) {
                        ma.invoke(time, status, mc.getData1(), mc.getData2());
                    }
                    return;
                }
                case 243: {
                    MidiAction ma = this.map.actionSongSelect;
                    if (ma != null) {
                        ma.invoke(time, status, mc.getData1(), 0);
                    }
                    return;
                }
                case 248: {
                    MidiAction ma = this.map.actionTimingClock;
                    if (ma != null) {
                        ma.invoke(time, 248, 0, 0);
                    }
                    return;
                }
                case 250: {
                    MidiAction ma = this.map.actionSystemStart;
                    if (ma != null) {
                        ma.invoke(time, 250, 0, 0);
                    }
                    return;
                }
                case 251: {
                    MidiAction ma = this.map.actionSystemContinue;
                    if (ma != null) {
                        ma.invoke(time, 251, 0, 0);
                    }
                    return;
                }
                case 252: {
                    MidiAction ma = this.map.actionSystemStop;
                    if (ma != null) {
                        ma.invoke(time, 252, 0, 0);
                    }
                    return;
                }
                case 254: {
                    MidiAction ma = this.map.actionActiveSensing;
                    if (ma != null) {
                        ma.invoke(time, 254, 0, 0);
                    }
                    return;
                }
                case 255: {
                    MidiAction ma = this.map.actionSystemReset;
                    if (ma != null) {
                        ma.invoke(time, 255, 0, 0);
                    }
                    return;
                }
            }
        }
    }

    public void process(long time, SysexMessage sm) {
        MidiAction ma = this.map.actionSystemExclusive;
        if (ma != null) {
            ma.systemExclusive(time, (MidiMessage)sm);
        }
    }

    public void shutdown() {
    }

    public synchronized void reset(MidiAction[] actions, MidiMapping[] mappings) {
        this.removeAllMidiMappings();
        this.removeAllMidiActions();
        this.addMidiActions(actions);
        this.addMidiMappings(mappings);
    }

    public synchronized int getMidiActionCount() {
        return this.actionMap.size();
    }

    public synchronized void addMidiActions(MidiAction[] actions) {
        int num = actions == null ? 0 : actions.length;
        for (int i = 0; i < num; ++i) {
            MidiAction action = actions[i];
            if (action == null) continue;
            this.addMidiAction(action.getName(), action);
        }
    }

    public synchronized void addMidiAction(MidiAction action) {
        this.addMidiAction(action.getName(), action);
    }

    public synchronized void addMidiAction(String name, MidiAction action) {
        if (action == null || name == null) {
            return;
        }
        if (this.actionMap.get(name) == action) {
            return;
        }
        this.actionMap.put(name, action);
        this.valid = false;
    }

    public synchronized boolean removeMidiAction(String name, MidiAction action) {
        if (action == null || name == null) {
            return false;
        }
        if (this.actionMap.get(name) != action) {
            return false;
        }
        if (this.actionMap.remove(name) == null) {
            return false;
        }
        this.valid = false;
        return true;
    }

    public synchronized boolean removeMidiAction(String name) {
        if (this.actionMap.remove(name) == null) {
            return false;
        }
        this.valid = false;
        return true;
    }

    public synchronized void removeAllMidiActions() {
        if (this.actionMap.isEmpty()) {
            return;
        }
        this.actionMap.clear();
        this.valid = false;
    }

    public synchronized int getMidiMappingCount() {
        return this.mappingList.size();
    }

    public synchronized void addMidiMapping(MidiMapping mapping) {
        if (mapping == null) {
            return;
        }
        this.mappingList.add(mapping);
        this.valid = false;
    }

    public synchronized void addMidiMappingAt(MidiMapping mapping, int index) {
        if (mapping == null) {
            return;
        }
        this.mappingList.add(index, mapping);
        this.valid = false;
    }

    public synchronized void addMidiMappings(MidiMapping[] mappings) {
        if (mappings == null) {
            return;
        }
        boolean changed = false;
        for (MidiMapping mapping : mappings) {
            if (mapping == null) continue;
            this.mappingList.add(mapping);
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.valid = false;
    }

    public synchronized void removeMidiMapping(MidiMapping mapping) {
        if (!this.mappingList.remove(mapping)) {
            return;
        }
        this.valid = false;
    }

    public synchronized void removeMidiMappingsAt(int index) {
        this.mappingList.remove(index);
        this.valid = false;
    }

    public synchronized void removeMidiMappings(MidiMapping[] mappings) {
        if (mappings == null) {
            return;
        }
        boolean changed = false;
        for (MidiMapping mapping : mappings) {
            if (mapping == null || !this.mappingList.remove(mapping)) continue;
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.valid = false;
    }

    public synchronized void removeAllMidiMappings() {
        if (this.mappingList.isEmpty()) {
            return;
        }
        this.mappingList.clear();
        this.valid = false;
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    public synchronized void validate() {
        if (this.valid) {
            return;
        }
        MidiActionMap oldMap = this.map;
        MidiActionMap newMap = this.map2;
        if (newMap == null) {
            newMap = new MidiActionMap();
        }
        int num = this.mappingList.size();
        for (int i = 0; i < num; ++i) {
            MidiAction action;
            MidiMapping mapping = (MidiMapping)this.mappingList.get(i);
            if (mapping == null || (action = (MidiAction)this.actionMap.get(mapping.getAction())) == null) continue;
            newMap.addMidiMapping(mapping.getChannel(), mapping.getCommand(), mapping.getIndex(), action);
        }
        this.map = newMap;
        if (oldMap != null) {
            oldMap.clear();
        }
        this.map2 = oldMap;
        this.valid = true;
    }
}

