/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiJoiner;
import com.waxmonster.midi.common.MidiJoinerPanel;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Icon;

public class MidiJoinerDevice
extends Device {
    public static final String KEY_INPUT_PORTS = "inputPorts";
    private final MidiSupportImpl support = new MidiSupportImpl();
    private int inputPortCount;
    private MidiInputPort[] inputPorts;
    private MidiOutputPort outputPort;
    private MidiJoinerPanel midiJoinerPanel;

    public MidiJoinerDevice(DeviceProvider provider, String name, Icon iconColor16, int inputPortCount) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.outputPort = new MidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, (MidiSupport)this.support);
        this.addPort((Port)this.outputPort);
        this.inputPorts = new MidiInputPort[0];
        this.inputPortCount = 0;
        this.setInputPortCount(inputPortCount);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.support.reset();
    }

    public synchronized Component getCustomizer() {
        if (this.midiJoinerPanel == null) {
            this.midiJoinerPanel = new MidiJoinerPanel();
            this.midiJoinerPanel.setOpaque(false);
            this.midiJoinerPanel.setDevice(this);
        }
        return this.midiJoinerPanel;
    }

    public int getInputPortCount() {
        return this.inputPortCount;
    }

    public synchronized void setInputPortCount(int newInputPortCount) throws StudioException {
        if (this.inputPortCount == newInputPortCount) {
            return;
        }
        MidiInputPort[] newArray = new MidiInputPort[newInputPortCount];
        if (newInputPortCount > this.inputPortCount) {
            System.arraycopy(this.inputPorts, 0, newArray, 0, this.inputPortCount);
            for (int i = this.inputPortCount; i < newInputPortCount; ++i) {
                MidiInputPort inputPort;
                newArray[i] = inputPort = new MidiInputPort("MIDI-In-" + Integer.toString(i + 1), MidiInputPortType.TYPE, (MidiSupport)this.support);
                this.addPort((Port)inputPort);
            }
        } else {
            System.arraycopy(this.inputPorts, 0, newArray, 0, newInputPortCount);
            for (int i = this.inputPortCount - 1; i >= newInputPortCount; --i) {
                MidiInputPort inputPort = this.inputPorts[i];
                this.getStudio().disconnect((Port)inputPort);
                this.removePort((Port)inputPort);
            }
        }
        this.inputPorts = newArray;
        this.inputPortCount = newArray.length;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        props.put(KEY_INPUT_PORTS, String.valueOf(this.getInputPortCount()));
        return props;
    }

    protected void applyProperty(String key, String value) {
        if (KEY_INPUT_PORTS.equals(key) && value != null) {
            try {
                this.setInputPortCount(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class SyncGroupImpl
    extends MidiSyncGroup {
        private MidiProcessor target;
        private MidiJoiner midiJoiner;

        public SyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
            this.midiJoiner = null;
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
            if (targets.length != 1) {
                throw new MidiException("Invalid number of target processors: " + targets.length + " != 1");
            }
            this.target = targets[0];
        }

        public synchronized MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            if (this.midiJoiner == null) {
                if (this.target == null) {
                    return null;
                }
                this.midiJoiner = new MidiJoiner(this.target);
            }
            return this.midiJoiner;
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroup syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new SyncGroupImpl(MidiJoinerDevice.this.getName(), MidiJoinerDevice.this.inputPorts, new MidiOutputPort[]{MidiJoinerDevice.this.outputPort});
            }
            return this.syncGroup;
        }
    }
}

