/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.common.MidiJoinerDevice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MidiJoinerPanel
extends JPanel {
    private static final long serialVersionUID = -2445756503682596998L;
    public static final int MAX_INPUT_PORTS = 16;
    private static final Logger logger = Logger.getLogger(MidiJoinerPanel.class.getName());
    private MidiJoinerDevice device;
    private JComboBox jComboBoxInputPorts = null;
    private JLabel jLabel = null;

    public MidiJoinerPanel() {
        this.initialize();
        this.initMidiJoinerPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints1.gridy = 0;
        this.jLabel = new JLabel();
        this.jLabel.setText("Input Ports:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(263, 159));
        this.add((Component)this.getJComboBoxInputPorts(), gridBagConstraints);
        this.add((Component)this.jLabel, gridBagConstraints1);
    }

    public MidiJoinerDevice getDevice() {
        return this.device;
    }

    public void setDevice(MidiJoinerDevice device) {
        this.device = device;
        this.refresh();
    }

    private JComboBox getJComboBoxInputPorts() {
        if (this.jComboBoxInputPorts == null) {
            this.jComboBoxInputPorts = new JComboBox();
            this.jComboBoxInputPorts.setOpaque(false);
            this.jComboBoxInputPorts.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MidiJoinerPanel.this.applyInputPorts();
                }
            });
        }
        return this.jComboBoxInputPorts;
    }

    protected void initMidiJoinerPanel() {
        this.getJComboBoxInputPorts().removeAllItems();
        for (int i = 1; i <= 16; ++i) {
            this.getJComboBoxInputPorts().addItem(Integer.toString(i));
        }
    }

    protected void refresh() {
        int inputPortCount = 1;
        MidiJoinerDevice dev = this.getDevice();
        if (dev != null) {
            inputPortCount = dev.getInputPortCount();
        }
        this.getJComboBoxInputPorts().setSelectedItem(Integer.toString(inputPortCount));
    }

    protected void applyInputPorts() {
        try {
            Object item = this.getJComboBoxInputPorts().getSelectedItem();
            int newInputPortCount = Integer.parseInt(String.valueOf(item));
            MidiJoinerDevice dev = this.getDevice();
            if (dev == null) {
                return;
            }
            dev.setInputPortCount(newInputPortCount);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

