/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.Data;
import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.plugin.MidiEventListModel;
import com.spacekiller.util.midi.plugin.MidiLearnPanel;
import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class MidiMapperComponent
extends JComponent {
    private static final long serialVersionUID = 578618939554338292L;
    private static final Logger logger = Logger.getLogger(MidiMapperComponent.class.getName());
    public static final Integer MIDI_LAYER = Data.toInteger((int)(JLayeredPane.PALETTE_LAYER + 18));
    private final KeyHandler keyHandler = new KeyHandler();
    private final MouseHandler mouseHandler = new MouseHandler();
    private final MouseMotionHandler mouseMotionHandler = new MouseMotionHandler();
    private Color overPaintColor = new Color(1.0f, 0.0f, 0.0f, 0.3f);
    private Color normalColor = new Color(0.4f, 0.0f, 1.0f, 0.4f);
    private Stroke normalStroke = new BasicStroke(2.0f);
    private Color mappedColor = new Color(0.0f, 1.0f, 0.0f, 0.4f);
    private Stroke mappedStroke = new BasicStroke(2.0f);
    private Color selectedColor = new Color(0.0f, 1.0f, 1.0f, 0.5f);
    private Stroke selectedStroke = new BasicStroke(3.0f);
    private RootPaneContainer rootContainer;
    private JLayeredPane layeredPane;
    private Container contentPane;
    private Map mappableComponents = new HashMap();
    private MappableComponent selectedComponent;
    private MidiFormatter midiFormatter;
    private MidiFactory midiFactory;

    public MidiMapperComponent() {
        this.setOpaque(false);
        this.setFocusable(true);
        this.addKeyListener(this.keyHandler);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseMotionHandler);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (toolTipManager != null) {
            toolTipManager.registerComponent(this);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rect;
        MappableComponent mc2;
        Color col = this.overPaintColor;
        if (col != null) {
            g.setColor(col);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        for (MappableComponent mc2 : this.mappableComponents.values()) {
            Rectangle rect2 = mc2.getBounds();
            if (rect2 == null) continue;
            if (mc2.isMapped()) {
                g2d.setColor(this.mappedColor);
                g2d.setStroke(this.mappedStroke);
            } else {
                g2d.setColor(this.normalColor);
                g2d.setStroke(this.normalStroke);
            }
            g2d.drawRect(rect2.x, rect2.y, rect2.width, rect2.height);
        }
        mc2 = this.selectedComponent;
        if (mc2 != null && (rect = mc2.getBounds()) != null && col != null) {
            g2d.setColor(this.selectedColor);
            g2d.setStroke(this.selectedStroke);
            g2d.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void validate() {
        super.validate();
        JLayeredPane layered = this.layeredPane;
        if (layered != null) {
            int newWidth = layered.getWidth();
            int newHeight = layered.getHeight();
            if (newWidth != this.getWidth() || newHeight != this.getHeight()) {
                this.setBounds(0, 0, newWidth, newHeight);
            }
        }
    }

    public synchronized boolean showMidiMapper(RootPaneContainer window) {
        this.hideMidiMapper();
        JLayeredPane layeredPane = window.getLayeredPane();
        if (layeredPane != null) {
            this.rootContainer = window;
            this.contentPane = window.getContentPane();
            this.layeredPane = layeredPane;
            layeredPane.add((Component)this, MIDI_LAYER);
            this.refresh();
            this.requestFocus();
            return true;
        }
        logger.warning("Unsupported window ancestor: " + window);
        return false;
    }

    public synchronized void hideMidiMapper() {
        if (this.layeredPane != null) {
            this.layeredPane.remove(this);
            this.layeredPane.validate();
            this.layeredPane.repaint();
            this.layeredPane = null;
        }
        this.contentPane = null;
        this.rootContainer = null;
    }

    public synchronized void refresh() {
        this.mappableComponents.clear();
        this.enumerateMappableComponents(this.contentPane, null, this.mappableComponents);
        this.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumerateMappableComponents(Component comp, MidiMapper mapper, Map map) {
        MidiMappable mm;
        MidiMapper mc;
        if (comp == null) {
            return;
        }
        if (comp instanceof MidiMappable && (mc = (mm = (MidiMappable)comp).getMidiMapper()) != null) {
            mapper = mc;
        }
        if (mapper != null && mapper.isMidiMappable((Object)comp) && this.isShowing(comp)) {
            MidiMapping[] mappings;
            MappableComponent mc2 = new MappableComponent();
            mc2.setComponent(comp);
            mc2.setMidiMapper(mapper);
            mc2.setBounds(this.getComponentBounds(comp));
            boolean mapped = false;
            String action = mapper.getDefaultAction((Object)comp);
            if (action != null && (mappings = mapper.getMidiMappings((Object)comp)) != null) {
                for (MidiMapping mam : mappings) {
                    if (mam == null || !action.equals(mam.getAction())) continue;
                    mapped = true;
                    break;
                }
            }
            mc2.setMapped(mapped);
            map.put(comp, mc2);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Object object = cont.getTreeLock();
            synchronized (object) {
                int count = cont.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    this.enumerateMappableComponents(cont.getComponent(i), mapper, map);
                }
            }
        }
    }

    protected void handleMouseMoved(MouseEvent e) {
        MappableComponent mc = this.getMappableComponentAt(e.getX(), e.getY());
        this.setSelectedComponent(mc);
    }

    protected void handleMousePressed(MouseEvent e) {
        this.handleMouseMoved(e);
        MappableComponent mc = this.getSelectedComponent();
        if (mc == null) {
            this.hideMidiMapper();
            return;
        }
        MidiMapper mapper = mc.getMidiMapper();
        if (mapper == null) {
            return;
        }
        Object mmc = mc.getComponent();
        if (mmc == null) {
            return;
        }
        String action = mapper.getDefaultAction(mmc);
        if (action == null) {
            return;
        }
        int mouseButton = e.getButton();
        if (mouseButton == 1) {
            MidiMapping mapping = this.showMidiWizardDialog(action);
            if (mapping != null) {
                this.addMidiMapping(mc, mapping);
            }
        } else {
            this.removeMidiMapping(mc, action);
        }
    }

    protected MappableComponent getMappableComponentAt(int x, int y) {
        Container content = this.contentPane;
        Component deep = null;
        if (content != null) {
            int cx = content.getX();
            int cy = content.getY();
            deep = SwingUtilities.getDeepestComponentAt(content, x - cx, y - cy);
        }
        for (Component comp = deep; comp != null; comp = comp.getParent()) {
            MappableComponent mc = (MappableComponent)this.mappableComponents.get(comp);
            if (mc == null) continue;
            return mc;
        }
        return null;
    }

    protected Rectangle getComponentBounds(Component comp) {
        Rectangle rect = comp.getBounds();
        JLayeredPane layered = this.layeredPane;
        for (Container parent = comp.getParent(); parent != null && parent != layered; parent = parent.getParent()) {
            rect.x += parent.getX();
            rect.y += parent.getY();
        }
        return rect;
    }

    protected boolean isShowing(Component comp) {
        return comp != null && comp.isShowing();
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    public MappableComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(MappableComponent comp) {
        if (this.selectedComponent == comp) {
            return;
        }
        this.selectedComponent = comp;
        this.repaint();
    }

    protected boolean removeMidiMapping(MappableComponent mc, String action) {
        Object component = mc.getComponent();
        if (component == null) {
            return false;
        }
        MidiMapper mapper = mc.getMidiMapper();
        if (mapper == null) {
            return false;
        }
        MidiMapping[] oldMappings = mapper.getMidiMappings(component);
        if (oldMappings == null) {
            return false;
        }
        LinkedList<MidiMapping> newMappingList = new LinkedList<MidiMapping>();
        boolean removed = false;
        for (MidiMapping mapping : oldMappings) {
            if (mapping != null && action != null && action.equals(mapping.getAction())) {
                removed = true;
                continue;
            }
            newMappingList.add(mapping);
        }
        if (!removed) {
            return false;
        }
        MidiMapping[] newMappings = newMappingList.toArray(new MidiMapping[newMappingList.size()]);
        mapper.setMidiMappings(component, newMappings);
        this.refresh();
        return true;
    }

    protected boolean addMidiMapping(MappableComponent mc, MidiMapping mapping) {
        if (mapping == null) {
            return false;
        }
        MidiMapper mapper = mc.getMidiMapper();
        if (mapper == null) {
            return false;
        }
        Object component = mc.getComponent();
        if (component == null) {
            return false;
        }
        MidiMapping[] oldMappings = mapper.getMidiMappings(component);
        int oldCount = oldMappings == null ? 0 : oldMappings.length;
        MidiMapping[] newMappings = new MidiMapping[oldCount + 1];
        if (oldCount > 0) {
            System.arraycopy(oldMappings, 0, newMappings, 0, oldCount);
        }
        newMappings[oldCount] = mapping;
        mapper.setMidiMappings(component, newMappings);
        this.refresh();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MidiMapping showMidiWizardDialog(String action) {
        try {
            MidiFactory factory = this.getMidiFactory();
            if (factory == null) {
                return null;
            }
            MidiManager midiManager = factory.createMidiManager();
            try {
                int index;
                int command;
                String title = "MIDI Wizard";
                int maxSize = 1000;
                MidiEventListModel model = new MidiEventListModel(maxSize);
                MidiLearnPanel panel = new MidiLearnPanel();
                panel.setMode(0);
                panel.setModel(model);
                panel.setMidiManager(midiManager);
                panel.setMidiFormatter(this.getMidiFormatter());
                panel.selectAllMidiDevices();
                MidiEventListModel.MidiHandler handler = model.getHandler();
                try {
                    midiManager.addMidiListener((MidiListener)handler);
                    if (!MidiLearnPanel.showMidiLearnDialog((Component)this, (String)title, (MidiLearnPanel)panel)) {
                        MidiMapping midiMapping = null;
                        return midiMapping;
                    }
                }
                finally {
                    midiManager.removeMidiListener((MidiListener)handler);
                }
                int midiChannel = panel.getMidiChannel();
                int midiController = panel.getMidiController();
                int midiNote = panel.getMidiNote();
                int channel = midiChannel >= 0 && midiChannel < 16 ? midiChannel : -1;
                if (midiController >= 0 && midiController < 128) {
                    command = 176;
                    index = midiController;
                } else if (midiNote >= 0 && midiNote < 128) {
                    command = 144;
                    index = midiNote;
                } else {
                    command = -1;
                    index = -1;
                }
                MidiMapping midiMapping = new MidiMapping(channel, command, index, action);
                return midiMapping;
            }
            finally {
                midiManager.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected MidiFactory lookupMidiFactory() {
        return DefaultMidiFactory.getInstance();
    }

    public MidiFactory getMidiFactory() {
        if (this.midiFactory == null) {
            this.setMidiFactory(this.lookupMidiFactory());
        }
        return this.midiFactory;
    }

    public void setMidiFactory(MidiFactory midiFactory) {
        this.midiFactory = midiFactory;
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    protected RootPaneContainer getRootContainer() {
        return this.rootContainer;
    }

    protected void setRootContainer(RootPaneContainer rootContainer) {
        this.rootContainer = rootContainer;
    }

    protected JLayeredPane getLayeredPane() {
        return this.layeredPane;
    }

    protected void setLayeredPane(JLayeredPane layeredPane) {
        this.layeredPane = layeredPane;
    }

    protected Container getContentPane() {
        return this.contentPane;
    }

    protected void setContentPane(Container contentPane) {
        this.contentPane = contentPane;
    }

    public Stroke getSelectedStroke() {
        return this.selectedStroke;
    }

    public void setSelectedStroke(Stroke selectedStroke) {
        this.selectedStroke = selectedStroke;
    }

    public Color getOverPaintColor() {
        return this.overPaintColor;
    }

    public void setOverPaintColor(Color overPaintColor) {
        this.overPaintColor = overPaintColor;
    }

    protected Color getNormalColor() {
        return this.normalColor;
    }

    protected void setNormalColor(Color normalColor) {
        this.normalColor = normalColor;
    }

    protected Stroke getNormalStroke() {
        return this.normalStroke;
    }

    protected void setNormalStroke(Stroke normalStroke) {
        this.normalStroke = normalStroke;
    }

    protected Color getMappedColor() {
        return this.mappedColor;
    }

    protected void setMappedColor(Color mappedColor) {
        this.mappedColor = mappedColor;
    }

    protected Stroke getMappedStroke() {
        return this.mappedStroke;
    }

    protected void setMappedStroke(Stroke mappedStroke) {
        this.mappedStroke = mappedStroke;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        MappableComponent mc = this.getMappableComponentAt(event.getX(), event.getY());
        if (mc != null) {
            MidiMapper mapper = mc.getMidiMapper();
            Object component = mc.getComponent();
            if (mapper != null && component != null) {
                String action = mapper.getDefaultAction(component);
                return action;
            }
        }
        return super.getToolTipText(event);
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            switch (e.getKeyChar()) {
                case '\u001b': {
                    MidiMapperComponent.this.hideMidiMapper();
                    return;
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            super.keyReleased(e);
        }
    }

    protected class MouseMotionHandler
    extends MouseMotionAdapter {
        protected MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            MidiMapperComponent.this.handleMouseMoved(e);
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            MidiMapperComponent.this.handleMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
        }
    }

    protected class MappableComponent {
        protected Object component;
        protected Rectangle bounds;
        protected MidiMapper midiMapper;
        protected boolean mapped;

        protected MappableComponent() {
        }

        protected Object getComponent() {
            return this.component;
        }

        protected void setComponent(Object component) {
            this.component = component;
        }

        protected Rectangle getBounds() {
            return this.bounds;
        }

        protected void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        protected MidiMapper getMidiMapper() {
            return this.midiMapper;
        }

        protected void setMidiMapper(MidiMapper midiMapper) {
            this.midiMapper = midiMapper;
        }

        protected boolean isMapped() {
            return this.mapped;
        }

        protected void setMapped(boolean mapped) {
            this.mapped = mapped;
        }
    }
}

