/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.plugin.MidiEventListModel;
import com.spacekiller.util.midi.plugin.MidiLearnPanel;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.MidiMappingPanel;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.common.PresetManagerPanel;
import com.waxmonster.studio.common.PresetProducer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MidiMappingManagerPanel
extends JPanel {
    private static final long serialVersionUID = -8460615328822454113L;
    private static final Logger logger = Logger.getLogger(MidiMappingManagerPanel.class.getName());
    private static final String ACTION_REMOVE = "RemoveSelectedMappings";
    private static final String ACTION_MOVE_UP = "MoveUpSelectedMappings";
    private static final String ACTION_MOVE_DOWN = "MoveDownSelectedMappings";
    private Studio studio;
    private String deviceName;
    private String presetName;
    private PresetProducer presetProducer = new PresetProducerImpl();
    private MidiAction[] availableActions;
    private MidiFormatter midiFormatter;
    private MidiFactory midiFactory;
    private DefaultListModel mappingListModel;
    private boolean refreshing;
    private JList listMappings;
    private MidiMappingPanel midiActionMappingPanel;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JPanel panel_2;
    private JPanel panel_1;
    private JPanel panel_3;
    private JButton buttonLearn;
    private JButton btnMoveup;
    private JButton btnMovedown;
    private JButton btnPresets;

    public MidiMappingManagerPanel() {
        this.setPreferredSize(new Dimension(600, 300));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Mappings", 4, 2, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 0, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panel.add((Component)scrollPane, gbc_scrollPane);
        this.listMappings = new JList();
        this.listMappings.setOpaque(false);
        this.listMappings.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MidiMappingManagerPanel.this.refreshSelectedMappingDetails();
            }
        });
        scrollPane.setViewportView(this.listMappings);
        this.panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(0, 4, 4, 4);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 1;
        panel.add((Component)this.panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.panel_2.setLayout(gbl_panel_2);
        this.buttonAdd = new JButton("");
        this.buttonAdd.setIcon(new ImageIcon(MidiMappingManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/insert.gif")));
        this.buttonAdd.setMargin(new Insets(2, 4, 2, 4));
        this.buttonAdd.setToolTipText("Add mapping");
        GridBagConstraints gbc_buttonAdd = new GridBagConstraints();
        gbc_buttonAdd.insets = new Insets(0, 0, 0, 5);
        gbc_buttonAdd.gridx = 0;
        gbc_buttonAdd.gridy = 0;
        this.panel_2.add((Component)this.buttonAdd, gbc_buttonAdd);
        this.buttonRemove = new JButton("");
        this.buttonRemove.setIcon(new ImageIcon(MidiMappingManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/remove_icon16.gif")));
        this.buttonRemove.setMargin(new Insets(2, 4, 2, 4));
        this.buttonRemove.setToolTipText("Remove selected mapping(s)");
        GridBagConstraints gbc_buttonRemove = new GridBagConstraints();
        gbc_buttonRemove.insets = new Insets(0, 0, 0, 5);
        gbc_buttonRemove.gridx = 1;
        gbc_buttonRemove.gridy = 0;
        this.panel_2.add((Component)this.buttonRemove, gbc_buttonRemove);
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiMappingManagerPanel.this.actionRemove();
            }
        });
        this.btnMoveup = new JButton("");
        GridBagConstraints gbc_btnMoveup = new GridBagConstraints();
        gbc_btnMoveup.insets = new Insets(0, 0, 0, 5);
        gbc_btnMoveup.gridx = 2;
        gbc_btnMoveup.gridy = 0;
        this.panel_2.add((Component)this.btnMoveup, gbc_btnMoveup);
        this.btnMoveup.setToolTipText("Move up...");
        this.btnMoveup.setIcon(new ImageIcon(MidiMappingManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/mapping_move_up.gif")));
        this.btnMoveup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiMappingManagerPanel.this.actionMoveUp();
            }
        });
        this.btnMoveup.setMargin(new Insets(2, 2, 2, 2));
        this.btnMovedown = new JButton("");
        GridBagConstraints gbc_btnMovedown = new GridBagConstraints();
        gbc_btnMovedown.insets = new Insets(0, 0, 0, 5);
        gbc_btnMovedown.gridx = 3;
        gbc_btnMovedown.gridy = 0;
        this.panel_2.add((Component)this.btnMovedown, gbc_btnMovedown);
        this.btnMovedown.setToolTipText("Move down...");
        this.btnMovedown.setIcon(new ImageIcon(MidiMappingManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/mapping_move_down.gif")));
        this.btnMovedown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiMappingManagerPanel.this.actionMoveDown();
            }
        });
        this.btnMovedown.setMargin(new Insets(2, 2, 2, 2));
        this.btnPresets = new JButton("Presets...");
        this.btnPresets.setToolTipText("Manage presets...");
        this.btnPresets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiMappingManagerPanel.this.actionManageMidiPresets();
            }
        });
        this.btnPresets.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnPresets = new GridBagConstraints();
        gbc_btnPresets.anchor = 13;
        gbc_btnPresets.weightx = 1.0;
        gbc_btnPresets.gridx = 4;
        gbc_btnPresets.gridy = 0;
        this.panel_2.add((Component)this.btnPresets, gbc_btnPresets);
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiMappingManagerPanel.this.actionAdd();
            }
        });
        this.panel_1 = new JPanel();
        this.panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Mapping Details", 4, 2, null, null));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 1;
        gbc_panel_1.gridy = 0;
        this.add((Component)this.panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panel_1.setLayout(gbl_panel_1);
        this.midiActionMappingPanel = new MidiMappingPanel();
        this.midiActionMappingPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (MidiMappingManagerPanel.this.refreshing) {
                    return;
                }
                if ("mapping".equals(evt.getPropertyName())) {
                    MidiMappingManagerPanel.this.applyMapping();
                }
            }
        });
        GridBagConstraints gbc_midiActionMappingPanel = new GridBagConstraints();
        gbc_midiActionMappingPanel.weighty = 1.0;
        gbc_midiActionMappingPanel.weightx = 1.0;
        gbc_midiActionMappingPanel.insets = new Insets(4, 4, 5, 4);
        gbc_midiActionMappingPanel.fill = 1;
        gbc_midiActionMappingPanel.gridx = 0;
        gbc_midiActionMappingPanel.gridy = 0;
        this.panel_1.add((Component)this.midiActionMappingPanel, gbc_midiActionMappingPanel);
        this.midiActionMappingPanel.setOpaque(false);
        this.panel_3 = new JPanel();
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.insets = new Insets(0, 4, 4, 4);
        gbc_panel_3.fill = 1;
        gbc_panel_3.gridx = 0;
        gbc_panel_3.gridy = 1;
        this.panel_1.add((Component)this.panel_3, gbc_panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0, 0};
        gbl_panel_3.rowHeights = new int[]{0, 0};
        gbl_panel_3.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_3.setLayout(gbl_panel_3);
        this.buttonLearn = new JButton("Learn...");
        this.buttonLearn.setMargin(new Insets(2, 4, 2, 4));
        this.buttonLearn.setToolTipText("Open MIDI Wizard to learn an event...");
        this.buttonLearn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiMappingManagerPanel.this.actionLearn();
            }
        });
        GridBagConstraints gbc_buttonLearn = new GridBagConstraints();
        gbc_buttonLearn.anchor = 17;
        gbc_buttonLearn.gridx = 0;
        gbc_buttonLearn.gridy = 0;
        this.panel_3.add((Component)this.buttonLearn, gbc_buttonLearn);
        this.initMidiMappingManagerPanel();
    }

    protected JList getListMappings() {
        return this.listMappings;
    }

    public MidiAction[] getAvailableActions() {
        return this.availableActions;
    }

    public void setAvailableActions(MidiAction[] availableActions) {
        this.availableActions = availableActions;
        this.getMidiActionMappingPanel().setAvailableActions(availableActions);
    }

    protected void initMidiMappingManagerPanel() {
        this.mappingListModel = new DefaultListModel();
        this.listMappings.setModel(this.mappingListModel);
        this.listMappings.getActionMap().put(ACTION_REMOVE, new ActionRemove());
        this.listMappings.getInputMap().put(KeyStroke.getKeyStroke(127, 0), ACTION_REMOVE);
        this.listMappings.getActionMap().put(ACTION_MOVE_UP, new ActionMoveUp());
        this.listMappings.getInputMap().put(KeyStroke.getKeyStroke(38, 8), ACTION_MOVE_UP);
        this.listMappings.getActionMap().put(ACTION_MOVE_DOWN, new ActionMoveDown());
        this.listMappings.getInputMap().put(KeyStroke.getKeyStroke(40, 8), ACTION_MOVE_DOWN);
    }

    public MidiMapping[] getMappings() {
        int size = this.mappingListModel.getSize();
        MidiMapping[] mappings = new MidiMapping[size];
        for (int i = 0; i < size; ++i) {
            mappings[i] = (MidiMapping)this.mappingListModel.get(i);
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMappings(MidiMapping[] mappings) {
        try {
            this.refreshing = true;
            this.mappingListModel.removeAllElements();
            int selIndex = -1;
            if (mappings != null) {
                for (int i = 0; i < mappings.length; ++i) {
                    if (mappings[i] == null) continue;
                    this.mappingListModel.addElement(mappings[i]);
                }
            }
            this.getListMappings().setSelectedIndex(selIndex);
            this.refreshSelectedMappingDetails();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void refreshSelectedMappingDetails() {
        int[] sel = this.getListMappings().getSelectedIndices();
        this.buttonRemove.setEnabled(sel.length > 0);
        this.btnMoveup.setEnabled(sel.length > 0 && sel[0] > 0);
        this.btnMovedown.setEnabled(sel.length > 0 && sel[sel.length - 1] < this.mappingListModel.getSize() - 1);
        MidiMapping mapping = null;
        Object item = this.getListMappings().getSelectedValue();
        if (sel.length == 1 && item != null && item instanceof MidiMapping) {
            mapping = (MidiMapping)item;
        }
        this.getMidiActionMappingPanel().setMapping(mapping);
        this.getMidiActionMappingPanel().setEnabled(mapping != null);
        this.getButtonLearn().setEnabled(mapping != null);
    }

    protected MidiMappingPanel getMidiActionMappingPanel() {
        return this.midiActionMappingPanel;
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
        this.getMidiActionMappingPanel().setMidiFormatter(midiFormatter);
    }

    protected void actionAdd() {
        MidiMapping mapping = new MidiMapping(-1, -1, -1, null);
        int selIndex = this.mappingListModel.getSize();
        this.mappingListModel.addElement(mapping);
        this.getListMappings().setSelectedIndex(selIndex);
        this.getListMappings().ensureIndexIsVisible(selIndex);
    }

    protected void actionRemove() {
        int[] sel = this.getListMappings().getSelectedIndices();
        for (int i = sel.length - 1; i >= 0; --i) {
            this.mappingListModel.remove(sel[i]);
        }
    }

    protected void applyMapping() {
        int[] sel = this.getListMappings().getSelectedIndices();
        if (sel.length != 1) {
            return;
        }
        MidiMapping newMapping = this.getMidiActionMappingPanel().getMapping();
        if (newMapping == null) {
            return;
        }
        int selIndex = sel[0];
        this.mappingListModel.set(selIndex, newMapping);
        this.getListMappings().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionLearn() {
        MidiMapping oldMapping = this.getMidiActionMappingPanel().getMapping();
        if (oldMapping == null) {
            return;
        }
        try {
            MidiFactory factory = this.getMidiFactory();
            if (factory == null) {
                return;
            }
            MidiManager midiManager = factory.createMidiManager();
            try {
                int index;
                int command;
                String title = "MIDI Wizard";
                int maxSize = 1000;
                MidiEventListModel model = new MidiEventListModel(maxSize);
                MidiLearnPanel panel = new MidiLearnPanel();
                panel.setMode(0);
                panel.setModel(model);
                panel.setMidiManager(midiManager);
                panel.setMidiFormatter(this.getMidiFormatter());
                panel.selectAllMidiDevices();
                MidiEventListModel.MidiHandler handler = model.getHandler();
                try {
                    midiManager.addMidiListener((MidiListener)handler);
                    if (!MidiLearnPanel.showMidiLearnDialog((Component)this, (String)title, (MidiLearnPanel)panel)) {
                        return;
                    }
                }
                finally {
                    midiManager.removeMidiListener((MidiListener)handler);
                }
                int midiChannel = panel.getMidiChannel();
                int midiController = panel.getMidiController();
                int midiNote = panel.getMidiNote();
                String action = oldMapping.getAction();
                int channel = midiChannel >= 0 && midiChannel < 16 ? midiChannel : -1;
                if (midiController >= 0 && midiController < 128) {
                    command = 176;
                    index = midiController;
                } else if (midiNote >= 0 && midiNote < 128) {
                    command = 144;
                    index = midiNote;
                } else {
                    command = -1;
                    index = -1;
                }
                MidiMapping newMapping = new MidiMapping(channel, command, index, action);
                this.getMidiActionMappingPanel().setMapping(newMapping);
                this.applyMapping();
            }
            finally {
                midiManager.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JButton getButtonLearn() {
        return this.buttonLearn;
    }

    protected MidiFactory lookupMidiFactory() {
        return DefaultMidiFactory.getInstance();
    }

    public MidiFactory getMidiFactory() {
        if (this.midiFactory == null) {
            this.setMidiFactory(this.lookupMidiFactory());
        }
        return this.midiFactory;
    }

    public void setMidiFactory(MidiFactory midiFactory) {
        this.midiFactory = midiFactory;
    }

    protected JButton getBtnMoveup() {
        return this.btnMoveup;
    }

    protected JButton getBtnMovedown() {
        return this.btnMovedown;
    }

    protected void actionMoveUp() {
        int[] sel = this.getListMappings().getSelectedIndices();
        if (sel.length > 0 && sel[0] > 0) {
            for (int i = 0; i < sel.length; ++i) {
                int index = sel[i];
                MidiMapping mapping = (MidiMapping)this.mappingListModel.remove(index);
                sel[i] = --index;
                this.mappingListModel.add(index, mapping);
            }
            this.getListMappings().setSelectedIndices(sel);
            this.getListMappings().ensureIndexIsVisible(sel[0]);
        }
    }

    protected void actionMoveDown() {
        int[] sel = this.getListMappings().getSelectedIndices();
        if (sel.length > 0 && sel[sel.length - 1] < this.mappingListModel.getSize() - 1) {
            for (int i = sel.length - 1; i >= 0; --i) {
                int index = sel[i];
                MidiMapping mapping = (MidiMapping)this.mappingListModel.remove(index);
                sel[i] = ++index;
                this.mappingListModel.add(index, mapping);
            }
            this.getListMappings().setSelectedIndices(sel);
            this.getListMappings().ensureIndexIsVisible(sel[sel.length - 1]);
        }
    }

    public boolean showDialog(Component parent, String title) {
        MidiMappingManagerPanel message = this;
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parent, message, title, optionType, messageType);
        return rc == 0;
    }

    protected void actionManageMidiPresets() {
        try {
            PresetManagerPanel panel = new PresetManagerPanel();
            panel.setStudio(this.studio);
            panel.setDeviceName(this.deviceName);
            panel.setPresetName(this.presetName);
            panel.setPresetProducer(this.presetProducer);
            String title = "MIDI Presets";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            Preset newPreset = panel.getSelectedPreset();
            if (newPreset == null) {
                return;
            }
            MidiMapping[] newMappings = MidiMappingUtil.parsePresetMidiMappings(newPreset);
            if (!this.mappingListModel.isEmpty()) {
                int messageType;
                int optionType;
                title = "Append or Replace MIDI Mappings ?";
                String message = "Do you want to keep the existing mappings ? \n\n";
                message = message + "Press 'Yes' to append the mappings. \n";
                int rc = JOptionPane.showConfirmDialog(this, message = message + "Press 'No' to replace the mappings. \n", title, optionType = 1, messageType = 3);
                if (rc == 2) {
                    return;
                }
                if (rc == 1) {
                    this.mappingListModel.removeAllElements();
                }
            }
            for (MidiMapping mapping : newMappings) {
                if (mapping == null) continue;
                this.mappingListModel.addElement(mapping);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public PresetProducer getPresetProducer() {
        return this.presetProducer;
    }

    public void setPresetProducer(PresetProducer presetProducer) {
        this.presetProducer = presetProducer;
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public Preset createMidiMappingPreset() {
        MidiMapping[] mappings = this.getMappings();
        Properties props = MidiMappingUtil.formatPresetMidiMappings(mappings);
        Preset preset = new Preset();
        preset.setProperties(props);
        return preset;
    }

    protected class ActionMoveDown
    extends AbstractAction {
        private static final long serialVersionUID = 541856998331610831L;

        protected ActionMoveDown() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MidiMappingManagerPanel.this.actionMoveDown();
        }
    }

    protected class ActionMoveUp
    extends AbstractAction {
        private static final long serialVersionUID = -6081710239852711067L;

        protected ActionMoveUp() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MidiMappingManagerPanel.this.actionMoveUp();
        }
    }

    protected class ActionRemove
    extends AbstractAction {
        private static final long serialVersionUID = -7217287730649087275L;

        protected ActionRemove() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MidiMappingManagerPanel.this.actionRemove();
        }
    }

    protected class PresetProducerImpl
    implements PresetProducer {
        protected PresetProducerImpl() {
        }

        public Preset createPreset() {
            return MidiMappingManagerPanel.this.createMidiMappingPreset();
        }
    }
}

