/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.midi.MidiFormatter;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.MidiMappingUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MidiMappingPanel
extends JPanel {
    private static final long serialVersionUID = -1316101912130342433L;
    private static final String PROPERTY_MAPPING = "mapping";
    private static final String CHANNEL_OMNI = "Any channel";
    private MidiMapping mapping;
    private MidiAction[] availableActions;
    private MidiFormatter midiFormatter;
    private boolean refreshing;
    private JComboBox comboBoxChannel;
    private JComboBox comboBoxCommand;
    private JComboBox comboBoxIndex;
    private JComboBox comboBoxAction;
    private JLabel lblMidiIndex;

    public MidiMappingPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblNewLabel = new JLabel("Channel:");
        lblNewLabel.setToolTipText("MIDI channel");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        panel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.comboBoxChannel = new JComboBox();
        this.comboBoxChannel.setOpaque(false);
        this.comboBoxChannel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiMappingPanel.this.refreshing) {
                    MidiMappingPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxChannel = new GridBagConstraints();
        gbc_comboBoxChannel.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxChannel.fill = 2;
        gbc_comboBoxChannel.gridx = 1;
        gbc_comboBoxChannel.gridy = 0;
        panel.add((Component)this.comboBoxChannel, gbc_comboBoxChannel);
        JLabel lblNewLabel_1 = new JLabel("Command:");
        lblNewLabel_1.setToolTipText("MIDI command");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 1;
        panel.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.comboBoxCommand = new JComboBox();
        this.comboBoxCommand.setOpaque(false);
        this.comboBoxCommand.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiMappingPanel.this.refreshing) {
                    MidiMappingPanel.this.apply();
                    MidiMappingPanel.this.refreshIndex();
                }
            }
        });
        GridBagConstraints gbc_comboBoxCommand = new GridBagConstraints();
        gbc_comboBoxCommand.weightx = 1.0;
        gbc_comboBoxCommand.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxCommand.fill = 2;
        gbc_comboBoxCommand.gridx = 1;
        gbc_comboBoxCommand.gridy = 1;
        panel.add((Component)this.comboBoxCommand, gbc_comboBoxCommand);
        this.lblMidiIndex = new JLabel("Index:");
        this.lblMidiIndex.setToolTipText("MIDI note/control index");
        GridBagConstraints gbc_lblMidiIndex = new GridBagConstraints();
        gbc_lblMidiIndex.anchor = 17;
        gbc_lblMidiIndex.insets = new Insets(0, 0, 5, 5);
        gbc_lblMidiIndex.gridx = 0;
        gbc_lblMidiIndex.gridy = 2;
        panel.add((Component)this.lblMidiIndex, gbc_lblMidiIndex);
        this.comboBoxIndex = new JComboBox();
        this.comboBoxIndex.setOpaque(false);
        this.comboBoxIndex.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiMappingPanel.this.refreshing) {
                    MidiMappingPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxIndex = new GridBagConstraints();
        gbc_comboBoxIndex.weightx = 1.0;
        gbc_comboBoxIndex.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxIndex.fill = 2;
        gbc_comboBoxIndex.gridx = 1;
        gbc_comboBoxIndex.gridy = 2;
        panel.add((Component)this.comboBoxIndex, gbc_comboBoxIndex);
        JLabel lblAction = new JLabel("Action:");
        lblAction.setToolTipText("Target action");
        GridBagConstraints gbc_lblAction = new GridBagConstraints();
        gbc_lblAction.anchor = 17;
        gbc_lblAction.insets = new Insets(0, 0, 0, 5);
        gbc_lblAction.gridx = 0;
        gbc_lblAction.gridy = 3;
        panel.add((Component)lblAction, gbc_lblAction);
        this.comboBoxAction = new JComboBox();
        this.comboBoxAction.setOpaque(false);
        this.comboBoxAction.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiMappingPanel.this.refreshing) {
                    MidiMappingPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxAction = new GridBagConstraints();
        gbc_comboBoxAction.fill = 2;
        gbc_comboBoxAction.gridx = 1;
        gbc_comboBoxAction.gridy = 3;
        panel.add((Component)this.comboBoxAction, gbc_comboBoxAction);
        this.initMidiActionMappingPanel();
    }

    protected JComboBox getComboBoxChannel() {
        return this.comboBoxChannel;
    }

    protected JComboBox getComboBoxCommand() {
        return this.comboBoxCommand;
    }

    protected JComboBox getComboBoxIndex() {
        return this.comboBoxIndex;
    }

    protected JComboBox getComboBoxAction() {
        return this.comboBoxAction;
    }

    public MidiAction[] getAvailableActions() {
        return this.availableActions;
    }

    public void setAvailableActions(MidiAction[] availableActions) {
        this.availableActions = availableActions;
        this.refreshAction();
    }

    public MidiMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(MidiMapping mapping) {
        this.mapping = mapping;
        this.refresh();
    }

    protected void initMidiActionMappingPanel() {
        this.getComboBoxChannel().removeAllItems();
        this.getComboBoxChannel().addItem(CHANNEL_OMNI);
        for (int i = 0; i < 16; ++i) {
            this.getComboBoxChannel().addItem(String.valueOf(i + 1));
        }
        this.getComboBoxCommand().removeAllItems();
        String[] eventItems = MidiMappingUtil.getCommandItems();
        int numItems = eventItems == null ? 0 : eventItems.length;
        for (int i = 0; i < numItems; ++i) {
            this.getComboBoxCommand().addItem(eventItems[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            int channel = -1;
            int status = -1;
            if (this.mapping != null) {
                channel = this.mapping.getChannel();
                status = this.mapping.getCommand();
            }
            if (channel >= 0 && channel < 16) {
                this.getComboBoxChannel().setSelectedIndex(channel + 1);
            } else {
                this.getComboBoxChannel().setSelectedIndex(0);
            }
            String commandItem = MidiMappingUtil.getCommandItem(status);
            if (commandItem != null) {
                this.getComboBoxCommand().setSelectedItem(commandItem);
            } else {
                this.getComboBoxCommand().setSelectedIndex(-1);
            }
        }
        finally {
            this.refreshing = false;
        }
        this.refreshIndex();
        this.refreshAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshIndex() {
        try {
            String title;
            this.refreshing = true;
            int status = -1;
            int index = -1;
            if (this.mapping != null) {
                status = this.mapping.getCommand();
                index = this.mapping.getIndex();
            }
            if ((title = MidiMappingUtil.getIndexTitle(status, this.midiFormatter)) == null) {
                title = "Index";
            }
            this.getLblMidiIndex().setText(title + ":");
            this.getComboBoxIndex().removeAllItems();
            String[] indexNames = MidiMappingUtil.getIndexNames(status, this.midiFormatter);
            if (indexNames != null) {
                for (int i = 0; i < indexNames.length; ++i) {
                    this.getComboBoxIndex().addItem(indexNames[i]);
                }
            }
            if (index >= 0 && index < this.getComboBoxIndex().getItemCount()) {
                this.getComboBoxIndex().setSelectedIndex(index);
            } else {
                this.getComboBoxIndex().setSelectedIndex(-1);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshAction() {
        try {
            this.refreshing = true;
            String action = null;
            if (this.mapping != null) {
                action = this.mapping.getAction();
            }
            this.getComboBoxAction().removeAllItems();
            int actionIndex = -1;
            if (this.availableActions != null) {
                for (int i = 0; i < this.availableActions.length; ++i) {
                    String name;
                    MidiAction ma = this.availableActions[i];
                    if (ma == null || (name = ma.getName()) == null) continue;
                    if (name.equals(action)) {
                        actionIndex = this.getComboBoxAction().getItemCount();
                    }
                    this.getComboBoxAction().addItem(name);
                }
            }
            this.getComboBoxAction().setSelectedIndex(actionIndex);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        int channel = this.getComboBoxChannel().getSelectedIndex() - 1;
        int command = -1;
        Object eventItem = this.getComboBoxCommand().getSelectedItem();
        if (eventItem != null) {
            command = MidiMappingUtil.getCommandStatus(eventItem);
        }
        int index = this.getComboBoxIndex().getSelectedIndex();
        String action = null;
        Object actionItem = this.getComboBoxAction().getSelectedItem();
        if (actionItem != null) {
            action = String.valueOf(actionItem);
        }
        this.mapping = new MidiMapping(channel, command, index, action);
        this.firePropertyChange(PROPERTY_MAPPING, null, this.mapping);
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getComboBoxChannel().setEnabled(enabled);
        this.getComboBoxCommand().setEnabled(enabled);
        this.getComboBoxIndex().setEnabled(enabled);
        this.getComboBoxAction().setEnabled(enabled);
    }

    protected JLabel getLblMidiIndex() {
        return this.lblMidiIndex;
    }
}

