/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.midi.MidiFormatter;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.studio.Preset;
import java.util.LinkedList;
import java.util.Properties;

public class MidiMappingUtil {
    public static final String MIDI_MAPPING_PREFIX = "MidiMapping.";
    public static final String MIDI_MAPPING_COUNT = "MidiMapping.count";
    public static final String MIDI_TRIGGER_PREFIX = "MidiTrigger.";
    public static final String MIDI_TRIGGER_COUNT = "MidiTrigger.count";
    public static final String COMMAND_NOTE_ON_OFF = "Note-On/Off";
    public static final String COMMAND_CONTROL_CHANGE = "Control-Change";
    public static final String COMMAND_POLY_PRESSURE = "Poly-Pressure";
    public static final String COMMAND_PITCH_BEND = "Pitch-Bend";
    public static final String COMMAND_CHANNEL_PRESSURE = "Channel-Pressure";
    public static final String COMMAND_PROGRAM_CHANGE = "Program-Change";
    public static final String COMMAND_SONG_SELECT = "Song-Select";
    public static final String COMMAND_SONG_POSITION_POINTER = "Song-Position-Pointer";
    public static final String COMMAND_START = "Start";
    public static final String COMMAND_STOP = "Stop";
    public static final String COMMAND_CONTINUE = "Continue";
    public static final String COMMAND_TUNE_REQUEST = "Tune-Request";
    public static final String COMMAND_SYSTEM_RESET = "System-Reset";
    public static final String COMMAND_SYSTEM_EXCLUSIVE = "System-Exclusive";
    private static final String[] COMMAND_ITEMS = new String[]{"Note-On/Off", "Control-Change", "Poly-Pressure", "Pitch-Bend", "Channel-Pressure", "Program-Change", "Song-Select", "Song-Position-Pointer", "Start", "Stop", "Continue", "Tune-Request", "System-Reset", "System-Exclusive"};

    private MidiMappingUtil() {
    }

    public static String[] getCommandItems() {
        int num = COMMAND_ITEMS.length;
        String[] arr = new String[num];
        System.arraycopy(COMMAND_ITEMS, 0, arr, 0, num);
        return arr;
    }

    public static String getCommandItem(int status) {
        switch (status) {
            case 128: 
            case 144: {
                return COMMAND_NOTE_ON_OFF;
            }
            case 176: {
                return COMMAND_CONTROL_CHANGE;
            }
            case 160: {
                return COMMAND_POLY_PRESSURE;
            }
            case 224: {
                return COMMAND_PITCH_BEND;
            }
            case 208: {
                return COMMAND_CHANNEL_PRESSURE;
            }
            case 192: {
                return COMMAND_PROGRAM_CHANGE;
            }
            case 243: {
                return COMMAND_SONG_SELECT;
            }
            case 242: {
                return COMMAND_SONG_POSITION_POINTER;
            }
            case 250: {
                return COMMAND_START;
            }
            case 252: {
                return COMMAND_STOP;
            }
            case 251: {
                return COMMAND_CONTINUE;
            }
            case 246: {
                return COMMAND_TUNE_REQUEST;
            }
            case 255: {
                return COMMAND_SYSTEM_RESET;
            }
            case 240: {
                return COMMAND_SYSTEM_EXCLUSIVE;
            }
        }
        return null;
    }

    public static int getCommandStatus(Object item) {
        if (item == COMMAND_NOTE_ON_OFF) {
            return 144;
        }
        if (item == COMMAND_CONTROL_CHANGE) {
            return 176;
        }
        if (item == COMMAND_POLY_PRESSURE) {
            return 160;
        }
        if (item == COMMAND_PITCH_BEND) {
            return 224;
        }
        if (item == COMMAND_CHANNEL_PRESSURE) {
            return 208;
        }
        if (item == COMMAND_PROGRAM_CHANGE) {
            return 192;
        }
        if (item == COMMAND_SONG_SELECT) {
            return 243;
        }
        if (item == COMMAND_SONG_POSITION_POINTER) {
            return 242;
        }
        if (item == COMMAND_START) {
            return 250;
        }
        if (item == COMMAND_STOP) {
            return 252;
        }
        if (item == COMMAND_CONTINUE) {
            return 251;
        }
        if (item == COMMAND_TUNE_REQUEST) {
            return 246;
        }
        if (item == COMMAND_SYSTEM_RESET) {
            return 255;
        }
        if (item == COMMAND_SYSTEM_EXCLUSIVE) {
            return 240;
        }
        return -1;
    }

    public static String getIndexTitle(int status, MidiFormatter midiFormatter) {
        switch (status) {
            case 128: 
            case 144: 
            case 160: {
                return "Note";
            }
            case 176: {
                return "Control";
            }
            case 192: {
                return "Program";
            }
            case 243: {
                return "Song";
            }
        }
        return null;
    }

    public static String[] getIndexNames(int status, MidiFormatter midiFormatter) {
        switch (status) {
            case 128: 
            case 144: 
            case 160: {
                String[] arr = new String[128];
                for (int i = 0; i < arr.length; ++i) {
                    String name = null;
                    if (midiFormatter != null) {
                        name = midiFormatter.getNoteKeyName(i);
                    }
                    name = name == null ? "#" + i : "#" + i + " (" + name + ")";
                    arr[i] = name;
                }
                return arr;
            }
            case 176: {
                String[] arr = new String[128];
                for (int i = 0; i < arr.length; ++i) {
                    String name = null;
                    if (midiFormatter != null) {
                        name = midiFormatter.getControllerName(i);
                    }
                    name = name == null ? "#" + i : "#" + i + " (" + name + ")";
                    arr[i] = name;
                }
                return arr;
            }
            case 192: 
            case 243: {
                String[] arr = new String[128];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = "#" + i;
                }
                return arr;
            }
        }
        return null;
    }

    public static String[] getValueNames(int status, MidiFormatter midiFormatter) {
        switch (status) {
            case 128: 
            case 144: 
            case 160: 
            case 176: {
                String[] arr = new String[128];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = Integer.toString(i);
                }
                return arr;
            }
            case 192: 
            case 243: {
                return null;
            }
        }
        return null;
    }

    public static Properties formatPresetMidiMappings(MidiMapping[] mappings) {
        Properties props = new Properties();
        int num = mappings == null ? 0 : mappings.length;
        props.setProperty(MIDI_MAPPING_COUNT, Integer.toString(num));
        for (int i = 0; i < num; ++i) {
            String value;
            MidiMapping mapping = mappings[i];
            if (mapping == null || (value = mapping.toString()) == null) continue;
            String key = MIDI_MAPPING_PREFIX + MidiMappingUtil.formatSuffix(i);
            props.setProperty(key, value);
        }
        return props;
    }

    public static Properties formatPresetMidiTriggers(MidiTrigger[] triggers) {
        Properties props = new Properties();
        int num = triggers == null ? 0 : triggers.length;
        props.setProperty(MIDI_TRIGGER_COUNT, Integer.toString(num));
        for (int i = 0; i < num; ++i) {
            String value;
            MidiTrigger trigger = triggers[i];
            if (trigger == null || (value = trigger.toString()) == null) continue;
            String key = MIDI_TRIGGER_PREFIX + MidiMappingUtil.formatSuffix(i);
            props.setProperty(key, value);
        }
        return props;
    }

    public static MidiMapping[] parsePresetMidiMappings(Preset preset) {
        String[] arr;
        Properties props;
        LinkedList<MidiMapping> list = new LinkedList<MidiMapping>();
        if (preset != null && (props = preset.getProperties()) != null && (arr = MidiMappingUtil.parseStringArray(props, MIDI_MAPPING_PREFIX, MIDI_MAPPING_COUNT)) != null) {
            for (String spec : arr) {
                MidiMapping mapping;
                if (spec == null || (mapping = MidiMapping.parseMidiMapping((String)spec)) == null) continue;
                list.add(mapping);
            }
        }
        return list.toArray(new MidiMapping[list.size()]);
    }

    public static MidiTrigger[] parsePresetMidiTriggers(Preset preset) {
        String[] arr;
        Properties props;
        LinkedList<MidiTrigger> list = new LinkedList<MidiTrigger>();
        if (preset != null && (props = preset.getProperties()) != null && (arr = MidiMappingUtil.parseStringArray(props, MIDI_TRIGGER_PREFIX, MIDI_TRIGGER_COUNT)) != null) {
            for (String spec : arr) {
                MidiTrigger trigger;
                if (spec == null || (trigger = MidiTrigger.parseMidiTrigger((String)spec)) == null) continue;
                list.add(trigger);
            }
        }
        return list.toArray(new MidiTrigger[list.size()]);
    }

    protected static String[] parseStringArray(Properties props, String prefix, String countKey) {
        int count;
        if (props == null) {
            return null;
        }
        String sCount = props.getProperty(countKey);
        if (sCount == null) {
            return null;
        }
        try {
            count = Integer.parseInt(sCount.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
        String[] arr = new String[count];
        for (int i = 0; i < count; ++i) {
            String key = prefix + MidiMappingUtil.formatSuffix(i);
            arr[i] = props.getProperty(key);
        }
        return arr;
    }

    protected static String formatSuffix(int index) {
        return Integer.toString(1000 + index).substring(1);
    }
}

