/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.common.MidiMonitorPanel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class MidiMonitor
implements MidiProcessor {
    private static final Logger logger = Logger.getLogger(MidiMonitor.class.getName());
    private final Info info1 = new Info();
    private final Info info2;
    volatile long events;
    volatile Info lastInfo = this.info2 = new Info();
    volatile long lastTimingClockTime;
    volatile long lastActiveSensingTime;
    private volatile MidiMonitorPanel panel;

    public MidiMonitor() {
        this.reset();
    }

    public void process(long time, int status) {
        switch (status) {
            case 248: {
                this.lastTimingClockTime = time;
                return;
            }
            case 254: {
                this.lastActiveSensingTime = time;
                return;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("MidiEvent: time=" + time + ", status=" + status);
        }
        Info info = this.lastInfo == this.info2 ? this.info1 : this.info2;
        info.time = time;
        info.status = status;
        info.data1 = -1;
        info.data2 = -1;
        this.lastInfo = info;
        ++this.events;
        MidiMonitorPanel p = this.panel;
        if (p != null) {
            p.refreshLater();
        }
    }

    public void process(long time, int status, int data1) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("MidiEvent: time=" + time + ", status=" + status + ", data1=" + data1);
        }
        Info info = this.lastInfo == this.info2 ? this.info1 : this.info2;
        info.time = time;
        info.status = status;
        info.data1 = data1;
        info.data2 = -1;
        this.lastInfo = info;
        ++this.events;
        MidiMonitorPanel p = this.panel;
        if (p != null) {
            p.refreshLater();
        }
    }

    public void process(long time, int status, int data1, int data2) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("MidiEvent: time=" + time + ", status=" + status + ", data1=" + data1 + ", data2=" + data2);
        }
        Info info = this.lastInfo == this.info2 ? this.info1 : this.info2;
        info.time = time;
        info.status = status;
        info.data1 = data1;
        info.data2 = data2;
        this.lastInfo = info;
        ++this.events;
        MidiMonitorPanel p = this.panel;
        if (p != null) {
            p.refreshLater();
        }
    }

    public void process(long time, ShortMessage mc) {
        int status = mc.getStatus();
        int len = mc.getLength();
        switch (len) {
            case 1: {
                this.process(time, status);
                return;
            }
            case 2: {
                this.process(time, status, mc.getData1());
                return;
            }
            case 3: {
                this.process(time, status, mc.getData1(), mc.getData2());
                return;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("MidiEvent: time=" + time + ", status=" + status + ", length=" + len + ", message=" + mc);
        }
        Info info = this.lastInfo == this.info2 ? this.info1 : this.info2;
        info.time = time;
        info.status = status;
        info.data1 = mc.getData1();
        info.data2 = mc.getData2();
        this.lastInfo = info;
        ++this.events;
        MidiMonitorPanel p = this.panel;
        if (p != null) {
            p.refreshLater();
        }
    }

    public void process(long time, SysexMessage sm) {
        int status = sm.getStatus();
        int len = sm.getLength();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("MidiEvent: time=" + time + ", status=" + status + ", length=" + len + ", message=" + sm);
        }
        Info info = this.lastInfo == this.info2 ? this.info1 : this.info2;
        info.time = time;
        info.status = status;
        info.data1 = -1;
        info.data2 = -1;
        this.lastInfo = info;
        ++this.events;
        MidiMonitorPanel p = this.panel;
        if (p != null) {
            p.refreshLater();
        }
    }

    public void shutdown() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MidiMonitor stopped: events=" + this.events);
        }
    }

    public void reset() {
        Info info = this.lastInfo == this.info2 ? this.info1 : this.info2;
        info.time = 0L;
        info.status = -1;
        info.data1 = -1;
        info.data2 = -1;
        this.lastInfo = info;
        this.lastTimingClockTime = 0L;
        this.lastActiveSensingTime = 0L;
        this.events = 0L;
        MidiMonitorPanel p = this.panel;
        if (p != null) {
            p.refreshLater();
        }
    }

    final MidiMonitorPanel getPanel() {
        return this.panel;
    }

    final void setPanel(MidiMonitorPanel panel) {
        this.panel = panel;
    }

    protected static class Info {
        long time;
        int status;
        int data1;
        int data2;

        protected Info() {
        }
    }
}

