/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiMonitor;
import com.waxmonster.midi.common.MidiMonitorPanel;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Icon;

public class MidiMonitorDevice
extends Device {
    private final MidiSupportImpl support = new MidiSupportImpl();
    private MidiInputPort inputPort;
    private MidiMonitorPanel midiMonitorPanel;
    private MidiMonitor midiMonitor;

    public MidiMonitorDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.inputPort = new MidiInputPort("MIDI-In", MidiInputPortType.TYPE, (MidiSupport)this.support);
        this.addPort((Port)this.inputPort);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.support.reset();
    }

    public synchronized Component getCustomizer() {
        if (this.midiMonitorPanel == null) {
            this.midiMonitorPanel = new MidiMonitorPanel();
            this.midiMonitorPanel.setOpaque(false);
            this.midiMonitorPanel.setDevice(this);
            this.midiMonitorPanel.setMonitor(this.midiMonitor);
        }
        return this.midiMonitorPanel;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        return props;
    }

    protected void applyProperty(String key, String value) {
    }

    protected class SyncGroupImpl
    extends MidiSyncGroup {
        public SyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
        }

        public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            if (MidiMonitorDevice.this.midiMonitor == null) {
                MidiMonitorDevice.this.midiMonitor = new MidiMonitor();
                MidiMonitorPanel mmp = MidiMonitorDevice.this.midiMonitorPanel;
                if (mmp != null) {
                    mmp.setMonitor(MidiMonitorDevice.this.midiMonitor);
                }
            }
            return MidiMonitorDevice.this.midiMonitor;
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroup syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            MidiMonitorPanel mmp;
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
            if (MidiMonitorDevice.this.midiMonitor != null) {
                MidiMonitorDevice.this.midiMonitor = null;
            }
            if ((mmp = MidiMonitorDevice.this.midiMonitorPanel) != null) {
                mmp.setMonitor(null);
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new SyncGroupImpl(MidiMonitorDevice.this.getName(), new MidiInputPort[]{MidiMonitorDevice.this.inputPort}, new MidiOutputPort[0]);
            }
            return this.syncGroup;
        }
    }
}

