/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.waxmonster.midi.common.MidiMonitor;
import com.waxmonster.midi.common.MidiMonitorDevice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MidiMonitorPanel
extends JPanel {
    private static final long serialVersionUID = 2346743817843132748L;
    private MidiMonitorDevice device;
    private MidiFormatter midiFormatter;
    private MidiMonitor monitor;
    private long oldEvents = -1L;
    private final RefreshLater refreshLater = new RefreshLater();
    private volatile boolean refreshPending;
    private JLabel labelEvents;
    private JLabel labelStatus;
    private JLabel labelLastMsg;
    private JLabel labelData;

    public MidiMonitorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Status", 4, 2, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.fill = 2;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.labelStatus = new JLabel("N/A");
        GridBagConstraints gbc_labelStatus = new GridBagConstraints();
        gbc_labelStatus.anchor = 17;
        gbc_labelStatus.insets = new Insets(0, 4, 0, 0);
        gbc_labelStatus.gridx = 0;
        gbc_labelStatus.gridy = 0;
        panel.add((Component)this.labelStatus, gbc_labelStatus);
        JButton btnReset = new JButton("Reset");
        btnReset.setToolTipText("Reset counters");
        btnReset.setOpaque(false);
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiMonitorPanel.this.actionReset();
            }
        });
        btnReset.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnReset = new GridBagConstraints();
        gbc_btnReset.insets = new Insets(0, 4, 5, 4);
        gbc_btnReset.anchor = 13;
        gbc_btnReset.weightx = 1.0;
        gbc_btnReset.gridx = 1;
        gbc_btnReset.gridy = 0;
        panel.add((Component)btnReset, gbc_btnReset);
        JPanel panelKeys = new JPanel();
        panelKeys.setOpaque(false);
        GridBagConstraints gbc_panelKeys = new GridBagConstraints();
        gbc_panelKeys.insets = new Insets(0, 4, 4, 4);
        gbc_panelKeys.fill = 1;
        gbc_panelKeys.gridx = 0;
        gbc_panelKeys.gridy = 1;
        panel.add((Component)panelKeys, gbc_panelKeys);
        panelKeys.setLayout(new GridLayout(3, 0, 0, 0));
        JLabel label_1 = new JLabel("Events:");
        label_1.setToolTipText("Number of events");
        panelKeys.add(label_1);
        JLabel lblLastMsg = new JLabel("Message:");
        lblLastMsg.setToolTipText("Last MIDI message");
        panelKeys.add(lblLastMsg);
        JLabel lblData = new JLabel("Data:");
        lblData.setToolTipText("Last MIDI data");
        panelKeys.add(lblData);
        JPanel panelValues = new JPanel();
        panelValues.setOpaque(false);
        GridBagConstraints gbc_panelValues = new GridBagConstraints();
        gbc_panelValues.insets = new Insets(0, 0, 4, 4);
        gbc_panelValues.weightx = 1.0;
        gbc_panelValues.fill = 1;
        gbc_panelValues.gridx = 1;
        gbc_panelValues.gridy = 1;
        panel.add((Component)panelValues, gbc_panelValues);
        panelValues.setLayout(new GridLayout(3, 0, 0, 0));
        this.labelEvents = new JLabel("000");
        this.labelEvents.setPreferredSize(new Dimension(80, 16));
        this.labelEvents.setHorizontalAlignment(2);
        panelValues.add(this.labelEvents);
        this.labelLastMsg = new JLabel("000");
        this.labelLastMsg.setPreferredSize(new Dimension(80, 16));
        this.labelLastMsg.setHorizontalAlignment(2);
        panelValues.add(this.labelLastMsg);
        this.labelData = new JLabel("000");
        this.labelData.setPreferredSize(new Dimension(80, 16));
        this.labelData.setHorizontalAlignment(2);
        panelValues.add(this.labelData);
        this.initMidiMonitorPanel();
    }

    private void initMidiMonitorPanel() {
        this.setMidiFormatter((MidiFormatter)DefaultMidiFormatter.getSharedInstance());
        this.actionReset();
    }

    public MidiMonitorDevice getDevice() {
        return this.device;
    }

    public void setDevice(MidiMonitorDevice device) {
        this.device = device;
    }

    protected JLabel getLabelEvents() {
        return this.labelEvents;
    }

    public void refreshLater() {
        if (this.refreshPending) {
            return;
        }
        this.refreshPending = true;
        SwingUtilities.invokeLater(this.refreshLater);
    }

    protected void refresh() {
        MidiMonitor mon = this.monitor;
        if (mon == null) {
            return;
        }
        long events = mon.events;
        if (events != this.oldEvents) {
            int status;
            this.labelEvents.setText(String.valueOf(events));
            String sMsg = null;
            String sData = null;
            MidiMonitor.Info info = mon.lastInfo;
            if (info != null && (status = info.status) >= 0) {
                if (status < 240) {
                    switch (status & 0xF0) {
                        case 176: {
                            sMsg = "Control-Chg. " + this.getMidiChannelName(status);
                            sData = "#" + info.data1 + " = " + info.data2;
                            break;
                        }
                        case 224: {
                            sMsg = "Pitch-Bend " + this.getMidiChannelName(status);
                            int lsb = info.data1 & 0x7F;
                            int msb = info.data2 & 0x7F;
                            int bend = msb << 7 | lsb;
                            sData = String.valueOf(bend);
                            break;
                        }
                        case 160: {
                            sMsg = "Poly-Press. " + this.getMidiChannelName(status);
                            sData = "#" + info.data1 + " (" + this.midiFormatter.getNoteKeyName(info.data1) + ") = " + info.data2;
                            break;
                        }
                        case 144: {
                            sMsg = "Note-On " + this.getMidiChannelName(status);
                            sData = "#" + info.data1 + " (" + this.midiFormatter.getNoteKeyName(info.data1) + ") = " + info.data2;
                            break;
                        }
                        case 128: {
                            sMsg = "Note-Off " + this.getMidiChannelName(status);
                            sData = "#" + info.data1 + " (" + this.midiFormatter.getNoteKeyName(info.data1) + "), " + info.data2;
                            break;
                        }
                        case 208: {
                            sMsg = "Chnl-Press. " + this.getMidiChannelName(status);
                            sData = String.valueOf(info.data1);
                            break;
                        }
                        case 192: {
                            sMsg = "Program-Chg. " + this.getMidiChannelName(status);
                            sData = String.valueOf(info.data1);
                            break;
                        }
                        default: {
                            try {
                                ShortMessage sm = new ShortMessage();
                                sm.setMessage(status, info.data1, info.data2);
                                sMsg = this.midiFormatter.formatMidiMessage((MidiMessage)sm);
                            }
                            catch (InvalidMidiDataException e) {
                                sMsg = "#" + status + ", " + info.data1 + ", " + info.data2;
                            }
                            break;
                        }
                    }
                } else {
                    switch (status) {
                        default: 
                    }
                    try {
                        ShortMessage sm = new ShortMessage();
                        sm.setMessage(status, info.data1, info.data2);
                        sMsg = this.midiFormatter.formatMidiMessage((MidiMessage)sm);
                    }
                    catch (InvalidMidiDataException e) {
                        sMsg = "#" + status + ", " + info.data1 + ", " + info.data2;
                    }
                }
            }
            if (sMsg == null) {
                sMsg = "-";
            }
            this.labelLastMsg.setText(sMsg);
            if (sData == null) {
                sData = "";
            }
            this.labelData.setText(sData);
            this.oldEvents = events;
        }
    }

    private String getMidiChannelName(int status) {
        return "Ch:" + (1 + (status & 0xF));
    }

    protected void actionReset() {
        MidiMonitor mon = this.monitor;
        if (mon != null) {
            mon.reset();
        } else {
            this.oldEvents = 0L;
            String s = "0";
            this.labelEvents.setText(s);
            this.labelLastMsg.setText("-");
            this.labelData.setText("");
            this.labelStatus.setText("Idle");
        }
    }

    public MidiMonitor getMonitor() {
        return this.monitor;
    }

    public synchronized void setMonitor(MidiMonitor newMonitor) {
        if (this.monitor == newMonitor) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.setPanel(null);
        }
        this.monitor = newMonitor;
        String status = "Idle";
        if (newMonitor != null) {
            newMonitor.setPanel(this);
            status = "Active";
        }
        this.labelStatus.setText(status);
    }

    protected JLabel getLabelStatus() {
        return this.labelStatus;
    }

    protected JLabel getLabelLastMsg() {
        return this.labelLastMsg;
    }

    protected JLabel getLabelData() {
        return this.labelData;
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    protected class RefreshLater
    implements Runnable {
        protected RefreshLater() {
        }

        @Override
        public void run() {
            MidiMonitorPanel.this.refreshPending = false;
            MidiMonitorPanel.this.refresh();
        }
    }
}

