/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiTriggerEventTarget;
import com.waxmonster.midi.common.ShortMidiMsg;
import java.util.LinkedList;
import javax.sound.midi.ShortMessage;

public class MidiTriggerEvent {
    private static final ShortMessage[] NO_COMMANDS = new ShortMessage[0];
    private final MidiTriggerEventTarget target;
    private MidiTrigger[] triggers;
    private volatile ShortMessage[] commands;

    public MidiTriggerEvent(MidiTriggerEventTarget target) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        this.target = target;
        this.commands = NO_COMMANDS;
    }

    public synchronized MidiTrigger[] getMidiTriggers() {
        MidiTrigger[] arr = this.triggers;
        int num = arr == null ? 0 : arr.length;
        MidiTrigger[] clone = new MidiTrigger[num];
        if (num > 0) {
            System.arraycopy(arr, 0, clone, 0, num);
        }
        return clone;
    }

    public synchronized void setMidiTriggers(MidiTrigger[] array) {
        this.triggers = array;
        this.refreshCommands();
    }

    protected synchronized void refreshCommands() {
        LinkedList<ShortMessage> list = new LinkedList<ShortMessage>();
        MidiTrigger[] arr = this.triggers;
        if (arr != null) {
            for (MidiTrigger trigger : arr) {
                ShortMessage message = MidiTriggerEvent.createShortMessage(trigger);
                if (message == null) continue;
                list.add(message);
            }
        }
        this.commands = list.toArray(new ShortMessage[list.size()]);
    }

    public static ShortMessage createShortMessage(MidiTrigger trigger) {
        if (trigger == null) {
            return null;
        }
        int channel = trigger.getChannel();
        if (channel < 0 || channel > 15) {
            return null;
        }
        int command = trigger.getCommand();
        switch (command) {
            case 128: 
            case 144: 
            case 160: 
            case 176: {
                int status = command | channel;
                int data1 = trigger.getIndex();
                if (data1 < 0 || data1 > 127) {
                    return null;
                }
                int data2 = trigger.getValue();
                if (data2 < 0 || data2 > 127) {
                    return null;
                }
                return new ShortMidiMsg(status, data1, data2);
            }
            case 192: 
            case 243: {
                int status = command | channel;
                int data1 = trigger.getIndex();
                if (data1 < 0 || data1 > 127) {
                    return null;
                }
                return new ShortMidiMsg(status, data1);
            }
        }
        return null;
    }

    public void fire() {
        MidiProcessor proc = this.target.targetProcessor;
        if (proc == null) {
            return;
        }
        ShortMessage[] cmd = this.commands;
        int num = cmd.length;
        if (num < 1) {
            return;
        }
        long time = -1L;
        for (int i = 0; i < num; ++i) {
            proc.process(time, cmd[i]);
        }
    }
}

