/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.plugin.MidiEventListModel;
import com.spacekiller.util.midi.plugin.MidiLearnPanel;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import com.waxmonster.midi.common.MidiTriggerPanel;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.common.PresetManagerPanel;
import com.waxmonster.studio.common.PresetProducer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MidiTriggerManagerPanel
extends JPanel {
    private static final long serialVersionUID = 39738957896752447L;
    private static final Logger logger = Logger.getLogger(MidiTriggerManagerPanel.class.getName());
    private static final String ACTION_REMOVE = "RemoveSelectedTriggers";
    private static final String ACTION_MOVE_UP = "MoveUpSelectedTriggers";
    private static final String ACTION_MOVE_DOWN = "MoveDownSelectedTriggers";
    private Studio studio;
    private String deviceName;
    private String presetName;
    private PresetProducer presetProducer = new PresetProducerImpl();
    private String[] availableEvents;
    private MidiFormatter midiFormatter;
    private MidiFactory midiFactory;
    private DefaultListModel triggerListModel;
    private boolean refreshing;
    private JList listMappings;
    private MidiTriggerPanel midiTriggerPanel;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JPanel panel_2;
    private JPanel panel_1;
    private JPanel panel_3;
    private JButton buttonLearn;
    private JButton btnMoveup;
    private JButton btnMovedown;
    private JButton btnPresets;

    public MidiTriggerManagerPanel() {
        this.setPreferredSize(new Dimension(600, 300));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Triggers", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 0, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panel.add((Component)scrollPane, gbc_scrollPane);
        this.listMappings = new JList();
        this.listMappings.setOpaque(false);
        this.listMappings.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MidiTriggerManagerPanel.this.refreshSelectedTriggerDetails();
            }
        });
        scrollPane.setViewportView(this.listMappings);
        this.panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(0, 4, 4, 4);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 1;
        panel.add((Component)this.panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.panel_2.setLayout(gbl_panel_2);
        this.buttonAdd = new JButton("");
        this.buttonAdd.setIcon(new ImageIcon(MidiTriggerManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/insert.gif")));
        this.buttonAdd.setMargin(new Insets(2, 4, 2, 4));
        this.buttonAdd.setToolTipText("Add trigger");
        GridBagConstraints gbc_buttonAdd = new GridBagConstraints();
        gbc_buttonAdd.insets = new Insets(0, 0, 0, 5);
        gbc_buttonAdd.gridx = 0;
        gbc_buttonAdd.gridy = 0;
        this.panel_2.add((Component)this.buttonAdd, gbc_buttonAdd);
        this.buttonRemove = new JButton("");
        this.buttonRemove.setIcon(new ImageIcon(MidiTriggerManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/remove_icon16.gif")));
        this.buttonRemove.setMargin(new Insets(2, 4, 2, 4));
        this.buttonRemove.setToolTipText("Remove selected trigger(s)");
        GridBagConstraints gbc_buttonRemove = new GridBagConstraints();
        gbc_buttonRemove.insets = new Insets(0, 0, 0, 5);
        gbc_buttonRemove.gridx = 1;
        gbc_buttonRemove.gridy = 0;
        this.panel_2.add((Component)this.buttonRemove, gbc_buttonRemove);
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiTriggerManagerPanel.this.actionRemove();
            }
        });
        this.btnMoveup = new JButton("");
        GridBagConstraints gbc_btnMoveup = new GridBagConstraints();
        gbc_btnMoveup.insets = new Insets(0, 0, 0, 5);
        gbc_btnMoveup.gridx = 2;
        gbc_btnMoveup.gridy = 0;
        this.panel_2.add((Component)this.btnMoveup, gbc_btnMoveup);
        this.btnMoveup.setToolTipText("Move up...");
        this.btnMoveup.setIcon(new ImageIcon(MidiTriggerManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/mapping_move_up.gif")));
        this.btnMoveup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiTriggerManagerPanel.this.actionMoveUp();
            }
        });
        this.btnMoveup.setMargin(new Insets(2, 2, 2, 2));
        this.btnMovedown = new JButton("");
        GridBagConstraints gbc_btnMovedown = new GridBagConstraints();
        gbc_btnMovedown.insets = new Insets(0, 0, 0, 5);
        gbc_btnMovedown.gridx = 3;
        gbc_btnMovedown.gridy = 0;
        this.panel_2.add((Component)this.btnMovedown, gbc_btnMovedown);
        this.btnMovedown.setToolTipText("Move down...");
        this.btnMovedown.setIcon(new ImageIcon(MidiTriggerManagerPanel.class.getResource("/com/waxmonster/midi/common/icons/mapping_move_down.gif")));
        this.btnMovedown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiTriggerManagerPanel.this.actionMoveDown();
            }
        });
        this.btnMovedown.setMargin(new Insets(2, 2, 2, 2));
        this.btnPresets = new JButton("Presets...");
        this.btnPresets.setToolTipText("Manage presets...");
        this.btnPresets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiTriggerManagerPanel.this.actionManageMidiPresets();
            }
        });
        this.btnPresets.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnPresets = new GridBagConstraints();
        gbc_btnPresets.anchor = 13;
        gbc_btnPresets.weightx = 1.0;
        gbc_btnPresets.gridx = 4;
        gbc_btnPresets.gridy = 0;
        this.panel_2.add((Component)this.btnPresets, gbc_btnPresets);
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiTriggerManagerPanel.this.actionAdd();
            }
        });
        this.panel_1 = new JPanel();
        this.panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Trigger Details", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 1;
        gbc_panel_1.gridy = 0;
        this.add((Component)this.panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panel_1.setLayout(gbl_panel_1);
        this.midiTriggerPanel = new MidiTriggerPanel();
        this.midiTriggerPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (MidiTriggerManagerPanel.this.refreshing) {
                    return;
                }
                if ("trigger".equals(evt.getPropertyName())) {
                    MidiTriggerManagerPanel.this.applyTrigger();
                }
            }
        });
        GridBagConstraints gbc_midiTriggerPanel = new GridBagConstraints();
        gbc_midiTriggerPanel.weighty = 1.0;
        gbc_midiTriggerPanel.weightx = 1.0;
        gbc_midiTriggerPanel.insets = new Insets(4, 4, 5, 4);
        gbc_midiTriggerPanel.fill = 1;
        gbc_midiTriggerPanel.gridx = 0;
        gbc_midiTriggerPanel.gridy = 0;
        this.panel_1.add((Component)this.midiTriggerPanel, gbc_midiTriggerPanel);
        this.midiTriggerPanel.setOpaque(false);
        this.panel_3 = new JPanel();
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.insets = new Insets(0, 4, 4, 4);
        gbc_panel_3.fill = 1;
        gbc_panel_3.gridx = 0;
        gbc_panel_3.gridy = 1;
        this.panel_1.add((Component)this.panel_3, gbc_panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0, 0};
        gbl_panel_3.rowHeights = new int[]{0, 0};
        gbl_panel_3.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_3.setLayout(gbl_panel_3);
        this.buttonLearn = new JButton("Learn...");
        this.buttonLearn.setMargin(new Insets(2, 4, 2, 4));
        this.buttonLearn.setToolTipText("Open MIDI Wizard to learn a message...");
        this.buttonLearn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MidiTriggerManagerPanel.this.actionLearn();
            }
        });
        GridBagConstraints gbc_buttonLearn = new GridBagConstraints();
        gbc_buttonLearn.anchor = 17;
        gbc_buttonLearn.gridx = 0;
        gbc_buttonLearn.gridy = 0;
        this.panel_3.add((Component)this.buttonLearn, gbc_buttonLearn);
        this.initMidiTriggerManagerPanel();
    }

    protected JList getListMappings() {
        return this.listMappings;
    }

    public String[] getAvailableEvents() {
        return this.availableEvents;
    }

    public void setAvailableEvents(String[] availableEvents) {
        this.availableEvents = availableEvents;
        this.getMidiTriggerPanel().setAvailableEvents(availableEvents);
    }

    protected void initMidiTriggerManagerPanel() {
        this.triggerListModel = new DefaultListModel();
        this.listMappings.setModel(this.triggerListModel);
        this.listMappings.getActionMap().put(ACTION_REMOVE, new ActionRemove());
        this.listMappings.getInputMap().put(KeyStroke.getKeyStroke(127, 0), ACTION_REMOVE);
        this.listMappings.getActionMap().put(ACTION_MOVE_UP, new ActionMoveUp());
        this.listMappings.getInputMap().put(KeyStroke.getKeyStroke(38, 8), ACTION_MOVE_UP);
        this.listMappings.getActionMap().put(ACTION_MOVE_DOWN, new ActionMoveDown());
        this.listMappings.getInputMap().put(KeyStroke.getKeyStroke(40, 8), ACTION_MOVE_DOWN);
    }

    public MidiTrigger[] getTriggers() {
        int size = this.triggerListModel.getSize();
        MidiTrigger[] triggers = new MidiTrigger[size];
        for (int i = 0; i < size; ++i) {
            triggers[i] = (MidiTrigger)this.triggerListModel.get(i);
        }
        return triggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggers(MidiTrigger[] triggers) {
        try {
            this.refreshing = true;
            this.triggerListModel.removeAllElements();
            int selIndex = -1;
            if (triggers != null) {
                for (int i = 0; i < triggers.length; ++i) {
                    if (triggers[i] == null) continue;
                    this.triggerListModel.addElement(triggers[i]);
                }
            }
            this.getListMappings().setSelectedIndex(selIndex);
            this.refreshSelectedTriggerDetails();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void refreshSelectedTriggerDetails() {
        int[] sel = this.getListMappings().getSelectedIndices();
        this.buttonRemove.setEnabled(sel.length > 0);
        this.btnMoveup.setEnabled(sel.length > 0 && sel[0] > 0);
        this.btnMovedown.setEnabled(sel.length > 0 && sel[sel.length - 1] < this.triggerListModel.getSize() - 1);
        MidiTrigger trigger = null;
        Object item = this.getListMappings().getSelectedValue();
        if (sel.length == 1 && item != null && item instanceof MidiTrigger) {
            trigger = (MidiTrigger)item;
        }
        this.getMidiTriggerPanel().setTrigger(trigger);
        this.getMidiTriggerPanel().setEnabled(trigger != null);
        this.getButtonLearn().setEnabled(trigger != null);
    }

    protected MidiTriggerPanel getMidiTriggerPanel() {
        return this.midiTriggerPanel;
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
        this.getMidiTriggerPanel().setMidiFormatter(midiFormatter);
    }

    protected void actionAdd() {
        MidiTrigger trigger = new MidiTrigger(null, -1, -1, -1, -1);
        int selIndex = this.triggerListModel.getSize();
        this.triggerListModel.addElement(trigger);
        this.getListMappings().setSelectedIndex(selIndex);
        this.getListMappings().ensureIndexIsVisible(selIndex);
    }

    protected void actionRemove() {
        int[] sel = this.getListMappings().getSelectedIndices();
        for (int i = sel.length - 1; i >= 0; --i) {
            this.triggerListModel.remove(sel[i]);
        }
    }

    protected void applyTrigger() {
        int[] sel = this.getListMappings().getSelectedIndices();
        if (sel.length != 1) {
            return;
        }
        MidiTrigger newTrigger = this.getMidiTriggerPanel().getTrigger();
        if (newTrigger == null) {
            return;
        }
        int selIndex = sel[0];
        this.triggerListModel.set(selIndex, newTrigger);
        this.getListMappings().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionLearn() {
        MidiTrigger oldTrigger = this.getMidiTriggerPanel().getTrigger();
        if (oldTrigger == null) {
            return;
        }
        try {
            MidiFactory factory = this.getMidiFactory();
            if (factory == null) {
                return;
            }
            MidiManager midiManager = factory.createMidiManager();
            try {
                int value;
                int index;
                int command;
                String title = "MIDI Wizard";
                int maxSize = 1000;
                MidiEventListModel model = new MidiEventListModel(maxSize);
                MidiLearnPanel panel = new MidiLearnPanel();
                panel.setMode(0);
                panel.setModel(model);
                panel.setMidiManager(midiManager);
                panel.setMidiFormatter(this.getMidiFormatter());
                panel.selectAllMidiDevices();
                MidiEventListModel.MidiHandler handler = model.getHandler();
                try {
                    midiManager.addMidiListener((MidiListener)handler);
                    if (!MidiLearnPanel.showMidiLearnDialog((Component)this, (String)title, (MidiLearnPanel)panel)) {
                        return;
                    }
                }
                finally {
                    midiManager.removeMidiListener((MidiListener)handler);
                }
                int midiChannel = panel.getMidiChannel();
                int midiController = panel.getMidiController();
                int midiNote = panel.getMidiNote();
                int midiValue = 0;
                String event = oldTrigger.getEvent();
                int channel = midiChannel >= 0 && midiChannel < 16 ? midiChannel : -1;
                if (midiController >= 0 && midiController < 128) {
                    command = 176;
                    index = midiController;
                    value = midiValue;
                } else if (midiNote >= 0 && midiNote < 128) {
                    command = 144;
                    index = midiNote;
                    value = midiValue;
                } else {
                    command = -1;
                    index = -1;
                    value = -1;
                }
                MidiTrigger newTrigger = new MidiTrigger(event, channel, command, index, value);
                this.getMidiTriggerPanel().setTrigger(newTrigger);
                this.applyTrigger();
            }
            finally {
                midiManager.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JButton getButtonLearn() {
        return this.buttonLearn;
    }

    protected MidiFactory lookupMidiFactory() {
        return DefaultMidiFactory.getInstance();
    }

    public MidiFactory getMidiFactory() {
        if (this.midiFactory == null) {
            this.setMidiFactory(this.lookupMidiFactory());
        }
        return this.midiFactory;
    }

    public void setMidiFactory(MidiFactory midiFactory) {
        this.midiFactory = midiFactory;
    }

    protected JButton getBtnMoveup() {
        return this.btnMoveup;
    }

    protected JButton getBtnMovedown() {
        return this.btnMovedown;
    }

    protected void actionMoveUp() {
        int[] sel = this.getListMappings().getSelectedIndices();
        if (sel.length > 0 && sel[0] > 0) {
            for (int i = 0; i < sel.length; ++i) {
                int index = sel[i];
                MidiTrigger trigger = (MidiTrigger)this.triggerListModel.remove(index);
                sel[i] = --index;
                this.triggerListModel.add(index, trigger);
            }
            this.getListMappings().setSelectedIndices(sel);
            this.getListMappings().ensureIndexIsVisible(sel[0]);
        }
    }

    protected void actionMoveDown() {
        int[] sel = this.getListMappings().getSelectedIndices();
        if (sel.length > 0 && sel[sel.length - 1] < this.triggerListModel.getSize() - 1) {
            for (int i = sel.length - 1; i >= 0; --i) {
                int index = sel[i];
                MidiTrigger trigger = (MidiTrigger)this.triggerListModel.remove(index);
                sel[i] = ++index;
                this.triggerListModel.add(index, trigger);
            }
            this.getListMappings().setSelectedIndices(sel);
            this.getListMappings().ensureIndexIsVisible(sel[sel.length - 1]);
        }
    }

    public boolean showDialog(Component parent, String title) {
        MidiTriggerManagerPanel message = this;
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parent, message, title, optionType, messageType);
        return rc == 0;
    }

    protected void actionManageMidiPresets() {
        try {
            PresetManagerPanel panel = new PresetManagerPanel();
            panel.setStudio(this.studio);
            panel.setDeviceName(this.deviceName);
            panel.setPresetName(this.presetName);
            panel.setPresetProducer(this.presetProducer);
            String title = "MIDI Presets";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            Preset newPreset = panel.getSelectedPreset();
            if (newPreset == null) {
                return;
            }
            MidiTrigger[] newTriggers = MidiMappingUtil.parsePresetMidiTriggers(newPreset);
            if (!this.triggerListModel.isEmpty()) {
                int messageType;
                int optionType;
                title = "Append or Replace MIDI Triggers ?";
                String message = "Do you want to keep the existing triggers ? \n\n";
                message = message + "Press 'Yes' to append the triggers. \n";
                int rc = JOptionPane.showConfirmDialog(this, message = message + "Press 'No' to replace the triggers. \n", title, optionType = 1, messageType = 3);
                if (rc == 2) {
                    return;
                }
                if (rc == 1) {
                    this.triggerListModel.removeAllElements();
                }
            }
            for (MidiTrigger trigger : newTriggers) {
                if (trigger == null) continue;
                this.triggerListModel.addElement(trigger);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public PresetProducer getPresetProducer() {
        return this.presetProducer;
    }

    public void setPresetProducer(PresetProducer presetProducer) {
        this.presetProducer = presetProducer;
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public Preset createMidiTriggerPreset() {
        MidiTrigger[] triggers = this.getTriggers();
        Properties props = MidiMappingUtil.formatPresetMidiTriggers(triggers);
        Preset preset = new Preset();
        preset.setProperties(props);
        return preset;
    }

    protected class ActionMoveDown
    extends AbstractAction {
        private static final long serialVersionUID = 541856998331610831L;

        protected ActionMoveDown() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MidiTriggerManagerPanel.this.actionMoveDown();
        }
    }

    protected class ActionMoveUp
    extends AbstractAction {
        private static final long serialVersionUID = -6081710239852711067L;

        protected ActionMoveUp() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MidiTriggerManagerPanel.this.actionMoveUp();
        }
    }

    protected class ActionRemove
    extends AbstractAction {
        private static final long serialVersionUID = -7217287730649087275L;

        protected ActionRemove() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MidiTriggerManagerPanel.this.actionRemove();
        }
    }

    protected class PresetProducerImpl
    implements PresetProducer {
        protected PresetProducerImpl() {
        }

        public Preset createPreset() {
            return MidiTriggerManagerPanel.this.createMidiTriggerPreset();
        }
    }
}

