/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.spacekiller.util.midi.MidiFormatter;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiMappingUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MidiTriggerPanel
extends JPanel {
    private static final long serialVersionUID = 5775982431566517790L;
    private static final String PROPERTY_TRIGGER = "trigger";
    private MidiTrigger trigger;
    private String[] availableEvents;
    private MidiFormatter midiFormatter;
    private boolean refreshing;
    private JComboBox comboBoxEvent;
    private JComboBox comboBoxChannel;
    private JComboBox comboBoxCommand;
    private JComboBox comboBoxIndex;
    private JComboBox comboBoxValue;
    private JLabel lblIndex;

    public MidiTriggerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblEvent = new JLabel("Event:");
        lblEvent.setToolTipText("Source event");
        GridBagConstraints gbc_lblEvent = new GridBagConstraints();
        gbc_lblEvent.anchor = 17;
        gbc_lblEvent.insets = new Insets(0, 0, 5, 5);
        gbc_lblEvent.gridx = 0;
        gbc_lblEvent.gridy = 0;
        this.add((Component)lblEvent, gbc_lblEvent);
        this.comboBoxEvent = new JComboBox();
        this.comboBoxEvent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiTriggerPanel.this.refreshing) {
                    MidiTriggerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxEvent = new GridBagConstraints();
        gbc_comboBoxEvent.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxEvent.fill = 2;
        gbc_comboBoxEvent.gridx = 1;
        gbc_comboBoxEvent.gridy = 0;
        this.add((Component)this.comboBoxEvent, gbc_comboBoxEvent);
        JLabel lblChannel = new JLabel("Channel:");
        lblChannel.setToolTipText("MIDI channel");
        GridBagConstraints gbc_lblChannel = new GridBagConstraints();
        gbc_lblChannel.anchor = 17;
        gbc_lblChannel.insets = new Insets(0, 0, 5, 5);
        gbc_lblChannel.gridx = 0;
        gbc_lblChannel.gridy = 1;
        this.add((Component)lblChannel, gbc_lblChannel);
        this.comboBoxChannel = new JComboBox();
        this.comboBoxChannel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiTriggerPanel.this.refreshing) {
                    MidiTriggerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxChannel = new GridBagConstraints();
        gbc_comboBoxChannel.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxChannel.fill = 2;
        gbc_comboBoxChannel.gridx = 1;
        gbc_comboBoxChannel.gridy = 1;
        this.add((Component)this.comboBoxChannel, gbc_comboBoxChannel);
        JLabel lblCommand = new JLabel("Command:");
        lblCommand.setToolTipText("MIDI command");
        GridBagConstraints gbc_lblCommand = new GridBagConstraints();
        gbc_lblCommand.anchor = 17;
        gbc_lblCommand.insets = new Insets(0, 0, 5, 5);
        gbc_lblCommand.gridx = 0;
        gbc_lblCommand.gridy = 2;
        this.add((Component)lblCommand, gbc_lblCommand);
        this.comboBoxCommand = new JComboBox();
        this.comboBoxCommand.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiTriggerPanel.this.refreshing) {
                    MidiTriggerPanel.this.apply();
                    MidiTriggerPanel.this.refreshIndex();
                }
            }
        });
        GridBagConstraints gbc_comboBoxCommand = new GridBagConstraints();
        gbc_comboBoxCommand.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxCommand.fill = 2;
        gbc_comboBoxCommand.gridx = 1;
        gbc_comboBoxCommand.gridy = 2;
        this.add((Component)this.comboBoxCommand, gbc_comboBoxCommand);
        this.lblIndex = new JLabel("Index:");
        this.lblIndex.setToolTipText("MIDI note/control index");
        GridBagConstraints gbc_lblIndex = new GridBagConstraints();
        gbc_lblIndex.anchor = 17;
        gbc_lblIndex.insets = new Insets(0, 0, 5, 5);
        gbc_lblIndex.gridx = 0;
        gbc_lblIndex.gridy = 3;
        this.add((Component)this.lblIndex, gbc_lblIndex);
        this.comboBoxIndex = new JComboBox();
        this.comboBoxIndex.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiTriggerPanel.this.refreshing) {
                    MidiTriggerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxIndex = new GridBagConstraints();
        gbc_comboBoxIndex.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxIndex.fill = 2;
        gbc_comboBoxIndex.gridx = 1;
        gbc_comboBoxIndex.gridy = 3;
        this.add((Component)this.comboBoxIndex, gbc_comboBoxIndex);
        JLabel lblValue = new JLabel("Value:");
        lblValue.setToolTipText("MIDI value (velocity)");
        GridBagConstraints gbc_lblValue = new GridBagConstraints();
        gbc_lblValue.anchor = 17;
        gbc_lblValue.insets = new Insets(0, 0, 0, 5);
        gbc_lblValue.gridx = 0;
        gbc_lblValue.gridy = 4;
        this.add((Component)lblValue, gbc_lblValue);
        this.comboBoxValue = new JComboBox();
        this.comboBoxValue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MidiTriggerPanel.this.refreshing) {
                    MidiTriggerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxValue = new GridBagConstraints();
        gbc_comboBoxValue.fill = 2;
        gbc_comboBoxValue.gridx = 1;
        gbc_comboBoxValue.gridy = 4;
        this.add((Component)this.comboBoxValue, gbc_comboBoxValue);
        this.initMidiTriggerPanel();
    }

    protected void initMidiTriggerPanel() {
        this.getComboBoxChannel().removeAllItems();
        for (int i = 0; i < 16; ++i) {
            this.getComboBoxChannel().addItem(String.valueOf(i + 1));
        }
        this.getComboBoxCommand().removeAllItems();
        String[] commandItems = MidiMappingUtil.getCommandItems();
        int numItems = commandItems == null ? 0 : commandItems.length;
        for (int i = 0; i < numItems; ++i) {
            this.getComboBoxCommand().addItem(commandItems[i]);
        }
    }

    public String[] getAvailableEvents() {
        return this.availableEvents;
    }

    public void setAvailableEvents(String[] availableEvents) {
        this.availableEvents = availableEvents;
        this.refreshEvent();
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    public MidiTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(MidiTrigger trigger) {
        this.trigger = trigger;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            int channel = -1;
            int status = -1;
            int value = -1;
            if (this.trigger != null) {
                channel = this.trigger.getChannel();
                status = this.trigger.getCommand();
                value = this.trigger.getValue();
            }
            if (channel >= 0 && channel < 16) {
                this.getComboBoxChannel().setSelectedIndex(channel);
            } else {
                this.getComboBoxChannel().setSelectedIndex(-1);
            }
            String commandItem = MidiMappingUtil.getCommandItem(status);
            if (commandItem != null) {
                this.getComboBoxCommand().setSelectedItem(commandItem);
            } else {
                this.getComboBoxCommand().setSelectedIndex(-1);
            }
            if (value >= 0 && value < this.getComboBoxValue().getItemCount()) {
                this.getComboBoxValue().setSelectedIndex(value);
            } else {
                this.getComboBoxValue().setSelectedIndex(-1);
            }
        }
        finally {
            this.refreshing = false;
        }
        this.refreshIndex();
        this.refreshEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshIndex() {
        try {
            int i;
            String title;
            this.refreshing = true;
            int status = -1;
            int index = -1;
            int value = -1;
            if (this.trigger != null) {
                status = this.trigger.getCommand();
                index = this.trigger.getIndex();
                value = this.trigger.getValue();
            }
            if ((title = MidiMappingUtil.getIndexTitle(status, this.midiFormatter)) == null) {
                title = "Index";
            }
            this.getLblIndex().setText(title + ":");
            this.getComboBoxIndex().removeAllItems();
            String[] names = MidiMappingUtil.getIndexNames(status, this.midiFormatter);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    this.getComboBoxIndex().addItem(names[i]);
                }
            }
            if (index >= 0 && index < this.getComboBoxIndex().getItemCount()) {
                this.getComboBoxIndex().setSelectedIndex(index);
            } else {
                this.getComboBoxIndex().setSelectedIndex(-1);
            }
            this.getComboBoxValue().removeAllItems();
            names = MidiMappingUtil.getValueNames(status, this.midiFormatter);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    this.getComboBoxValue().addItem(names[i]);
                }
            }
            if (value >= 0 && value < this.getComboBoxValue().getItemCount()) {
                this.getComboBoxValue().setSelectedIndex(value);
            } else {
                this.getComboBoxValue().setSelectedIndex(-1);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshEvent() {
        try {
            this.refreshing = true;
            String event = null;
            if (this.trigger != null) {
                event = this.trigger.getEvent();
            }
            this.getComboBoxEvent().removeAllItems();
            int eventIndex = -1;
            if (this.availableEvents != null) {
                for (int i = 0; i < this.availableEvents.length; ++i) {
                    String name = this.availableEvents[i];
                    if (name == null) continue;
                    if (name.equals(event)) {
                        eventIndex = this.getComboBoxEvent().getItemCount();
                    }
                    this.getComboBoxEvent().addItem(name);
                }
            }
            this.getComboBoxEvent().setSelectedIndex(eventIndex);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        int channel = this.getComboBoxChannel().getSelectedIndex();
        int command = -1;
        Object commandItem = this.getComboBoxCommand().getSelectedItem();
        if (commandItem != null) {
            command = MidiMappingUtil.getCommandStatus(commandItem);
        }
        int index = this.getComboBoxIndex().getSelectedIndex();
        int value = this.getComboBoxValue().getSelectedIndex();
        String event = null;
        Object eventItem = this.getComboBoxEvent().getSelectedItem();
        if (eventItem != null) {
            event = String.valueOf(eventItem);
        }
        this.trigger = new MidiTrigger(event, channel, command, index, value);
        this.firePropertyChange(PROPERTY_TRIGGER, null, this.trigger);
    }

    protected JComboBox getComboBoxEvent() {
        return this.comboBoxEvent;
    }

    protected JComboBox getComboBoxChannel() {
        return this.comboBoxChannel;
    }

    protected JComboBox getComboBoxCommand() {
        return this.comboBoxCommand;
    }

    protected JComboBox getComboBoxIndex() {
        return this.comboBoxIndex;
    }

    protected JComboBox getComboBoxValue() {
        return this.comboBoxValue;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getComboBoxEvent().setEnabled(enabled);
        this.getComboBoxChannel().setEnabled(enabled);
        this.getComboBoxCommand().setEnabled(enabled);
        this.getComboBoxIndex().setEnabled(enabled);
        this.getComboBoxValue().setEnabled(enabled);
    }

    protected JLabel getLblIndex() {
        return this.lblIndex;
    }
}

