/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import com.waxmonster.midi.MidiAction;
import javax.sound.midi.MidiMessage;

public final class MultiMidiAction
implements MidiAction {
    private final MidiAction[] array;
    private final int count;

    public MultiMidiAction(MidiAction[] array) {
        this.array = array;
        this.count = array.length;
    }

    public MultiMidiAction(MidiAction a, MidiAction b) {
        int num = 0;
        MidiAction[] arr1 = null;
        MidiAction[] arr2 = null;
        if (a != null) {
            if (a instanceof MultiMidiAction) {
                arr1 = ((MultiMidiAction)a).array;
                num += arr1.length;
                a = null;
            } else {
                ++num;
            }
        }
        if (b != null) {
            if (b instanceof MultiMidiAction) {
                arr2 = ((MultiMidiAction)b).array;
                num += arr2.length;
                b = null;
            } else {
                ++num;
            }
        }
        this.count = num;
        this.array = new MidiAction[this.count];
        int index = 0;
        if (a != null) {
            this.array[index++] = a;
        }
        if (arr1 != null) {
            System.arraycopy(arr1, 0, this.array, index, arr1.length);
            index += arr1.length;
        }
        if (b != null) {
            this.array[index++] = b;
        }
        if (arr2 != null) {
            System.arraycopy(arr2, 0, this.array, index, arr2.length);
            index += arr2.length;
        }
    }

    public void invoke(long time, int status, int data1, int data2) {
        int i = 0;
        while (i < this.count) {
            this.array[i++].invoke(time, status, data1, data2);
        }
    }

    public void systemExclusive(long time, MidiMessage mm) {
        int i = 0;
        while (i < this.count) {
            this.array[i++].systemExclusive(time, mm);
        }
    }

    public String getName() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.array[i].getName());
        }
        return sb.toString();
    }

    public String getTitle() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.array[i].getTitle());
        }
        return sb.toString();
    }

    public MidiAction[] getActions() {
        MidiAction[] copy = new MidiAction[this.count];
        System.arraycopy(this.array, 0, copy, 0, this.count);
        return copy;
    }
}

