/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.common;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class ShortMidiMsg
extends ShortMessage {
    protected int status;
    protected int data1;
    protected int data2;

    public ShortMidiMsg(int status) {
        super(null);
        this.status = status;
        this.length = 1;
    }

    public ShortMidiMsg(int status, int data1) {
        super(null);
        this.status = status;
        this.data1 = data1;
        this.length = 2;
    }

    public ShortMidiMsg(int status, int data1, int data2) {
        super(null);
        this.status = status;
        this.data1 = data1;
        this.data2 = data2;
        this.length = 3;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public int getChannel() {
        return this.status & 0xF;
    }

    @Override
    public int getCommand() {
        return this.status & 0xF0;
    }

    @Override
    public int getData1() {
        return this.data1;
    }

    @Override
    public int getData2() {
        return this.data2;
    }

    @Override
    public Object clone() {
        switch (this.length) {
            case 1: {
                return new ShortMidiMsg(this.status);
            }
            case 2: {
                return new ShortMidiMsg(this.status, this.data1);
            }
            case 3: {
                return new ShortMidiMsg(this.status, this.data1, this.data2);
            }
        }
        throw new IllegalStateException("Invalid short message length: " + this.length);
    }

    @Override
    public byte[] getMessage() {
        switch (this.length) {
            case 1: {
                return new byte[]{(byte)this.status};
            }
            case 2: {
                return new byte[]{(byte)this.status, (byte)this.data1};
            }
            case 3: {
                return new byte[]{(byte)this.status, (byte)this.data1, (byte)this.data2};
            }
        }
        throw new IllegalStateException("Invalid short message length: " + this.length);
    }

    @Override
    public void setMessage(int status) throws InvalidMidiDataException {
        this.status = status;
        this.length = 1;
    }

    @Override
    public void setMessage(int status, int data1, int data2) {
        this.status = status;
        this.data1 = data1;
        this.data2 = data2;
        this.length = 3;
    }
}

