/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi;

public class MidiMapping {
    private static final String OMNI_CHANNEL_STRING = "any";
    private final int channel;
    private final int command;
    private final int index;
    private final String action;

    public MidiMapping(int channel, int command, int index, String action) {
        this.channel = channel;
        this.command = command;
        this.index = index;
        this.action = action;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final int getCommand() {
        return this.command;
    }

    public final int getIndex() {
        return this.index;
    }

    public final String getAction() {
        return this.action;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.channel < 0) {
            sb.append(OMNI_CHANNEL_STRING);
        } else {
            sb.append(String.valueOf(this.channel + 1));
        }
        sb.append(", ");
        sb.append(String.valueOf(this.command));
        sb.append(", ");
        sb.append(String.valueOf(this.index));
        sb.append(", ");
        sb.append(String.valueOf(this.action));
        return sb.toString();
    }

    public static MidiMapping parseMidiMapping(String spec) {
        int x = spec.indexOf(44);
        if (x < 0) {
            return null;
        }
        String sChannel = spec.substring(0, x).trim();
        if ((x = (spec = spec.substring(x + 1)).indexOf(44)) < 0) {
            return null;
        }
        String sStatus = spec.substring(0, x).trim();
        if ((x = (spec = spec.substring(x + 1)).indexOf(44)) < 0) {
            return null;
        }
        String sIndex = spec.substring(0, x).trim();
        String action = (x = (spec = spec.substring(x + 1)).indexOf(44)) < 0 ? spec.trim() : spec.substring(0, x).trim();
        int channel = -1;
        if (sChannel != null && !OMNI_CHANNEL_STRING.equals(sChannel)) {
            try {
                channel = Integer.parseInt(sChannel) - 1;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int command = -1;
        if (sStatus != null) {
            try {
                command = Integer.parseInt(sStatus);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int index = -1;
        if (sIndex != null) {
            try {
                index = Integer.parseInt(sIndex);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new MidiMapping(channel, command, index, action);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + this.channel;
        result = 31 * result + this.command;
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MidiMapping other = (MidiMapping)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.channel != other.channel) {
            return false;
        }
        if (this.command != other.command) {
            return false;
        }
        return this.index == other.index;
    }
}

