/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi;

import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Port;

public class MidiOutputPort
extends MidiPort {
    private static final MidiInputPort[] NO_PORTS = new MidiInputPort[0];
    private MidiInputPort[] targetPorts = NO_PORTS;

    public MidiOutputPort(String name, MidiOutputPortType type, MidiSupport support) {
        super(name, type, support);
    }

    protected void applyProperty(String key, String value) {
    }

    public final boolean isConnectable(Port partner) {
        if (partner == null) {
            return false;
        }
        return partner instanceof MidiInputPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void connectionAdded(Connection conn) {
        Port partner = conn.getPartner((Port)this);
        if (partner != null && partner instanceof MidiInputPort) {
            MidiInputPort partnerPort = (MidiInputPort)partner;
            MidiOutputPort midiOutputPort = this;
            synchronized (midiOutputPort) {
                MidiInputPort[] arr = new MidiInputPort[this.targetPorts.length + 1];
                System.arraycopy(this.targetPorts, 0, arr, 0, this.targetPorts.length);
                arr[this.targetPorts.length] = partnerPort;
                this.targetPorts = arr;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void connectionRemoved(Connection conn) {
        Port partner = conn.getPartner((Port)this);
        if (partner != null && partner instanceof MidiInputPort) {
            MidiInputPort partnerPort = (MidiInputPort)partner;
            MidiOutputPort midiOutputPort = this;
            synchronized (midiOutputPort) {
                int num = this.targetPorts.length;
                for (int i = 0; i < num; ++i) {
                    if (this.targetPorts[i] != partnerPort) continue;
                    MidiInputPort[] arr = new MidiInputPort[this.targetPorts.length - 1];
                    System.arraycopy(this.targetPorts, 0, arr, 0, i);
                    System.arraycopy(this.targetPorts, i + 1, arr, i, num - i - 1);
                    this.targetPorts = arr;
                    return;
                }
            }
        }
    }
}

