/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi;

import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.studio.AbstractPortType;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class MidiPortType
extends AbstractPortType {
    protected final String name;
    protected final String tooltip;
    protected final Icon[] icons;

    public MidiPortType(String name, String tooltip, Icon[] icons) {
        this.name = name;
        this.tooltip = tooltip;
        this.icons = icons;
    }

    public final String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Icon getIcon(int iconKind) {
        if (iconKind < 0 || iconKind >= this.icons.length) {
            return null;
        }
        return this.icons[iconKind];
    }

    static Icon[] getIcons(String[] resources) {
        int n = resources.length;
        Icon[] icons = new Icon[n];
        for (int i = 0; i < n; ++i) {
            URL url = MidiPortType.class.getResource(resources[i]);
            if (url == null) continue;
            icons[i] = new ImageIcon(url);
        }
        return icons;
    }

    public String toString() {
        return String.valueOf(this.name);
    }

    public static MidiPortType getMidiPortType(String typeName) {
        MidiInputPortType type = MidiInputPortType.getMidiInputPortType(typeName);
        if (type != null) {
            return type;
        }
        return MidiOutputPortType.getMidiOutputPortType(typeName);
    }
}

