/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi;

import com.waxmonster.midi.MidiEngine;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiProcessor;

public abstract class MidiSyncGroup {
    protected final String name;
    private final MidiInputPort[] inputs;
    private final MidiOutputPort[] outputs;
    private final MidiEngine engine;

    public MidiSyncGroup(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
        this(name, inputPorts, outputPorts, null);
    }

    public MidiSyncGroup(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts, MidiEngine engine) {
        this.name = name;
        this.inputs = inputPorts;
        this.outputs = outputPorts;
        this.engine = engine;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    public final String getName() {
        return this.name;
    }

    public final int getInputPortCount() {
        return this.inputs.length;
    }

    public final MidiInputPort getInputPortAt(int index) {
        return this.inputs[index];
    }

    public final int getInputPortIndex(MidiInputPort port) {
        for (int i = 0; i < this.inputs.length; ++i) {
            if (port != this.inputs[i]) continue;
            return i;
        }
        return -1;
    }

    public final int getOutputPortCount() {
        return this.outputs.length;
    }

    public final MidiOutputPort getOutputPortAt(int index) {
        return this.outputs[index];
    }

    public final int getOutputPortIndex(MidiOutputPort port) {
        for (int i = 0; i < this.outputs.length; ++i) {
            if (port != this.outputs[i]) continue;
            return i;
        }
        return -1;
    }

    public final MidiEngine getMidiEngine() {
        return this.engine;
    }

    public abstract void setTargetMidiProcessors(MidiProcessor[] var1) throws MidiException;

    public abstract MidiProcessor createMidiProcessor(MidiInputPort var1) throws MidiException;
}

