/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi;

import java.util.StringTokenizer;

public class MidiTrigger {
    private final String event;
    private final int channel;
    private final int command;
    private final int index;
    private final int value;

    public MidiTrigger(String event, int channel, int command, int index, int value) {
        this.event = event;
        this.channel = channel;
        this.command = command;
        this.index = index;
        this.value = value;
    }

    public final String getEvent() {
        return this.event;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final int getCommand() {
        return this.command;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.event));
        sb.append(", ");
        sb.append(String.valueOf(this.channel + 1));
        sb.append(", ");
        sb.append(String.valueOf(this.command));
        sb.append(", ");
        sb.append(String.valueOf(this.index));
        sb.append(", ");
        sb.append(String.valueOf(this.value));
        return sb.toString();
    }

    public static MidiTrigger parseMidiTrigger(String spec) {
        int expected = 5;
        int n = 0;
        String[] t = new String[expected];
        StringTokenizer tok = new StringTokenizer(spec, ",", false);
        while (tok.hasMoreTokens()) {
            t[n++] = tok.nextToken();
            if (n < t.length) continue;
        }
        if (n < expected) {
            return null;
        }
        int i = 0;
        String event = i < n ? t[i++] : null;
        String sChannel = i < n ? t[i++] : null;
        int channel = -1;
        if (sChannel != null) {
            try {
                channel = Integer.parseInt(sChannel.trim()) - 1;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String sCommand = i < n ? t[i++] : null;
        int command = -1;
        if (sCommand != null) {
            try {
                command = Integer.parseInt(sCommand.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String sIndex = i < n ? t[i++] : null;
        int index = -1;
        if (sIndex != null) {
            try {
                index = Integer.parseInt(sIndex.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String sValue = i < n ? t[i++] : null;
        int value = -1;
        if (sValue != null) {
            try {
                value = Integer.parseInt(sValue.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new MidiTrigger(event, channel, command, index, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.channel;
        result = 31 * result + this.command;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MidiTrigger other = (MidiTrigger)obj;
        if (this.channel != other.channel) {
            return false;
        }
        if (this.command != other.command) {
            return false;
        }
        if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return this.value == other.value;
    }
}

