/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class BeneBorders {
    private BeneBorders() {
    }

    static void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
        BeneBorders.drawFlush3DBorder(g, x, y, w, h);
        g.setColor(BeneBorders.getPrimaryControl());
        g.drawLine(x + 1, y + 1, x + 1, h - 3);
        g.drawLine(x + 1, y + 1, w - 3, x + 1);
        g.setColor(BeneBorders.getPrimaryControlDarkShadow());
        g.drawLine(x + 2, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, y + 2, w - 2, h - 2);
    }

    static void drawButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        if (active) {
            BeneBorders.drawActiveButtonBorder(g, x, y, w, h);
        } else {
            BeneBorders.drawFlush3DBorder(g, x, y, w, h);
        }
    }

    static void drawDark3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        BeneBorders.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(BeneBorders.getControl());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.setColor(BeneBorders.getControlShadow());
        g.drawLine(1, h - 2, 1, h - 2);
        g.drawLine(w - 2, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    static void drawDark3DBorder(Graphics g, Rectangle r) {
        BeneBorders.drawDark3DBorder(g, r.x, r.y, r.width, r.height);
    }

    static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        BeneBorders.drawButtonBorder(g, x + 1, y + 1, w - 1, h - 1, active);
        g.setColor(BeneBorders.getControlDarkShadow());
        g.drawRect(x, y, w - 3, h - 3);
        g.drawLine(w - 2, 0, w - 2, 0);
        g.drawLine(0, h - 2, 0, h - 2);
    }

    static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(BeneBorders.getControlShadow());
        g.drawRect(0, 0, w - 1, h - 1);
    }

    static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(BeneBorders.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(BeneBorders.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(BeneBorders.getControl());
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    static void drawFlush3DBorder(Graphics g, Rectangle r) {
        BeneBorders.drawFlush3DBorder(g, r.x, r.y, r.width, r.height);
    }

    static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        BeneBorders.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(BeneBorders.getControlShadow());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    static void drawPressed3DBorder(Graphics g, Rectangle r) {
        BeneBorders.drawPressed3DBorder(g, r.x, r.y, r.width, r.height);
    }

    static Color getControl() {
        return new Color(1.0f, 1.0f, 1.0f, 0.1f);
    }

    static Color getControlDarkShadow() {
        return new Color(0.0f, 0.0f, 0.0f, 0.4f);
    }

    static Color getControlHighlight() {
        return new Color(1.0f, 1.0f, 1.0f, 0.4f);
    }

    static Color getControlInfo() {
        return Color.black;
    }

    static Color getControlShadow() {
        return new Color(0.0f, 0.0f, 0.0f, 0.2f);
    }

    static Color getMenuBackground() {
        return Color.gray;
    }

    static Color getPrimaryControl() {
        return new Color(1.0f, 1.0f, 1.0f, 0.1f);
    }

    static Color getPrimaryControlDarkShadow() {
        return new Color(0.0f, 0.0f, 0.0f, 0.4f);
    }

    static Color getPrimaryControlHighlight() {
        return new Color(1.0f, 1.0f, 1.0f, 0.4f);
    }

    static Color getPrimaryControlInfo() {
        return Color.black;
    }

    static Color getPrimaryControlShadow() {
        return new Color(0.0f, 0.0f, 0.0f, 0.2f);
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static class ToggleButtonBorder
    extends ButtonBorder {
        ToggleButtonBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JToggleButton button = (JToggleButton)c;
            ButtonModel model = button.getModel();
            if (!c.isEnabled()) {
                BeneBorders.drawDisabledBorder(g, x, y, w, h);
            } else if (model.isPressed() && model.isArmed()) {
                BeneBorders.drawPressed3DBorder(g, x, y, w, h);
            } else if (model.isSelected()) {
                BeneBorders.drawDark3DBorder(g, x, y, w, h);
            } else {
                BeneBorders.drawFlush3DBorder(g, x, y, w, h);
            }
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JScrollPane scroll = (JScrollPane)c;
            JViewport colHeader = scroll.getColumnHeader();
            int colHeaderHeight = 0;
            if (colHeader != null) {
                colHeaderHeight = colHeader.getHeight();
            }
            JViewport rowHeader = scroll.getRowHeader();
            int rowHeaderWidth = 0;
            if (rowHeader != null) {
                rowHeaderWidth = rowHeader.getWidth();
            }
            g.translate(x, y);
            g.setColor(BeneBorders.getControlDarkShadow());
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(BeneBorders.getControlHighlight());
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(BeneBorders.getControl());
            g.drawLine(w - 2, 2 + colHeaderHeight, w - 2, 2 + colHeaderHeight);
            g.drawLine(1 + rowHeaderWidth, h - 2, 1 + rowHeaderWidth, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!(c instanceof JTextComponent)) {
                if (c.isEnabled()) {
                    BeneBorders.drawFlush3DBorder(g, x, y, w, h);
                } else {
                    BeneBorders.drawDisabledBorder(g, x, y, w, h);
                }
                return;
            }
            if (c.isEnabled() && ((JTextComponent)c).isEditable()) {
                BeneBorders.drawFlush3DBorder(g, x, y, w, h);
            } else {
                BeneBorders.drawDisabledBorder(g, x, y, w, h);
            }
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() && (!model.isPressed() || model.isArmed())) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(BeneBorders.getPrimaryControlDarkShadow());
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(BeneBorders.getPrimaryControlHighlight());
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(1, 2, 1, 2);
            g.drawLine(1, h - 2, 1, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            g.translate(x, y);
            if (c.getParent() instanceof JMenuBar) {
                if (model.isArmed() || model.isSelected()) {
                    g.setColor(BeneBorders.getControlDarkShadow());
                    g.drawLine(0, 0, w - 2, 0);
                    g.drawLine(0, 0, 0, h - 1);
                    g.drawLine(w - 2, 2, w - 2, h - 1);
                    g.setColor(BeneBorders.getPrimaryControlHighlight());
                    g.drawLine(w - 1, 1, w - 1, h - 1);
                    g.setColor(BeneBorders.getMenuBackground());
                    g.drawLine(w - 1, 0, w - 1, 0);
                }
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(BeneBorders.getPrimaryControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.setColor(BeneBorders.getPrimaryControlHighlight());
                g.drawLine(0, h - 1, w - 1, h - 1);
            } else {
                g.setColor(BeneBorders.getPrimaryControlHighlight());
                g.drawLine(0, 0, 0, h - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(BeneBorders.getControlShadow());
            g.drawLine(0, h - 1, w, h - 1);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }
    }

    static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);
        int titleHeight = 0;

        PaletteBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(BeneBorders.getPrimaryControlDarkShadow());
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, 0, w - 2, 0);
            g.drawRect(1, 1, w - 3, h - 3);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int corner = 14;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color shadow;
            Color highlight;
            Color background;
            if (c instanceof JInternalFrame && ((JInternalFrame)c).isSelected()) {
                background = BeneBorders.getPrimaryControlDarkShadow();
                highlight = BeneBorders.getPrimaryControlShadow();
                shadow = BeneBorders.getPrimaryControlInfo();
            } else {
                background = BeneBorders.getControlDarkShadow();
                highlight = BeneBorders.getControlShadow();
                shadow = BeneBorders.getControlInfo();
            }
            g.setColor(background);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            for (int i = 1; i < 5; ++i) {
                g.drawRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1);
            }
            g.setColor(highlight);
            g.drawLine(15, 3, w - 14, 3);
            g.drawLine(3, 15, 3, h - 14);
            g.drawLine(w - 2, 15, w - 2, h - 14);
            g.drawLine(15, h - 2, w - 14, h - 2);
            g.setColor(shadow);
            g.drawLine(14, 2, w - 14 - 1, 2);
            g.drawLine(2, 14, 2, h - 14 - 1);
            g.drawLine(w - 3, 14, w - 3, h - 14 - 1);
            g.drawLine(14, h - 3, w - 14 - 1, h - 3);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JButton button = (JButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    BeneBorders.drawPressed3DBorder(g, x, y, w, h);
                } else if (button.isDefaultButton()) {
                    if (button.hasFocus()) {
                        // empty if block
                    }
                    BeneBorders.drawDefaultButtonBorder(g, x, y, w, h, false);
                } else {
                    if (button.hasFocus()) {
                        // empty if block
                    }
                    BeneBorders.drawButtonBorder(g, x, y, w, h, false);
                }
            } else {
                BeneBorders.drawDisabledBorder(g, x, y, w - 1, h - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }
    }

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c.isEnabled()) {
                BeneBorders.drawFlush3DBorder(g, x, y, w, h);
            } else {
                BeneBorders.drawDisabledBorder(g, x, y, w, h);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }
}

