/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import com.spacekiller.plaf.bene.BeneArea;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.print.PrinterGraphics;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class BeneInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private static final long serialVersionUID = 7216025567241644426L;
    private BeneArea areaActivated = (BeneArea)UIManager.get("InternalFrameUI.beneAreaActivated");
    private BeneArea areaDeactivated = (BeneArea)UIManager.get("InternalFrameUI.beneAreaDeactivated");
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;

    public BeneInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    protected void installTitlePane() {
        super.installTitlePane();
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean leftToRight = true;
        boolean isSelected = this.frame.isSelected();
        ColorUIResource foreground = MetalLookAndFeel.getWindowTitleForeground();
        ColorUIResource shadow = null;
        if (isSelected) {
            if (shadow == null) {
                shadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
            }
            if (foreground == null) {
                foreground = MetalLookAndFeel.getWindowTitleForeground();
            }
        } else {
            foreground = MetalLookAndFeel.getWindowTitleInactiveForeground();
            shadow = MetalLookAndFeel.getControlDarkShadow();
        }
        this.paintBackground(g, this, isSelected);
        int width = this.getWidth();
        int height = this.getHeight();
        int xOffset = leftToRight ? 5 : width - 5;
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 5 : -5;
        }
        String frameTitle = this.frame.getTitle();
        Font f = this.getFont();
        FontMetrics fm = BeneInternalFrameTitlePane.getFontMetrics(this.frame, g, f);
        int titleLength = BeneInternalFrameTitlePane.stringWidth(this.frame, fm, frameTitle);
        if (frameTitle != null) {
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rect = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rect = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rect = this.closeButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
                xOffset -= BeneInternalFrameTitlePane.stringWidth(this.frame, fm, frameTitle);
            }
            titleLength = BeneInternalFrameTitlePane.stringWidth(this.frame, fm, frameTitle);
            BeneInternalFrameTitlePane.drawString(this.frame, g, frameTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    protected void paintBackground(Graphics g, JComponent c, boolean activated) {
        if (activated) {
            if (this.areaActivated != null) {
                this.areaActivated.paintArea(c, g, 0, 0, c.getWidth(), c.getHeight());
            } else {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        } else if (this.areaDeactivated != null) {
            this.areaDeactivated.paintArea(c, g, 0, 0, c.getWidth(), c.getHeight());
        } else {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        return c.getFontMetrics(font);
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        return fm.stringWidth(string);
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        Graphics2D g2d;
        if (text == null || text.length() <= 0) {
            return;
        }
        if (BeneInternalFrameTitlePane.isPrinting(g) && (g2d = BeneInternalFrameTitlePane.getGraphics2D(g)) != null) {
            TextLayout layout = new TextLayout(text, g2d.getFont(), DEFAULT_FRC);
            layout.draw(g2d, x, y);
            return;
        }
        if (BeneInternalFrameTitlePane.drawTextAntialiased(c) && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(text, x, y);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        } else {
            g.drawString(text, x, y);
        }
    }

    static boolean isPrinting(Graphics g) {
        return g instanceof PrinterGraphics || g instanceof PrintGraphics;
    }

    public static Graphics2D getGraphics2D(Graphics g) {
        if (g instanceof Graphics2D) {
            return (Graphics2D)g;
        }
        return null;
    }

    private static boolean drawTextAntialiased(JComponent c) {
        return true;
    }

    static {
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        Object aa = AccessController.doPrivileged(new GetPropertyAction("swing.aatext"));
        AA_TEXT_DEFINED = aa != null;
        AA_TEXT = "true".equals(aa);
    }

    protected static class GetPropertyAction
    implements PrivilegedAction {
        private String theProp;
        private String defaultVal;

        public GetPropertyAction(String theProp) {
            this.theProp = theProp;
        }

        public GetPropertyAction(String theProp, String defaultVal) {
            this.theProp = theProp;
            this.defaultVal = defaultVal;
        }

        public Object run() {
            String value = System.getProperty(this.theProp);
            return value == null ? this.defaultVal : value;
        }
    }
}

