/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class BeneListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -6388297140984996291L;
    private Paint backPaint;
    private Color transListBackground = new Color(0, 0, 0, 0);
    private Color transListSelectionBackground = new Color(255, 255, 200, 100);

    public BeneListCellRenderer() {
        this.setOpaque(false);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setBackPaint(isSelected ? this.getTransListSelectionBackground() : this.getTransListBackground());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            Paint paint = this.getBackPaint();
            if (paint == null) {
                paint = this.getBackground();
            }
            ((Graphics2D)g).setPaint(paint);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    public Color getTransListBackground() {
        return this.transListBackground;
    }

    public Color getTransListSelectionBackground() {
        return this.transListSelectionBackground;
    }

    public void setTransListBackground(Color newLangListBackground) {
        this.transListBackground = newLangListBackground;
    }

    public void setTransListSelectionBackground(Color newLangListSelectionBackground) {
        this.transListSelectionBackground = newLangListSelectionBackground;
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }
}

