/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.plaf.bene;

import com.spacekiller.plaf.bene.BeneArea;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class BeneTabbedPaneUI
extends MetalTabbedPaneUI {
    private Component tabbedPane = null;

    public static ComponentUI createUI(JComponent c) {
        BeneTabbedPaneUI ui = new BeneTabbedPaneUI();
        return ui;
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            return;
        }
        this.tabbedPane = c;
        boolean oldOpaque = c.isOpaque();
        super.installUI(c);
        c.setOpaque(oldOpaque);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        BeneArea area = (BeneArea)UIManager.get(isSelected ? "TabbedPaneUI.beneAreaSelected" : "TabbedPaneUI.beneArea");
        if (area != null) {
            switch (tabPlacement) {
                case 2: {
                    area.paintArea(this.tabbedPane, g, x + 5, y + 1, w - 5, h - 1);
                    area.paintArea(this.tabbedPane, g, x + 2, y + 4, 3, h - 4);
                    break;
                }
                case 3: {
                    area.paintArea(this.tabbedPane, g, x + 2, y, w - 2, h - 3);
                    area.paintArea(this.tabbedPane, g, x + 5, y + (h - 1) - 3, w - 5, 3);
                    break;
                }
                case 4: {
                    area.paintArea(this.tabbedPane, g, x + 1, y + 1, w - 5, h - 1);
                    area.paintArea(this.tabbedPane, g, x + (w - 1) - 3, y + 5, 3, h - 5);
                    break;
                }
                default: {
                    area.paintArea(this.tabbedPane, g, x + 4, y + 2, w - 1 - 3, h - 1 - 1);
                    area.paintArea(this.tabbedPane, g, x + 2, y + 5, 2, h - 5);
                }
            }
        }
    }
}

