/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.aiff;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;

public class AiffMediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "AIFF";
    private static final String DEFAULT_FILE_EXTENSION = ".aif";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".aif", ".aiff"};
    private static final String FILE_FORMAT_TITLE = "Audio Interchange File";
    private SimpleFileFormatSignature aiffSignature;
    private MediaScanner mediaScanner;

    public AiffMediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)"/com/spacekiller/util/media/aiff/icons/aiff_format.png"));
        this.setDefaultExtension(DEFAULT_FILE_EXTENSION);
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        this.aiffSignature = new SimpleFileFormatSignature("AIFF Header", (FileFormat)this, 8, FORMAT_NAME.getBytes());
        this.setSupportedSignatures(new FileFormatSignature[]{this.aiffSignature});
    }

    public int getSupportedMediaFlags() {
        return 1;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            // empty if block
        }
        return this.mediaScanner;
    }
}

