/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.wave;

import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SoundUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class WaveAudioFile
implements AudioFile {
    private static final Logger logger = Logger.getLogger(WaveAudioFile.class.getName());
    private static final byte[] RIFF_TAG = "RIFF".getBytes();
    private static final byte[] WAVE_TAG = "WAVE".getBytes();
    private static final byte[] FORMAT_TAG = "fmt ".getBytes();
    private static final byte[] DATA_TAG = "data".getBytes();
    public static int WAVE_FORMAT_PCM = 1;
    public static int WAVE_FORMAT_IEEE_FLOAT = 3;
    public static int WAVE_FORMAT_ALAW = 6;
    public static int WAVE_FORMAT_MULAW = 7;
    public static int WAVE_FORMAT_EXTENSIBLE = 65534;
    private File file;
    private RandomAccessFile raf;
    private boolean readOnly;
    private AudioFormat audioFormat;
    private int channels;
    private int frameSize;
    private float frameRate;
    private long frameLength;
    private long dataOfs;
    private long dataLen;
    private boolean dirtyHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaveAudioFile(File file, String mode) throws IOException {
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        this.readOnly = mode.indexOf("w") < 0;
        boolean success = false;
        this.raf = new RandomAccessFile(file, mode);
        try {
            this.readFileHeader();
            this.dirtyHeader = false;
            success = true;
        }
        finally {
            if (!success) {
                this.raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaveAudioFile(File file, AudioFormat audioFormat) throws IOException {
        this.file = file;
        this.audioFormat = audioFormat;
        this.channels = audioFormat.getChannels();
        this.frameSize = audioFormat.getFrameSize();
        this.frameRate = audioFormat.getFrameRate();
        this.frameLength = 0L;
        this.dataOfs = -1L;
        this.dataLen = 0L;
        this.readOnly = false;
        boolean success = false;
        this.raf = new RandomAccessFile(file, "rw");
        try {
            this.raf.setLength(0L);
            this.writeFileHeader();
            this.dirtyHeader = false;
            success = true;
        }
        finally {
            if (!success) {
                this.raf.close();
                file.delete();
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.file + "]";
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long framePosition, byte[] dst, int ofs, int len) throws IOException {
        if (framePosition < 0L) {
            throw new IllegalArgumentException("Invalid frame position: " + framePosition);
        }
        int frames = len / this.frameSize;
        long avail = this.frameLength - framePosition;
        if (avail < 1L) {
            return -1;
        }
        if ((long)frames > avail) {
            frames = (int)avail;
        }
        int num = frames * this.frameSize;
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(this.dataOfs + framePosition * (long)this.frameSize);
            this.raf.readFully(dst, ofs, num);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long framePosition, RawSampleBuffer dst, int ofs, int len) throws IOException {
        if (framePosition < 0L) {
            throw new IllegalArgumentException("Invalid frame position: " + framePosition);
        }
        int frames = len / this.frameSize;
        long avail = this.frameLength - framePosition;
        if (avail < 1L) {
            return -1;
        }
        if ((long)frames > avail) {
            frames = (int)avail;
        }
        int num = frames * this.frameSize;
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(this.dataOfs + framePosition * (long)this.frameSize);
            dst.writeFully(ofs, this.raf, num);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long framePosition, byte[] src, int ofs, int len) throws IOException {
        if (this.readOnly) {
            throw new IOException("Audio file is read-only!");
        }
        if (framePosition < 0L) {
            throw new IllegalArgumentException("Invalid frame position: " + framePosition);
        }
        int frames = len / this.frameSize;
        int num = frames * this.frameSize;
        if (num != len) {
            throw new IllegalArgumentException("Invalid length: " + len);
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(this.dataOfs + framePosition * (long)this.frameSize);
            this.raf.write(src, ofs, num);
        }
        long p = framePosition + (long)frames;
        if (p > this.frameLength) {
            this.frameLength = p;
            this.dataLen = p * (long)this.frameSize;
            this.dirtyHeader = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long framePosition, RawSampleBuffer src, int ofs, int len) throws IOException {
        if (this.readOnly) {
            throw new IOException("Audio file is read-only!");
        }
        if (framePosition < 0L) {
            throw new IllegalArgumentException("Invalid frame position: " + framePosition);
        }
        int frames = len / this.frameSize;
        int num = frames * this.frameSize;
        if (num != len) {
            throw new IllegalArgumentException("Invalid length: " + len);
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(this.dataOfs + framePosition * (long)this.frameSize);
            src.read(ofs, this.raf, num);
        }
        long p = framePosition + (long)frames;
        if (p > this.frameLength) {
            this.frameLength = p;
            this.dataLen = p * (long)this.frameSize;
            this.dirtyHeader = true;
        }
    }

    public void flush() throws IOException {
        if (this.dirtyHeader) {
            this.writeFileHeader();
            this.dirtyHeader = false;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.raf.close();
    }

    protected void readFileHeader() throws IOException {
        long pos;
        byte[] x = new byte[4];
        this.raf.seek(0L);
        this.raf.readFully(x);
        if (!new String(x).equals("RIFF")) {
            throw new StreamCorruptedException("File does not contain wave data: " + this.file);
        }
        this.raf.readFully(x);
        this.raf.readFully(x);
        AudioFormat format = null;
        long dataOfs = -1L;
        long dataLen = -1L;
        while ((pos = this.raf.getFilePointer()) < this.raf.length()) {
            this.raf.readFully(x);
            String s = new String(x);
            this.raf.readFully(x);
            int len = WaveAudioFile.getInt32Lsb(x, 0);
            if (s.equals("fmt ")) {
                int wBitsPerSample;
                int nBlockAlign;
                int nAvgBytesPerSec;
                int frameRate;
                int channels;
                byte[] dat = new byte[len];
                this.raf.readFully(dat);
                int wFormatTag = WaveAudioFile.getInt16Lsb(dat, 0);
                if (wFormatTag == WAVE_FORMAT_PCM && len >= 16) {
                    channels = WaveAudioFile.getInt16Lsb(dat, 2);
                    frameRate = WaveAudioFile.getInt32Lsb(dat, 4);
                    nAvgBytesPerSec = WaveAudioFile.getInt32Lsb(dat, 8);
                    nBlockAlign = WaveAudioFile.getInt16Lsb(dat, 12);
                    wBitsPerSample = WaveAudioFile.getInt16Lsb(dat, 14);
                    int sampleRate = frameRate;
                    int sampleSizeInBits = wBitsPerSample;
                    int frameSize = (sampleSizeInBits + 7) / 8 * channels;
                    if (frameSize != nBlockAlign) {
                        throw new StreamCorruptedException("Invalid frame size: " + frameSize + " != " + nBlockAlign);
                    }
                    AudioFormat.Encoding encoding = SoundUtil.PCM_SIGNED;
                    boolean bigEndian = false;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("readFileHeader: wFormatTag=" + wFormatTag + ", channels=" + channels + ", frameRate=" + frameRate + ", bitsPerSample=" + sampleSizeInBits + ", nAvgBytesPerSec=" + nAvgBytesPerSec + ", nBlockAlign=" + nBlockAlign);
                    }
                    format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
                    continue;
                }
                if (wFormatTag == WAVE_FORMAT_IEEE_FLOAT && len >= 18) {
                    channels = WaveAudioFile.getInt16Lsb(dat, 2);
                    frameRate = WaveAudioFile.getInt32Lsb(dat, 4);
                    nAvgBytesPerSec = WaveAudioFile.getInt32Lsb(dat, 8);
                    nBlockAlign = WaveAudioFile.getInt16Lsb(dat, 12);
                    wBitsPerSample = WaveAudioFile.getInt16Lsb(dat, 14);
                    int cbSize = WaveAudioFile.getInt16Lsb(dat, 16);
                    int sampleRate = frameRate;
                    int sampleSizeInBits = wBitsPerSample;
                    int frameSize = (sampleSizeInBits + 7) / 8 * channels;
                    if (frameSize != nBlockAlign) {
                        throw new StreamCorruptedException("Invalid frame size: " + frameSize + " != " + nBlockAlign);
                    }
                    AudioFormat.Encoding encoding = SoundUtil.PCM_FLOAT;
                    boolean bigEndian = false;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("readFileHeader: wFormatTag=" + wFormatTag + ", channels=" + channels + ", frameRate=" + frameRate + ", bitsPerSample=" + sampleSizeInBits + ", nAvgBytesPerSec=" + nAvgBytesPerSec + ", nBlockAlign=" + nBlockAlign + ", cbSize=" + cbSize);
                    }
                    format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
                    continue;
                }
                if (wFormatTag != WAVE_FORMAT_EXTENSIBLE || len >= 40) {
                    // empty if block
                }
                throw new StreamCorruptedException("Unsupported wave format: #" + wFormatTag);
            }
            if (s.equals("data")) {
                dataOfs = pos + 8L;
                dataLen = len;
                break;
            }
            this.raf.skipBytes(len);
        }
        if (format == null) {
            throw new StreamCorruptedException("File does not contain audio format info: " + this.file);
        }
        if (dataOfs < 0L) {
            throw new StreamCorruptedException("File does not contain audio data: " + this.file);
        }
        this.audioFormat = format;
        this.channels = format.getChannels();
        this.frameRate = format.getFrameRate();
        this.frameSize = format.getFrameSize();
        this.frameLength = dataLen / (long)this.frameSize;
        this.dataOfs = dataOfs;
        this.dataLen = dataLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFileHeader() throws IOException {
        if (this.readOnly) {
            throw new IOException("Audio file is read-only!");
        }
        AudioFormat.Encoding encoding = this.audioFormat.getEncoding();
        int channels = this.audioFormat.getChannels();
        int sampleRate = (int)this.audioFormat.getSampleRate();
        int frameSize = this.audioFormat.getFrameSize();
        int sampleBits = this.audioFormat.getSampleSizeInBits();
        boolean bigEndian = this.audioFormat.isBigEndian();
        int wFormatTag = -1;
        int formatChunkSize = 0;
        if (channels > 0 && sampleRate > 0 && frameSize > 0 && sampleBits > 0 && !bigEndian) {
            if (SoundUtil.PCM_SIGNED.equals(encoding)) {
                wFormatTag = WAVE_FORMAT_PCM;
                formatChunkSize = 16;
            } else if (SoundUtil.PCM_FLOAT.equals(encoding)) {
                wFormatTag = WAVE_FORMAT_IEEE_FLOAT;
                formatChunkSize = 18;
            }
        }
        if (wFormatTag < 0) {
            throw new IOException("Unsupported wave audio format: " + this.audioFormat);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(RIFF_TAG);
        byte[] x = new byte[4];
        WaveAudioFile.setInt32Lsb(x, 0, (int)(this.dataLen + 8L + (long)formatChunkSize + 8L + 4L));
        dos.write(x);
        dos.write(WAVE_TAG);
        dos.write(FORMAT_TAG);
        if (wFormatTag == WAVE_FORMAT_PCM || wFormatTag == WAVE_FORMAT_IEEE_FLOAT) {
            WaveAudioFile.setInt32Lsb(x, 0, formatChunkSize);
            dos.write(x);
            WaveAudioFile.setInt16Lsb(x, 0, wFormatTag);
            dos.write(x, 0, 2);
            WaveAudioFile.setInt16Lsb(x, 0, channels);
            dos.write(x, 0, 2);
            WaveAudioFile.setInt32Lsb(x, 0, sampleRate);
            dos.write(x);
            int headerAlign = frameSize;
            long headerBPS2 = sampleRate * frameSize;
            int headerBPS = sampleBits;
            WaveAudioFile.setInt32Lsb(x, 0, (int)headerBPS2);
            dos.write(x);
            WaveAudioFile.setInt16Lsb(x, 0, headerAlign);
            dos.write(x, 0, 2);
            WaveAudioFile.setInt16Lsb(x, 0, headerBPS);
            dos.write(x, 0, 2);
            if (wFormatTag != WAVE_FORMAT_PCM) {
                int cbSize = 0;
                WaveAudioFile.setInt16Lsb(x, 0, cbSize);
                dos.write(x, 0, 2);
            }
        } else {
            throw new IOException("Unsupported wave format: #" + wFormatTag);
        }
        dos.write(DATA_TAG);
        WaveAudioFile.setInt32Lsb(x, 0, (int)this.dataLen);
        dos.write(x);
        dos.flush();
        baos.flush();
        byte[] head = baos.toByteArray();
        dos.close();
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(0L);
            this.raf.write(head, 0, head.length);
        }
        if (this.dataOfs < 0L) {
            this.dataOfs = head.length;
        }
    }

    public String getPath() {
        File f = this.file;
        return f == null ? null : f.getPath();
    }

    public File getFile() {
        return this.file;
    }

    private static int getInt16Lsb(byte[] arr, int o) {
        return arr[o] & 0xFF | arr[o + 1] << 8;
    }

    private static void setInt16Lsb(byte[] arr, int o, int v) {
        arr[o] = (byte)(v & 0xFF);
        arr[o + 1] = (byte)(v >> 8 & 0xFF);
    }

    private static int getInt32Lsb(byte[] arr, int o) {
        return arr[o] & 0xFF | (arr[o + 1] & 0xFF) << 8 | (arr[o + 2] & 0xFF) << 16 | arr[o + 3] << 24;
    }

    private static void setInt32Lsb(byte[] arr, int o, int v) {
        arr[o] = (byte)(v & 0xFF);
        arr[o + 1] = (byte)(v >> 8 & 0xFF);
        arr[o + 2] = (byte)(v >> 16 & 0xFF);
        arr[o + 3] = (byte)(v >> 24 & 0xFF);
    }
}

