/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.wave;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.wave.WaveMediaScanner;

public class WaveMediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "WAVE";
    private static final String DEFAULT_FILE_EXTENSION = ".wav";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".wav"};
    private static final String FILE_FORMAT_TITLE = "Wave Audio File";
    private static final String FILE_FORMAT_ICON = "/com/spacekiller/util/media/wave/icons/wav_format.gif";
    private SimpleFileFormatSignature riffSignature;
    private MediaScanner mediaScanner;

    public WaveMediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)FILE_FORMAT_ICON));
        this.setDefaultExtension(DEFAULT_FILE_EXTENSION);
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        this.riffSignature = new SimpleFileFormatSignature("RIFF Header", (FileFormat)this, 0, "RIFF".getBytes());
        this.setSupportedSignatures(new FileFormatSignature[]{this.riffSignature});
    }

    public int getSupportedMediaFlags() {
        return 1;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            this.mediaScanner = new WaveMediaScanner();
        }
        return this.mediaScanner;
    }
}

