/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.wave;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.serato.SeratoAutotags;
import com.spacekiller.util.media.library.serato.SeratoMarkers2;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;

public class WaveMediaScanner
implements MediaScanner {
    public static final String FORMAT_WAVE = "WAVE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEntry scanMediaResource(Resource resource, MediaEntry me) throws IOException {
        File file = resource.getFile();
        if (file == null) {
            return null;
        }
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        mme.setAudioEntry((AudioEntry)mae);
        mme.setResource(resource);
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            this.parseWaveFile(raf, (MutableMediaEntry)mme, (MutableAudioEntry)mae);
        }
        finally {
            raf.close();
        }
        mme.setFormat(FORMAT_WAVE);
        return mme;
    }

    protected void parseWaveFile(RandomAccessFile raf, MutableMediaEntry mme, MutableAudioEntry mae) throws IOException {
        long pos;
        byte[] x = new byte[4];
        raf.seek(0L);
        raf.readFully(x);
        if (!new String(x).equals("RIFF")) {
            throw new StreamCorruptedException("File does not contain wave data: " + x);
        }
        raf.readFully(x);
        raf.readFully(x);
        int channels = -1;
        int frameRate = -1;
        int bitDepth = -1;
        while ((pos = raf.getFilePointer()) + 8L <= raf.length()) {
            byte[] dat;
            raf.readFully(x);
            String s = new String(x);
            raf.readFully(x);
            int len = WaveMediaScanner.getInt32Lsb(x, 0);
            if (s.equals("fmt ")) {
                dat = new byte[len];
                raf.readFully(dat);
                if (dat.length < 16) continue;
                channels = WaveMediaScanner.getInt16Lsb(dat, 2);
                if (channels > 0) {
                    mae.setChannels(channels);
                }
                if ((frameRate = WaveMediaScanner.getInt32Lsb(dat, 4)) > 0) {
                    mae.setFrameRate((float)frameRate);
                }
                if ((bitDepth = WaveMediaScanner.getInt16Lsb(dat, 14)) <= 0) continue;
                mae.setBitDepth(bitDepth);
                continue;
            }
            if (s.equals("data")) {
                int frameSize;
                raf.skipBytes(len);
                if (channels <= 0 || frameRate <= 0 || bitDepth <= 0 || (frameSize = channels * bitDepth / 8) <= 0) continue;
                long frameCount = len / frameSize;
                mae.setFrameCount(frameCount);
                mme.setDuration((double)frameCount / (double)frameRate);
                continue;
            }
            if (s.equals("id3 ")) {
                int seratoMarkers2Index;
                String autoTags;
                double bpm;
                dat = new byte[len];
                raf.readFully(dat);
                String id3 = new String(dat);
                String search = "Serato Autotags\u0000";
                int seratoAutoTagIndex = id3.indexOf(search);
                if (seratoAutoTagIndex >= 0 && !Double.isNaN(bpm = SeratoAutotags.parseSeratoBPM((byte[])(autoTags = id3.substring(seratoAutoTagIndex + search.length() - 1)).getBytes()))) {
                    mae.setBpmStored(bpm);
                }
                if ((seratoMarkers2Index = id3.indexOf(search = "Serato Markers2\u0000")) < 0) continue;
                String markers2 = id3.substring(seratoMarkers2Index + search.length());
                byte[] base64Input = markers2.getBytes();
                MediaMarker[] seratoMarkers = SeratoMarkers2.parseSeratoMarkers((byte[])base64Input);
                SeratoMarkers2.updateMediaEntrySeratoMarkers((MutableMediaEntry)mme, (MediaMarker[])seratoMarkers);
                continue;
            }
            raf.skipBytes(len);
        }
    }

    private static int getInt16Lsb(byte[] arr, int o) {
        return arr[o] & 0xFF | arr[o + 1] << 8;
    }

    private static int getInt32Lsb(byte[] arr, int o) {
        return arr[o] & 0xFF | (arr[o + 1] & 0xFF) << 8 | (arr[o + 2] & 0xFF) << 16 | arr[o + 3] << 24;
    }
}

