@echo off
REM ========================================================
REM Startup Batch Script for 'Wax Monster'
REM Generated 2025-11-24 09:20:26
REM ========================================================
REM NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED
REM ========================================================

REM change directory to batch-file location...
pushd "%~dp0"

REM main arguments...
set MAIN_ARGS=

REM config-file...
set CONFIG_FILE=config.ini

REM check config-file exists...
if not exist "%CONFIG_FILE%" (
  echo Config file not found: '%CONFIG_FILE%'
  set RC=57
  goto FAIL
)

REM reset variables...
set JAVA_EXEC="";
set JAVAW_EXEC="";
set JAVA_OPTS="";
set MAIN_JAR_FILE="";
set DIST_JAR_FILE="";

REM read variables from config-file...
for /f "delims== tokens=1,*" %%G in (%CONFIG_FILE%) do set %%G=%%H

REM verify variables from config-file...

REM verify mandatory variable: JAVA_EXEC
if 'Missing"%JAVA_EXEC%"' == 'Missing' (
  echo Missing property: 'JAVA_EXEC' in file '%CONFIG_FILE%'
  set RC=57
  goto FAIL
)

REM verify mandatory variable: JAVAW_EXEC
if 'Missing"%JAVAW_EXEC%"' == 'Missing' (
  echo Missing property: 'JAVAW_EXEC' in file '%CONFIG_FILE%'
  set RC=57
  goto FAIL
)

REM verify mandatory variable: MAIN_JAR_FILE
if 'Missing"%MAIN_JAR_FILE%"' == 'Missing' (
  echo Missing property: 'MAIN_JAR_FILE' in file '%CONFIG_FILE%'
  set RC=57
  goto FAIL
)

REM verify mandatory variable: DIST_JAR_FILE
if 'Missing"%DIST_JAR_FILE%"' == 'Missing' (
  echo Missing property: 'DIST_JAR_FILE' in file '%CONFIG_FILE%'
  set RC=57
  goto FAIL
)

REM verify optional variable: JAVA_OPTS
if 'Missing"%JAVA_OPTS%"' == 'Missing' (
  set JAVA_OPTS=
)

REM start application...
"%JAVA_EXEC%" %JAVA_OPTS% "-Dinfection.dist=%DIST_JAR_FILE%" -jar "%MAIN_JAR_FILE%" %MAIN_ARGS% %*

REM handle return-code...
set RC=%ERRORLEVEL%
IF %RC% NEQ 0 (
  echo Command failed: "%JAVA_EXEC%" %JAVA_OPTS% "-Dinfection.dist=%DIST_JAR_FILE%" -jar "%MAIN_JAR_FILE%" %MAIN_ARGS% %*
  echo Error-Code: %RC%
  exit /b %RC%
)

:DONE
set RC=0
exit /b %RC%

:FAIL
echo Failed with error code: %RC%
exit /b %RC%

REM ========================================================
REM NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED
REM ========================================================
