#!/bin/sh
# ========================================================
# Startup Batch Script for 'Wax Monster'
# Generated 2025-11-24 09:20:26
# ========================================================
# NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED
# ========================================================

# change directory to script-file location...
cd $(dirname "${0}")

# main arguments...
MAIN_ARGS=""

# config-file...
CONFIG_FILE="config.ini"

# fail-function...
fail() {
  echo "Failed with error code: ${RC}";
  exit ${RC}
}

# check config-file exists...
if [ ! -f ${CONFIG_FILE} ]; then
  echo "Config file not found: ${CONFIG_FILE}";
  RC=57;
  fail;
fi

# reset variables...
JAVA_EXEC="";
JAVAW_EXEC="";
JAVA_OPTS="";
MAIN_JAR_FILE="";
DIST_JAR_FILE="";

# read variables from config-file...
while IFS== read -r key val ; do
  val=${val%\"}; val=${val#\"}; key=${key#export };
  if [ "${key}" = "" ]; then
    continue;
  elif [ "${key}" = "JAVA_EXEC" ]; then
    JAVA_EXEC=${val};
    continue;
  elif [ "${key}" = "JAVAW_EXEC" ]; then
    JAVAW_EXEC=${val};
    continue;
  elif [ "${key}" = "JAVA_OPTS" ]; then
    JAVA_OPTS=${val};
    continue;
  elif [ "${key}" = "MAIN_JAR_FILE" ]; then
    MAIN_JAR_FILE=${val};
    continue;
  elif [ "${key}" = "DIST_JAR_FILE" ]; then
    DIST_JAR_FILE=${val};
    continue;
  fi
done < ${CONFIG_FILE}

# verify variables from config-file...

# verify mandatory variable: JAVA_EXEC
if [ -z "${JAVA_EXEC}" ]; then
  echo "Missing property: 'JAVA_EXEC' in file '${CONFIG_FILE}'";
  RC=57;
  fail;
fi

# verify mandatory variable: JAVAW_EXEC
if [ -z "${JAVAW_EXEC}" ]; then
  echo "Missing property: 'JAVAW_EXEC' in file '${CONFIG_FILE}'";
  RC=57;
  fail;
fi

# verify mandatory variable: MAIN_JAR_FILE
if [ -z "${MAIN_JAR_FILE}" ]; then
  echo "Missing property: 'MAIN_JAR_FILE' in file '${CONFIG_FILE}'";
  RC=57;
  fail;
fi

# verify mandatory variable: DIST_JAR_FILE
if [ -z "${DIST_JAR_FILE}" ]; then
  echo "Missing property: 'DIST_JAR_FILE' in file '${CONFIG_FILE}'";
  RC=57;
  fail;
fi

# verify optional variable: JAVA_OPTS
if [ -z "${JAVA_OPTS}" ]; then
  JAVA_OPTS="";
fi

# start application...
"${JAVA_EXEC}" ${JAVA_OPTS} "-Dinfection.dist=${DIST_JAR_FILE}" -jar "${MAIN_JAR_FILE}" ${MAIN_ARGS} $*

# handle return-code...
RC=$?
if [ $RC -ne 0 ]; then
  echo "Command failed: "${JAVA_EXEC}" ${JAVA_OPTS} "-Dinfection.dist=${DIST_JAR_FILE}" -jar "${MAIN_JAR_FILE}" ${MAIN_ARGS} $*";
  echo "Error-Code: $RC";
  exit $RC;
fi

# ========================================================
# NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED
# ========================================================
